/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.OpenModel;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.PyroTaskManager;
import pyrosim.mv.ModelView;
import thunderheadeng.io.CopyFile;
import thunderheadeng.util.Task;

public class OpenModelTask
implements Task,
PyroTaskManager.BypassWriteProtection {
    private final PyroSim d_pySim;
    private final PyroMod d_pyMod;
    private final String d_fn;
    private boolean d_success;
    private Throwable d_errOpenModel = null;

    public OpenModelTask(PyroSim pySim, PyroMod pyMod, String fn) {
        this.d_pySim = pySim;
        this.d_pyMod = pyMod;
        this.d_fn = fn;
        this.d_success = false;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
        assert (this.canUndo());
    }

    @Override
    public int getEst() {
        return 1;
    }

    public boolean success() {
        return this.d_success;
    }

    @Override
    public void run() {
        this.d_pyMod.pauseUpdates();
        OpenModel.Callbacks callbacks = new OpenModel.Callbacks(){

            @Override
            public void setSnapToSpacing(double meters) {
                OpenModelTask.this.d_pySim.setSnapToSpacing(meters);
            }

            @Override
            public void setShowBgImagesSelected(boolean flag) {
                OpenModelTask.this.d_pySim.get3DView().getShowBGImagesAction().setSelected(flag);
            }

            @Override
            public void setError(Throwable t) {
                OpenModelTask.this.d_errOpenModel = t;
            }

            @Override
            public void setActiveSnapper(int snapper) {
                OpenModelTask.this.d_pySim.getModelView().setActiveSnapper(snapper);
            }

            @Override
            public void setModelViewFilters(ModelView.ModelViewFilterProps mvProps) {
                OpenModelTask.this.d_pySim.getModelView().setViewFilters(mvProps);
            }

            @Override
            public boolean doBackup() {
                return OpenModelTask.this.doBackup(OpenModelTask.this.d_fn);
            }

            @Override
            public boolean confirmOpenUnsupported(int version) {
                return OpenModelTask.this.confirmOpenUnsupported(version);
            }
        };
        int result = OpenModel.openModel(this.d_pyMod, new File(this.d_fn), true, callbacks);
        if (result == 0) {
            this.commitOpen();
            this.d_pySim.getBackup().createBackupFile(this.d_fn);
            this.d_success = true;
        } else if (result == 3) {
            this.showError(String.format(Intl.intl("Could not open %s.  The file was made with a newer version of PyroSim."), this.d_fn));
        } else if (result == 2) {
            this.showError(String.format(Intl.intl("Could not open %s.  The file was made with an old version of PyroSim."), this.d_fn));
        } else if (result == 4 || result == 6) {
            if (this.d_errOpenModel != null) {
                this.d_errOpenModel.printStackTrace();
            }
            File bakFile = this.d_pySim.getBackup().getBackupFile(this.d_fn);
            String reasonStr = "";
            if (result == 4) {
                reasonStr = "The file may be corrupt.";
            } else if (result == 6) {
                reasonStr = "The file could not be found.";
            }
            if (bakFile == null) {
                this.showError(String.format(Intl.intl("Could not open %s.  %s"), this.d_fn, reasonStr));
            } else {
                int option = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), String.format(Intl.intl("Could not open %s.  %s\nWould you like to open the backup file, %s?"), this.d_fn, reasonStr, bakFile.getAbsolutePath()), Intl.intl("Open Backup File?"), 0);
                if (option == 0) {
                    new OpenModelTask(this.d_pySim, this.d_pyMod, bakFile.getAbsolutePath()).run();
                }
            }
        }
        System.gc();
        this.d_pySim.savePreferences();
        this.d_pyMod.resumeUpdates();
    }

    private void showError(String msg) {
        JFrame parent = this.d_pySim.getActiveFrame();
        JOptionPane.showMessageDialog(parent, msg, Intl.intl("File Error"), 0);
    }

    private void commitOpen() {
        boolean specialFile = this.d_pySim.getBackup().isReservedPath(this.d_fn);
        this.d_pySim.setFilename(this.d_fn, specialFile);
        if (!specialFile) {
            this.d_pySim.getMRUMenu().usedFile(this.d_fn);
        }
        this.d_pyMod.getEvents().changed(this.d_pyMod, PyroMod.EVT_FILENAME_CHANGED, PyroMod.EVT_MODEL_CHANGED);
    }

    private boolean confirmOpenUnsupported(int version) {
        String title = String.format(Intl.intl("Unsupported Version (%d)"), version);
        String msg = Intl.intl("This model was made with a version of PyroSim that is not supported.\nData may be lost during the conversion process, subtle errors may appear\nin the model, and PyroSim may crash.\n\nAttempt to load unsupported data?");
        JFrame parent = this.d_pySim.getActiveFrame();
        int val = JOptionPane.showConfirmDialog(parent, msg, title, 2);
        return val == 0;
    }

    private boolean doBackup(String fn) {
        boolean YES_NO_CANCEL = true;
        String title = Intl.intl("Create Backup File");
        String msg = Intl.intl("This model was made with a previous version of PyroSim.\nSome data may be lost during the conversion process.\nWould you like to create a backup of the original data?");
        JFrame parent = this.d_pySim.getActiveFrame();
        int val = JOptionPane.showConfirmDialog(parent, msg, title, 1);
        if (val == 0) {
            File orig = new File(fn);
            File backup = new File(fn + ".bak");
            try {
                CopyFile.copy(orig, backup);
                String confTitle = Intl.intl("Success");
                String confMsg = Intl.intl("Backup created: " + backup.getName());
                int type = 1;
                JOptionPane.showMessageDialog(parent, confMsg, confTitle, type);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                String errTitle = Intl.intl("Error");
                String errMsg = Intl.intl("PyroSim has encountered an error while trying to \ncreate the backup file.  Open operation aborted. \nError details:\n") + e.getLocalizedMessage();
                int type = 2;
                JOptionPane.showMessageDialog(parent, errMsg, errTitle, type);
                return false;
            }
        }
        return val == 1;
    }
}

