/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.awt.geom.CubicCurve2D;
import java.util.Arrays;

public class theMath {
    private static double[] s_mults = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16};

    public static double[] solveCubic(double a, double b, double c, double d) {
        if (a == 0.0) {
            return theMath.solveQuadratic(b, c, d);
        }
        double[] params = new double[]{d, c, b, a};
        int numRoots = CubicCurve2D.solveCubic(params);
        if (numRoots < 0) {
            return new double[0];
        }
        return Arrays.copyOf(params, numRoots);
    }

    public static double[] solveQuadratic(double a, double b, double c) {
        if (a == 0.0) {
            double[] dArray;
            double root = theMath.solveLinear(b, c);
            if (Double.isNaN(root)) {
                dArray = new double[]{};
            } else {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = root;
            }
            return dArray;
        }
        double b2 = b * b;
        double ac4 = 4.0 * a * c;
        if (b2 < ac4) {
            return new double[0];
        }
        double i2a = 1.0 / (2.0 * a);
        double left = -b * i2a;
        double right = Math.sqrt(b2 - ac4) * i2a;
        double root1 = left + right;
        double root2 = left - right;
        return new double[]{root1, root2};
    }

    public static double solveLinear(double a, double b) {
        if (a == 0.0) {
            return Double.NaN;
        }
        return -b / a;
    }

    public static double round(double val, int decimalPlaces) {
        double multiplier = s_mults[decimalPlaces];
        double rval = Math.rint(val * multiplier) / multiplier;
        if (rval == -0.0) {
            rval = 0.0;
        }
        return rval;
    }

    public static double round(double val, double tol) {
        double rval = Math.rint(val / tol) * tol;
        if (rval == -0.0) {
            rval = 0.0;
        }
        return rval;
    }
}

