/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.Serializable;
import java.util.Random;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ICurve;

public class UniformCurve
implements ICurve,
Serializable {
    static final long serialVersionUID = 1L;
    private final UnitDouble d_min;
    private final UnitDouble d_max;

    public UniformCurve(UnitDouble min, UnitDouble max) {
        this.d_min = min;
        this.d_max = max;
    }

    public int hashCode() {
        return 944781 + this.d_min.hashCode() + this.d_max.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UniformCurve)) {
            return false;
        }
        UniformCurve curve = (UniformCurve)obj;
        return this.d_min.equals(curve.d_min) && this.d_max.equals(curve.d_max);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.d_min.toString());
        sb.append(", ");
        sb.append(this.d_max.toString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public UnitDouble getMin() {
        return this.d_min;
    }

    @Override
    public UnitDouble getMax() {
        return this.d_max;
    }

    @Override
    public UnitDouble getAvg() {
        Unit baseUnit = this.d_min.getUnit();
        double avg = (this.d_min.get(baseUnit) + this.d_max.get(baseUnit)) / 2.0;
        return new UnitDouble(avg, baseUnit);
    }

    @Override
    public UnitDouble getValue(Random rand) {
        double t = rand.nextDouble();
        return this.d_max.sub(this.d_min).scale(t).add(this.d_min);
    }
}

