/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.Serializable;
import java.util.Random;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.UniformCurve;

public class StdNormCurve
implements ICurve,
Serializable {
    static final long serialVersionUID = 1L;
    private final UnitDouble d_min;
    private final UnitDouble d_max;
    private final UnitDouble d_mean;
    private final UnitDouble d_stdDev;

    public StdNormCurve(UnitDouble min, UnitDouble max, UnitDouble mean, UnitDouble stdDev) {
        assert (stdDev.getValueNoUnit() >= 0.0);
        this.d_min = min;
        this.d_max = max;
        this.d_mean = mean;
        this.d_stdDev = stdDev;
    }

    public int hashCode() {
        return 420575 + this.d_min.hashCode() + this.d_max.hashCode() + this.d_mean.hashCode() + this.d_stdDev.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StdNormCurve)) {
            return false;
        }
        StdNormCurve curve = (StdNormCurve)obj;
        return this.d_min.equals(curve.d_min) && this.d_max.equals(curve.d_max) && this.d_mean.equals(curve.d_mean) && this.d_stdDev.equals(curve.d_stdDev);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("u=");
        sb.append(this.d_mean.toString());
        sb.append(" s=");
        sb.append(this.d_stdDev.toString());
        sb.append(" [");
        sb.append(this.d_min.toString());
        sb.append(", ");
        sb.append(this.d_max.toString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public UnitDouble getMin() {
        return this.d_min;
    }

    @Override
    public UnitDouble getMax() {
        return this.d_max;
    }

    @Override
    public UnitDouble getAvg() {
        return this.d_mean;
    }

    public UnitDouble getStdDev() {
        return this.d_stdDev;
    }

    @Override
    public UnitDouble getValue(Random rand) {
        UnitDouble value;
        int timeout = 0;
        do {
            double gauss = rand.nextGaussian();
            value = this.d_stdDev.scale(gauss).add(this.d_mean);
            if (++timeout <= 100) continue;
            return new UniformCurve(this.d_min, this.d_max).getValue(rand);
        } while (value.compareTo(this.d_min) < 0 || value.compareTo(this.d_max) > 0);
        return value.convert(this.d_mean.getUnit());
    }
}

