/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Random;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.theUtil;

public class LogNormCurve
implements ICurve,
Serializable {
    static final long serialVersionUID = 1L;
    private final UnitDouble d_logMean;
    private final UnitDouble d_logstdev;
    private final UnitDouble d_min;
    private final UnitDouble d_max;
    @Deprecated
    private final UnitDouble d_mean = null;
    @Deprecated
    private final UnitDouble d_stdev = null;

    public LogNormCurve(UnitDouble min, UnitDouble max, UnitDouble logMean, UnitDouble logstdev) {
        assert (logstdev.getValueNoUnit() >= 0.0);
        this.d_min = min;
        this.d_max = max;
        this.d_logMean = logMean;
        this.d_logstdev = logstdev;
    }

    public int hashCode() {
        return 261628922 + this.d_min.hashCode() + this.d_max.hashCode() + this.d_logMean.hashCode() + this.d_logstdev.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogNormCurve)) {
            return false;
        }
        LogNormCurve curve = (LogNormCurve)obj;
        return this.d_min.equals(curve.d_min) && this.d_max.equals(curve.d_max) && this.d_logMean.equals(curve.d_logMean) && this.d_logstdev.equals(curve.d_logstdev);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("mu=");
        sb.append(this.d_logMean.toString());
        sb.append(" sigma=");
        sb.append(this.d_logstdev.toString());
        sb.append(" [");
        sb.append(this.d_min);
        sb.append(", ");
        sb.append(this.d_max);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public UnitDouble getValue(Random rand) {
        UnitDouble finalNum;
        Unit unit = this.d_logstdev.getUnit();
        double logMean = this.d_logMean.getValueNoUnit();
        double logStDev = this.d_logstdev.getValueNoUnit();
        int timeout = 0;
        do {
            double num = Math.sqrt(-2.0 * Math.log(rand.nextDouble())) * Math.sin(Math.PI * 2 * rand.nextDouble());
            num = Math.exp(logMean + num * logStDev);
            finalNum = new UnitDouble(num, unit);
            if (++timeout <= 100) continue;
            return new UniformCurve(this.d_min, this.d_max).getValue(rand);
        } while (finalNum.compareTo(this.d_min) < 0 || finalNum.compareTo(this.d_max) > 0);
        return finalNum;
    }

    @Deprecated
    private double getLogMean(Unit unit) {
        double quot = this.d_stdev.getValue(unit) / this.d_mean.getValue(unit);
        return Math.log(this.d_mean.getValue(unit)) - 0.5 * Math.log(1.0 + quot * quot);
    }

    @Deprecated
    private double getLogStDev(Unit unit) {
        double quot = this.d_stdev.getValue(unit) / this.d_mean.getValue(unit);
        return Math.sqrt(Math.log(1.0 + quot * quot));
    }

    @Override
    public UnitDouble getMax() {
        return this.d_max;
    }

    @Override
    public UnitDouble getMin() {
        return this.d_min;
    }

    @Override
    public UnitDouble getAvg() {
        return this.d_logMean;
    }

    public UnitDouble getStDev() {
        return this.d_logstdev;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.d_mean != null || this.d_stdev != null) {
            try {
                Unit u = this.d_mean.getUnit();
                theUtil.assignFinalField(this, this.getClass(), "d_logMean", new UnitDouble(this.getLogMean(u), u));
                theUtil.assignFinalField(this, this.getClass(), "d_logstdev", new UnitDouble(this.getLogStDev(u), u));
                theUtil.assignFinalField(this, this.getClass(), "d_mean", null);
                theUtil.assignFinalField(this, this.getClass(), "d_stdev", null);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static void main(String[] args) {
        UnitDouble min = new UnitDouble(0.0, null);
        UnitDouble max = new UnitDouble(15.0, null);
        UnitDouble scale = new UnitDouble(1.46, null);
        UnitDouble loc = new UnitDouble(0.55, null);
        LogNormCurve curve = new LogNormCurve(min, max, scale, loc);
        Random rand = new Random();
        try {
            File file = new File("C:/Users/spare/logNormOutput.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < 10000; ++i) {
                bw.write(String.format("%f", curve.getValue(rand).getValueNoUnit()));
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }
}

