/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.filters;

import java.io.Serializable;
import thunderheadeng.util.filters.ISignalFilter;

public class EQBiquadFilter
implements ISignalFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double b0a0;
    private final double b1a0;
    private final double b2a0;
    private final double a1a0;
    private final double a2a0;
    private double x_n1;
    private double x_n2;
    private double y_n1;
    private double y_n2;

    protected EQBiquadFilter(double b0, double b1, double b2, double a0, double a1, double a2, double y0) {
        this.b0a0 = b0 / a0;
        this.b1a0 = b1 / a0;
        this.b2a0 = b2 / a0;
        this.a1a0 = a1 / a0;
        this.a2a0 = a2 / a0;
        this.y_n1 = this.y_n2 = y0;
        this.x_n2 = this.y_n2;
        this.x_n1 = this.y_n2;
    }

    @Override
    public double filter(double x) {
        double y = this.b0a0 * x + this.b1a0 * this.x_n1 + this.b2a0 * this.x_n2 - this.a1a0 * this.y_n1 - this.a2a0 * this.y_n2;
        this.x_n2 = this.x_n1;
        this.x_n1 = x;
        this.y_n2 = this.y_n1;
        this.y_n1 = y;
        return y;
    }

    public static EQBiquadFilter lfp(double f0, double Fs, double Q, double y0) {
        double w0 = Math.PI * 2 * f0 / Fs;
        double cos_w0 = Math.cos(w0);
        double alpha = Math.sin(w0) / (2.0 * Q);
        double b0 = (1.0 - cos_w0) / 2.0;
        double b1 = 1.0 - cos_w0;
        double b2 = b0;
        double a0 = 1.0 + alpha;
        double a1 = -2.0 * cos_w0;
        double a2 = 1.0 - alpha;
        return new EQBiquadFilter(b0, b1, b2, a0, a1, a2, y0);
    }
}

