/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class UncUtil {
    public static boolean isShared(String filename) throws IOException {
        return UncUtil.isShared(filename, UncUtil.buildSharedMap());
    }

    private static boolean iStartsWith(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.toLowerCase().startsWith(b.toLowerCase());
    }

    private static String iReplaceFirst(String src, String search, String repl) {
        int pos = src.toLowerCase().indexOf(search.toLowerCase());
        if (pos == -1) {
            return src;
        }
        String head = src.substring(0, pos);
        String tail = src.substring(pos + search.length());
        return head + repl + tail;
    }

    public static boolean isShared(String filename, Map<String, String> sharedMap) {
        if (!filename.contains("\\")) {
            filename = filename + "\\";
        }
        Set<String> sharedSet = sharedMap.keySet();
        for (String key : sharedSet) {
            if (!UncUtil.iStartsWith(filename, key)) continue;
            return true;
        }
        return false;
    }

    public static String convertToLocal(String filename) throws IOException {
        return UncUtil.convertToLocal(filename, UncUtil.buildSharedMap());
    }

    public static String convertToLocal(String filename, Map<String, String> sharedMap) {
        if (filename == null || !filename.startsWith("\\\\")) {
            return filename;
        }
        String shortestLocalPath = null;
        for (Map.Entry<String, String> entry : sharedMap.entrySet()) {
            if (!UncUtil.iStartsWith(filename, entry.getValue())) continue;
            String key = entry.getKey();
            if (key.endsWith("\\")) {
                key = key.substring(0, key.length() - 1);
            }
            String localPath = key + filename.substring(entry.getValue().length());
            if (shortestLocalPath != null && localPath.length() >= shortestLocalPath.length()) continue;
            shortestLocalPath = localPath;
        }
        return shortestLocalPath != null ? shortestLocalPath : filename;
    }

    public static String convertToUnc(String filename) throws IOException {
        return UncUtil.convertToUnc(filename, UncUtil.buildSharedMap());
    }

    public static String convertToUnc(String filename, Map<String, String> sharedMap) {
        if (!filename.contains("\\")) {
            filename = filename + "\\";
        }
        ArrayList<String> sharedList = new ArrayList<String>(sharedMap.keySet());
        Collections.sort(sharedList, new LengthSorter());
        for (int i = 0; i < sharedList.size(); ++i) {
            String key = (String)sharedList.get(i);
            if (!UncUtil.iStartsWith(filename, key)) continue;
            String value = sharedMap.get(key);
            if (!value.endsWith("\\")) {
                value = value + "\\";
            }
            filename = UncUtil.iReplaceFirst(filename, key, value);
            return filename;
        }
        return filename;
    }

    public static Map<String, String> buildSharedMap() throws IOException {
        StringBuffer pout;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            pout = new StringBuffer();
            UncUtil.execBlocking(Arrays.asList("powershell.exe", "-Command", "\"& {get-WmiObject -class Win32_Share -filter 'Type = 0' | select Path, Name | ConvertTo-Csv}\""), pout, System.err, 10000);
            UncUtil.addMapEntriesFromCsv(result, pout.toString(), true);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            pout = new StringBuffer();
            UncUtil.execBlocking(Arrays.asList("powershell.exe", "-Command", "\"& {get-WmiObject -class Win32_MappedLogicalDisk | select Name, ProviderName | ConvertTo-Csv}\""), pout, System.err, 10000);
            UncUtil.addMapEntriesFromCsv(result, pout.toString(), false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void execBlocking(List<String> command, Appendable sout, Appendable serr, int waitForMs) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        p.getOutputStream().close();
        Thread tOut = new Thread(() -> UncUtil.consume(p.getInputStream(), sout));
        tOut.start();
        Thread tErr = new Thread(() -> UncUtil.consume(p.getErrorStream(), serr));
        tErr.start();
        if (!p.waitFor(waitForMs, TimeUnit.MILLISECONDS)) {
            System.err.println("[UncUtil] process time out");
            p.destroyForcibly();
        }
        tOut.interrupt();
        tErr.interrupt();
        tOut.join();
        tErr.join();
    }

    private static void consume(InputStream is, Appendable sink) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line = reader.readLine();
            while (line != null) {
                sink.append(line);
                sink.append(System.lineSeparator());
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addMapEntriesFromCsv(Map<String, String> map, String data, boolean convertToUNC) throws IOException {
        if (data == null || data.isEmpty()) {
            return;
        }
        String hostname = UncUtil.getHostname();
        String[] lines = data.split("\\R");
        boolean skipHeader = true;
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            if (skipHeader) {
                skipHeader = false;
                continue;
            }
            String[] tokens = line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            if (tokens.length != 2) continue;
            String name = tokens[0].replaceAll("^\"|\"$", "");
            String path = tokens[1].replaceAll("^\"|\"$", "");
            if (name.isEmpty() || path.isEmpty()) continue;
            if (convertToUNC) {
                path = path.contains(":") ? String.format("\\\\%s\\%s", hostname, path.substring(path.indexOf(":") + 2)) : String.format("\\\\%s\\%s", hostname, path);
            }
            map.put(name, path);
        }
    }

    private static String getHostname() throws IOException {
        InetAddress addr = InetAddress.getLocalHost();
        String hostname = addr.getHostName();
        return hostname;
    }

    public static void main(String[] args) {
        List<String> testPaths = Arrays.asList("C:\\Users\\spare\\Desktop\\MyGreatStuff\\woot.text", "C:\\my share\\my stuff\\secrets\\DONTreadMe.txt", "Y:\\multi_mesh.psm", "Z:", "\\\\squall\\Users\\", "\\\\autumn\\my share\\untitled\\untitled.psm", "C:\\Users\\thornton\\Desktop\\case-26895\\untitled.psm", "\\\\tempest\\my share with space\\untitled.psm", "Z:\\temp\\case-26895\\untitled.psm", "Z:\\temp\\case-26895\\ZzZitled.psm", "");
        for (String filename : testPaths) {
            try {
                System.out.printf("isShared(\"%s\"): %s%n", filename, UncUtil.isShared(filename));
                System.out.printf("convertToUnc(\"%s\"): \"%s\"%n", filename, UncUtil.convertToUnc(filename));
                System.out.printf("convertToLocal(\"%s\"): \"%s\"%n", filename, UncUtil.convertToLocal(filename));
                System.out.printf("convertToLocal(convertToUnc(\"%s\")): \"%s\"%n", UncUtil.convertToUnc(filename), UncUtil.convertToLocal(UncUtil.convertToUnc(filename)));
                Map<String, String> cachedMap = UncUtil.buildSharedMap();
                System.out.printf("[cache] convertToUnc(\"%s\"): \"%s\"%n", filename, UncUtil.convertToUnc(filename, cachedMap));
                System.out.printf("[cache] convertToLocal(\"%s\"): \"%s\"%n", filename, UncUtil.convertToLocal(filename, cachedMap));
                System.out.printf("[cache] convertToLocal(convertToUnc(\"%s\")): \"%s\"%n", UncUtil.convertToUnc(filename, cachedMap), UncUtil.convertToLocal(UncUtil.convertToUnc(filename, cachedMap)));
                System.out.println();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class LengthSorter
    implements Comparator<Object> {
        private LengthSorter() {
        }

        @Override
        public int compare(Object arg0, Object arg1) {
            if (arg0.equals(arg1)) {
                return 0;
            }
            if (((String)arg0).length() < ((String)arg1).length()) {
                return 1;
            }
            return -1;
        }
    }
}

