/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.TypedProp;

public class TextProps {
    private static final Map<Class, IParser> s_parsers = new HashMap<Class, IParser>();

    public static <T> IParser<T> getParser(TypedProp<T> prop) {
        return TextProps.getParser(prop.type);
    }

    public static <T> IParser<T> getParser(Class<T> type) {
        return s_parsers.get(type);
    }

    public static <T> Function<T, String> getFormatter(TypedProp<T> prop) {
        return TextProps.getFormatter(prop.type);
    }

    public static <T> Function<T, String> getFormatter(Class<T> type) {
        return val -> val == null ? null : val.toString();
    }

    static {
        s_parsers.put(Boolean.class, val -> Boolean.valueOf(val));
        s_parsers.put(Integer.class, val -> Integer.parseInt(val));
        s_parsers.put(Long.class, val -> Long.parseLong(val));
        s_parsers.put(Float.class, val -> Float.valueOf(Float.parseFloat(val)));
        s_parsers.put(Double.class, val -> Double.parseDouble(val));
        s_parsers.put(String.class, val -> val);
        s_parsers.put(UnitDouble.class, val -> Global.parseUnitDouble(val, null, Locale.US));
    }

    public static interface IParser<T> {
        public T parse(String var1) throws ParseException;
    }
}

