/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Vector;

public class Stopwatch {
    private long d_start;
    private boolean d_running;
    private Vector d_splits;

    public Stopwatch() {
        this.reset();
    }

    public Split start() {
        if (!this.d_running) {
            this.d_start = System.currentTimeMillis();
            this.d_splits.add(0L);
            this.d_running = true;
            return new Split(0L, 0L);
        }
        return null;
    }

    public Split stop() {
        if (this.d_running) {
            long time = System.currentTimeMillis() - this.d_start;
            long last = (Long)this.d_splits.lastElement();
            this.d_splits.add(time);
            this.d_running = false;
            return new Split(time - last, time);
        }
        return null;
    }

    public Split split() {
        long time = System.currentTimeMillis() - this.d_start;
        long last = (Long)this.d_splits.lastElement();
        this.d_splits.add(time);
        return new Split(time - last, time);
    }

    public void reset() {
        this.d_start = 0L;
        this.d_running = false;
        this.d_splits = new Vector();
    }

    public static void main(String[] argv) {
        int i;
        Stopwatch sw = new Stopwatch();
        System.out.println(sw.start());
        System.out.println(sw.split());
        for (i = 0; i < 10000000; ++i) {
        }
        System.out.println(sw.split());
        for (i = 0; i < 5000000; ++i) {
        }
        System.out.println(sw.split());
        System.out.println(sw.stop());
    }

    public static class Split {
        private long d_lap;
        private long d_split;

        private Split(long lap, long split) {
            this.d_lap = lap;
            this.d_split = split;
        }

        public long getLapTime() {
            return this.d_lap;
        }

        public long getSplitTime() {
            return this.d_split;
        }

        public String toString() {
            return this.d_lap + "\t" + this.d_split;
        }
    }
}

