/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import thunderheadeng.util.IPropertySet;

public class PropertySet
implements IPropertySet,
Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Map<Object, Object> d_props = Collections.EMPTY_MAP;
    private static final Object UNMAPPED = new Object();

    protected Map<Object, Object> newMap() {
        return new HashMap<Object, Object>();
    }

    public Map<Object, Object> getMap() {
        return this.d_props;
    }

    public PropertySet clone() {
        try {
            PropertySet clone = (PropertySet)super.clone();
            if (clone.d_props != Collections.emptyMap()) {
                clone.d_props = this.newMap();
                clone.d_props.putAll(this.d_props);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        this.preSet();
        this.d_props.put(prop.key, val);
    }

    private void preSet() {
        if (this.d_props == Collections.EMPTY_MAP) {
            this.d_props = this.newMap();
        }
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        this.remove(prop.key);
    }

    public void clear() {
        this.d_props = Collections.emptyMap();
    }

    private void remove(Object key) {
        if (!this.d_props.isEmpty()) {
            this.d_props.remove(key);
            this.postRemove();
        }
    }

    private void postRemove() {
        if (this.d_props.isEmpty()) {
            this.d_props = Collections.EMPTY_MAP;
        }
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        return (T)this.d_props.getOrDefault(prop.key, prop.defVal);
    }

    public int size() {
        return this.d_props.size();
    }

    @Override
    public <T> void merge(IPropertySet src, IPropertySet.Prop<T> prop) {
        if (src instanceof PropertySet) {
            PropertySet otherSet = (PropertySet)src;
            Object otherVal = otherSet.d_props.getOrDefault(prop.key, UNMAPPED);
            if (otherVal == UNMAPPED) {
                this.remove(prop);
            } else {
                this.set(prop, otherVal);
            }
        } else {
            IPropertySet.super.merge(src, prop);
        }
    }

    public void merge(PropertySet src) {
        this.preSet();
        this.d_props.putAll(src.d_props);
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.d_props.containsKey(prop.key);
    }
}

