/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.theUtil;

public class NamesDB
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private static final NameGenerator s_defGen = new NameGenerator("", 2, true);
    private Map<Class, NameGenerator> d_nameGens = new HashMap<Class, NameGenerator>();

    protected <T> List<String> generateNames(Collection<T> objs, INameGen nameGen) {
        List list;
        LinkedIdentityHashMap genMap = new LinkedIdentityHashMap();
        for (Object o : objs) {
            NameGenerator nameGenerator = this.getNames(o);
            list = (ArrayList<Object>)genMap.get(nameGenerator);
            if (list == null) {
                list = new ArrayList<Object>();
                genMap.put(nameGenerator, list);
            }
            list.add(o);
        }
        IdentityHashMap nameMap = new IdentityHashMap();
        for (Map.Entry entry : genMap.entrySet()) {
            list = (List)entry.getValue();
            List<String> names = nameGen.generate((NameGenerator)entry.getKey(), list);
            for (int m = 0; m < list.size(); ++m) {
                nameMap.put(list.get(m), names.get(m));
            }
        }
        ArrayList<String> result = new ArrayList<String>(objs.size());
        for (T o : objs) {
            result.add((String)nameMap.get(o));
        }
        return result;
    }

    public NamesDB clone() {
        return this.clone(false);
    }

    public NamesDB clone(boolean deep) {
        try {
            NamesDB clone = (NamesDB)super.clone();
            clone.d_nameGens = new HashMap<Class, NameGenerator>();
            for (Map.Entry<Class, NameGenerator> entry : this.d_nameGens.entrySet()) {
                NameGenerator gen = deep ? entry.getValue().clone() : entry.getValue();
                clone.d_nameGens.put(entry.getKey(), gen);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public void registerType(Class type, NameGenerator gen) {
        this.d_nameGens.put(type, gen);
    }

    public NameGenerator getNames(Object obj) {
        return this.getNames(obj.getClass());
    }

    public NameGenerator getNames(Class type) {
        NameGenerator gen = this.d_nameGens.get(type);
        if (gen == null) {
            gen = theUtil.findObjectForClass(this.d_nameGens, type);
            if (gen == null) {
                gen = s_defGen;
            }
            this.d_nameGens.put(type, gen);
        }
        return gen;
    }

    protected static interface INameGen<T> {
        public List<String> generate(NameGenerator var1, List<T> var2);
    }
}

