/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;

public class NameGenerator
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private final String d_originalBaseName;
    private final boolean d_allowDuplicates;
    private String d_baseName;
    private int d_minNumWidth;
    private transient NumberFormat d_numFormat;
    private int d_index;
    private String d_currName;
    private transient Map<String, Integer> d_usedNames;

    public NameGenerator(String baseName) {
        this(baseName, 2, false);
    }

    public NameGenerator(String baseName, int minNumWidth, boolean allowDuplicates) {
        this(baseName, baseName, null, minNumWidth, 1, allowDuplicates);
    }

    public NameGenerator(String originalBaseName, String baseName, String currName, int minNumWidth, int currIndex, boolean allowDuplicates) {
        this.d_allowDuplicates = allowDuplicates;
        this.d_originalBaseName = originalBaseName;
        this.d_minNumWidth = minNumWidth;
        this.d_usedNames = new HashMap<String, Integer>();
        this.d_baseName = baseName;
        this.d_index = currIndex;
        this.d_currName = currName;
        this.initNumberFormat();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_usedNames = new HashMap<String, Integer>();
        this.initNumberFormat();
    }

    private void initNumberFormat() {
        int m;
        StringBuilder format = new StringBuilder(3 + this.d_minNumWidth);
        for (m = 0; m < 3; ++m) {
            format.append('#');
        }
        for (m = 0; m < this.d_minNumWidth; ++m) {
            format.append('0');
        }
        this.d_numFormat = new DecimalFormat(format.toString());
    }

    public NameGenerator clone() {
        try {
            NameGenerator clone = (NameGenerator)super.clone();
            clone.d_usedNames = new HashMap<String, Integer>(this.d_usedNames);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public void reset() {
        this.d_usedNames.clear();
        this.d_baseName = this.d_originalBaseName;
        this.d_index = 1;
        this.d_currName = null;
    }

    public void setBaseName(String name) {
        if (name.equals(this.d_baseName)) {
            return;
        }
        this.d_baseName = name;
        this.d_index = 1;
        this.d_currName = null;
    }

    public String getBaseName() {
        return this.d_baseName;
    }

    public boolean getAllowsDuplicates() {
        return this.d_allowDuplicates;
    }

    public void registerName(String name) {
        if (this.d_allowDuplicates || name == null) {
            return;
        }
        String currName = this.generateName();
        Integer oldCount = this.d_usedNames.get(name);
        if (oldCount == null) {
            oldCount = 0;
        }
        this.d_usedNames.put(name, oldCount + 1);
        if (name.equals(currName)) {
            this.d_currName = null;
            ++this.d_index;
        }
    }

    public void registerNames(Collection<String> names) {
        for (String name : names) {
            this.registerName(name);
        }
    }

    public void unregisterName(String name) {
        if (this.d_allowDuplicates || name == null) {
            return;
        }
        Integer oldCount = this.d_usedNames.get(name);
        if (oldCount <= 1) {
            this.d_usedNames.remove(name);
        } else {
            this.d_usedNames.put(name, oldCount - 1);
        }
    }

    public void updateRegisteredName(String oldName, String newName) {
        if (this.d_allowDuplicates) {
            return;
        }
        this.unregisterName(oldName);
        this.registerName(newName);
    }

    public boolean isRegistered(String name) {
        return this.d_allowDuplicates ? false : this.d_usedNames.containsKey(name);
    }

    private Predicate<String> getFilter() {
        return this.getFilter(Filters.rejectAll(String.class), Filters.acceptAll(String.class));
    }

    private Predicate<String> getFilter(Predicate<String> acceptNames, Predicate<String> rejectNames) {
        if (this.d_allowDuplicates) {
            return Filters.acceptAll();
        }
        return Filters.or(Filters.and(Filters.reject(this.d_usedNames.keySet()), rejectNames), acceptNames);
    }

    public String generateName() {
        if (this.d_currName == null) {
            Pair<String, Integer> result = NameGenerator.getNextName(this.d_baseName, this.d_numFormat, this.d_index, this.getFilter());
            this.d_currName = (String)result.v1;
        }
        return this.d_currName;
    }

    public List<String> generateNames(int count) {
        return this.generateNames(count, Filters.rejectAll(String.class));
    }

    public List<String> generateNames(int count, Predicate<String> allowNameFilter) {
        return this.generateNames(count, allowNameFilter, Filters.acceptAll(String.class));
    }

    public List<String> generateNames(int count, Predicate<String> acceptNames, Predicate<String> rejectNames) {
        ArrayList<String> names = new ArrayList<String>(count);
        Predicate<String> filter = this.getFilter(acceptNames, rejectNames);
        int index = this.d_index;
        for (int m = 0; m < count; ++m) {
            Pair<String, Integer> result = NameGenerator.getNextName(this.d_baseName, this.d_numFormat, index, filter);
            names.add((String)result.v1);
            index = (Integer)result.v2;
        }
        return names;
    }

    private static Pair<String, Integer> getNextName(String baseName, NumberFormat numFormat, int index, Predicate<String> nameFilter) {
        String currName;
        while (!nameFilter.test(currName = baseName + numFormat.format(index++))) {
        }
        return new Pair<String, Integer>(currName, index);
    }

    public String generateValidName(String desiredName) {
        return this.generateValidNames(1, desiredName, Filters.rejectAll(String.class)).get(0);
    }

    public List<String> generateValidNames(int count, String baseName, Predicate<String> acceptNames) {
        return this.generateValidNames(count, baseName, acceptNames, Filters.acceptAll(String.class));
    }

    public List<String> generateValidNames(int count, String baseName, Predicate<String> acceptNames, Predicate<String> rejectNames) {
        if (baseName.isEmpty()) {
            return this.generateNames(count, acceptNames, rejectNames);
        }
        if (this.d_allowDuplicates) {
            ArrayList<String> names = new ArrayList<String>(count);
            for (int m = 0; m < count; ++m) {
                names.add(baseName);
            }
            return names;
        }
        Predicate<String> filter = this.getFilter(acceptNames, rejectNames);
        if (count == 1 && filter.test(baseName)) {
            return Arrays.asList(baseName);
        }
        for (int m = baseName.length() - 1; m >= 0; --m) {
            if (Character.isDigit(baseName.charAt(m))) continue;
            baseName = baseName.substring(0, m + 1);
            break;
        }
        if (baseName.equals(this.d_baseName)) {
            return this.generateNames(count, acceptNames, rejectNames);
        }
        int index = 1;
        ArrayList<String> result = new ArrayList<String>(count);
        for (int m = 0; m < count; ++m) {
            Pair<String, Integer> nextValidName = NameGenerator.getNextName(baseName, this.d_numFormat, index, filter);
            index = (Integer)nextValidName.v2;
            result.add((String)nextValidName.v1);
        }
        return result;
    }
}

