/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import thunderheadeng.util.MappedIterator;

public class MappedCollection<InT, OutT>
extends AbstractCollection<OutT>
implements Set<OutT> {
    private final Collection<InT> d_collection;
    private final Function<InT, OutT> d_transformer;
    private final Function<OutT, InT> d_invTransformer;
    private final Class<OutT> d_transformedType;

    public MappedCollection(Collection<InT> collection, Function<InT, OutT> transformer) {
        this(collection, transformer, null, null);
    }

    public MappedCollection(Collection<InT> collection, Function<InT, OutT> transformer, Function<OutT, InT> invTransformer, Class<OutT> transformedType) {
        this.d_collection = collection;
        this.d_transformer = transformer;
        this.d_invTransformer = invTransformer;
        this.d_transformedType = transformedType;
        assert (this.d_invTransformer == null || this.d_transformedType != null);
    }

    @Override
    public Iterator<OutT> iterator() {
        return new MappedIterator<InT, OutT>(this.d_collection.iterator(), this.d_transformer);
    }

    @Override
    public boolean add(OutT e) {
        if (this.d_invTransformer != null) {
            return this.d_collection.add(this.d_invTransformer.apply(e));
        }
        return super.add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (this.d_invTransformer != null) {
            if (o == null) {
                return this.d_collection.remove(null);
            }
            if (this.d_transformedType.isInstance(o)) {
                return this.d_collection.remove(this.d_invTransformer.apply(o));
            }
            return false;
        }
        return super.remove(o);
    }

    @Override
    public boolean contains(Object o) {
        if (this.d_invTransformer != null) {
            if (o == null) {
                return this.d_collection.contains(null);
            }
            if (this.d_transformedType.isInstance(o)) {
                return this.d_collection.contains(this.d_invTransformer.apply(o));
            }
            return false;
        }
        return super.contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.d_collection.isEmpty();
    }

    @Override
    public int size() {
        return this.d_collection.size();
    }

    @Override
    public void clear() {
        this.d_collection.clear();
    }
}

