/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.util.Timer;
import java.util.TimerTask;
import thunderheadeng.util.TaskProgress;

public class JniTaskProgress {
    private final ByteBuffer d_buffer;
    private final IntBuffer d_pprog;
    private final CharBuffer d_pmsg;
    private final Timer d_progressTimer;

    public JniTaskProgress(final TaskProgress progress) {
        int numChars = 1024;
        this.d_buffer = ByteBuffer.allocateDirect(16 + 2 * numChars).order(ByteOrder.nativeOrder());
        ByteBuffer buffer = this.d_buffer.slice().order(ByteOrder.nativeOrder());
        this.d_pprog = buffer.asIntBuffer();
        int[] currProg = progress.getProgress();
        buffer.putInt(currProg != null ? currProg[0] : -1);
        buffer.putInt(currProg != null ? currProg[1] : 0);
        buffer.putInt(progress.isRunning() ? 1 : 0);
        buffer.putInt(0);
        this.d_pmsg = buffer.asCharBuffer();
        final char[] msgChars = new char[numChars];
        this.d_progressTimer = new Timer(false);
        this.d_progressTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String msg;
                int max;
                int curr;
                boolean running = progress.isRunning();
                ByteBuffer byteBuffer = JniTaskProgress.this.d_buffer;
                synchronized (byteBuffer) {
                    curr = JniTaskProgress.this.d_pprog.get(0);
                    max = JniTaskProgress.this.d_pprog.get(1);
                    JniTaskProgress.this.d_pprog.put(2, running ? 1 : 0);
                    int msgLen = JniTaskProgress.this.d_pprog.get(3);
                    JniTaskProgress.this.d_pmsg.get(msgChars, 0, msgLen);
                    JniTaskProgress.this.d_pmsg.position(0);
                    msg = new String(msgChars, 0, msgLen);
                }
                progress.setMax(max);
                progress.setProgress(curr);
                progress.setMessage(msg);
                if (!running) {
                    JniTaskProgress.this.finished();
                }
            }
        }, 16L, 16L);
    }

    protected void finalize() throws Throwable {
        this.finished();
        super.finalize();
    }

    public ByteBuffer getBuffer() {
        return this.d_buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        ByteBuffer byteBuffer = this.d_buffer;
        synchronized (byteBuffer) {
            this.d_pprog.put(2, 0);
        }
        this.d_progressTimer.cancel();
    }
}

