/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class IntlPackage {
    private final ResourceBundle d_localBndl;

    public IntlPackage(String resourceFile) {
        ResourceBundle bundle;
        try {
            bundle = ResourceBundle.getBundle(resourceFile, Locale.getDefault(), ClassLoader.getSystemClassLoader());
        }
        catch (MissingResourceException e) {
            if (!Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                System.err.println("[4189] " + e.getMessage());
            }
            bundle = null;
        }
        this.d_localBndl = bundle;
    }

    public ResourceBundle getResourceBundle() {
        return this.d_localBndl;
    }

    public String getText(String str) {
        if (this.d_localBndl == null) {
            return str;
        }
        try {
            return this.d_localBndl.getString(str);
        }
        catch (MissingResourceException e) {
            return str;
        }
    }
}

