/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface IPropertySet {
    public <T> void set(Prop<T> var1, T var2);

    default public <T> void setIfNotDefault(Prop<T> prop, T val) {
        if (!Objects.equals(prop.defVal, val)) {
            this.set(prop, val);
        } else {
            this.remove(prop);
        }
    }

    public <T> boolean isDefined(Prop<T> var1);

    public <T> void remove(Prop<T> var1);

    public <T> T get(Prop<T> var1);

    default public void merge(IPropertySet src, Stream<? extends Prop<?>> props) {
        props.forEach(prop -> this.merge(src, (Prop<T>)((Prop)prop)));
    }

    default public void merge(IPropertySet src, Iterator<? extends Prop<?>> props) {
        while (props.hasNext()) {
            this.merge(src, (Prop<T>)props.next());
        }
    }

    default public void merge(IPropertySet src, Collection<? extends Prop<?>> props) {
        for (Prop<?> prop : props) {
            this.merge(src, (Prop<T>)prop);
        }
    }

    default public void merge(IPropertySet src, Prop<?> ... props) {
        for (Prop<?> prop : props) {
            this.merge(src, (Prop<T>)prop);
        }
    }

    default public <T> void merge(IPropertySet src, Prop<T> prop) {
        if (!src.isDefined(prop)) {
            this.remove(prop);
        } else {
            this.set(prop, src.get(prop));
        }
    }

    default public boolean compare(IPropertySet other, Collection<? extends Prop<?>> props) {
        for (Prop<?> prop : props) {
            if (Objects.equals(this.get(prop), other.get(prop))) continue;
            return false;
        }
        return true;
    }

    default public boolean compare(IPropertySet other, Stream<? extends Prop<?>> props) {
        return props.allMatch(prop -> Objects.equals(this.get((Prop)prop), other.get((Prop)prop)));
    }

    default public int hash(Collection<? extends Prop<?>> props) {
        int result = -131878941;
        for (Prop<?> prop : props) {
            result += Objects.hashCode(this.get(prop));
        }
        return result;
    }

    public static List<Prop<?>> getAllDeclaredPublicStaticProps(Class c) {
        return IPropertySet.getAllDeclaredProps(c, field -> Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers()));
    }

    public static List<Prop<?>> getAllDeclaredProps(Class c, Predicate<Field> ftest) {
        ArrayList all = new ArrayList();
        for (Field field : c.getDeclaredFields()) {
            if (!Prop.class.isAssignableFrom(field.getType()) || !ftest.test(field)) continue;
            try {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                all.add((Prop)field.get(null));
                field.setAccessible(accessible);
            }
            catch (Throwable t) {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError();
                }
                t.printStackTrace();
            }
        }
        return all;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class Prop<T> {
        public final Object key;
        public final T defVal;

        public Prop(Object key, T defVal) {
            this.key = key;
            this.defVal = defVal;
        }
    }
}

