/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Formatter;

public class Global {
    public static String s_engLenFormat = "ft;in;";
    public static final int NUM_DISPLAY_SIG_DIGS = 6;
    public static final Formatter FORMATTER = new Formatter(Locale.getDefault());
    private static Map<Unit, String> s_unitDisplays = new HashMap<Unit, String>();

    public static String formatFixedWidth(double n, int w) {
        return FORMATTER.formatFixedWidth(n, w);
    }

    public static String formatFloat(double n, int w) {
        return FORMATTER.formatFloat(n, w);
    }

    public static String formatSci(double n, int w) {
        return FORMATTER.formatSci(n, w);
    }

    public static String format(double n) {
        return Global.format(n, 6);
    }

    public static String format(double n, int maxPrecision) {
        return FORMATTER.format(n, maxPrecision);
    }

    public static String formatGraph(double number) {
        DecimalFormat df = new DecimalFormat();
        if (Math.abs(number) == 0.0) {
            df.applyPattern("##0.0");
        } else if (Math.abs(number) < 9999.0 && Math.abs(number) >= 100.0) {
            df.applyPattern("###0.0");
        } else if (Math.abs(number) < 100.0 && Math.abs(number) >= 1.0) {
            df.applyPattern("#0.00");
        } else if (Math.abs(number) < 1.0 && Math.abs(number) > 0.099) {
            df.applyPattern("#.000");
        } else {
            df.applyPattern("0.0##E00");
        }
        return df.format(number);
    }

    public static double parseDouble(CharSequence origText) throws ParseException {
        return Global.parseDouble(origText, Locale.getDefault());
    }

    public static double parseDouble(CharSequence origText, Locale numFormatLocale) throws ParseException {
        Number num;
        int badExp;
        NumberFormat nf = NumberFormat.getInstance(numFormatLocale);
        ParsePosition pos = new ParsePosition(0);
        String text = origText.toString().toUpperCase();
        if (text.startsWith("+") && text.length() > 1) {
            text = text.substring(1);
        }
        if ((badExp = text.indexOf("E+")) > 0 && text.length() > badExp + 1) {
            text = text.substring(0, badExp) + "E" + text.substring(badExp + 2, text.length());
        }
        if ((num = nf.parse(text.toUpperCase(), pos)) == null || pos.getIndex() != text.length()) {
            String msg = String.format(Intl.intl("Unparseable number: %s"), origText);
            throw new ParseException(msg, pos.getIndex());
        }
        return num.doubleValue();
    }

    public static UnitDouble parseUnitDouble(CharSequence value) throws ParseException {
        return Global.parseUnitDouble(value, null);
    }

    public static UnitDouble parseUnitDouble(CharSequence value, Unit defUnit) throws ParseException {
        return Global.parseUnitDouble(value, defUnit, Locale.getDefault());
    }

    public static UnitDouble parseUnitDouble(CharSequence value, Unit defUnit, Locale numFormatLocale) throws ParseException {
        StringTokenizer tok = new StringTokenizer(value.toString(), " ");
        int numToks = tok.countTokens();
        if (numToks == 0) {
            return null;
        }
        if (numToks == 1) {
            if (defUnit == null) {
                defUnit = Unit.ONE;
            }
            String valStr = tok.nextToken();
            ParseException caughtExc = null;
            for (int m = valStr.length(); m >= 1; --m) {
                double val;
                CharSequence v = valStr.subSequence(0, m);
                try {
                    val = Global.parseDouble(v, numFormatLocale);
                }
                catch (ParseException e) {
                    if (caughtExc != null) continue;
                    caughtExc = e;
                    continue;
                }
                CharSequence u = valStr.subSequence(m, valStr.length());
                if (u.length() == 0) {
                    return new UnitDouble(val, defUnit);
                }
                Unit unit = Global.parseUnit(u, defUnit);
                return new UnitDouble(val, unit);
            }
            assert (caughtExc != null);
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new ParseException("", 0);
        }
        String valStr = tok.nextToken();
        String unitName = tok.nextToken();
        return Global.parseUnitDouble(valStr, unitName, defUnit, numFormatLocale);
    }

    private static UnitDouble parseUnitDouble(CharSequence valStr, CharSequence unitName, Unit defUnit, Locale numFormatLocale) throws ParseException {
        double val = Global.parseDouble(valStr, numFormatLocale);
        Unit u = Global.parseUnit(unitName, defUnit);
        return new UnitDouble(val, u);
    }

    private static Unit parseUnit(CharSequence unitName, Unit defUnit) throws ParseException {
        try {
            return Global.tryParseUnit(unitName, defUnit);
        }
        catch (ParseException e) {
            unitName = Global.replaceTemp(unitName);
            if (unitName == null) {
                throw e;
            }
            try {
                return Global.tryParseUnit(unitName, defUnit);
            }
            catch (ParseException e2) {
                throw e;
            }
        }
    }

    private static CharSequence replaceTemp(CharSequence unitName) {
        StringBuilder builder = null;
        for (int m = 0; m < unitName.length(); ++m) {
            char c = unitName.charAt(m);
            if (!(c != 'F' && c != 'C' && c != 'R' || m != 0 && unitName.charAt(m - 1) == '\u00b0')) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(unitName, 0, m);
                }
                builder.append('\u00b0');
                builder.append(c);
                continue;
            }
            if (builder == null) continue;
            builder.append(c);
        }
        return builder;
    }

    private static Unit tryParseUnit(CharSequence unitName, Unit defUnit) throws ParseException {
        try {
            Unit u = Unit.valueOf((CharSequence)unitName);
            if (defUnit != null && !UnitDouble.areCompatible(u, defUnit)) {
                String msg = String.format(Intl.intl("Invalid unit: \"%1$s\" is incompatible with \"%2$s\"."), unitName, defUnit.toString());
                throw new ParseException(msg, 0);
            }
            return u;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Throwable e) {
            String txt = String.format(Intl.intl("Unrecognized unit: %s"), unitName);
            throw new ParseException(txt, 0);
        }
    }

    public static String format(UnitDouble val) {
        return Global.format(val.getValueNoUnit(), val.getUnit());
    }

    public static String format(double val, Unit unit) {
        String unitStr;
        String valStr = Global.format(val);
        String string = unitStr = unit != null ? unit.toString() : "";
        if (unitStr.isEmpty()) {
            return valStr;
        }
        StringBuilder result = new StringBuilder(valStr);
        result.append(' ');
        result.append(unitStr);
        return result.toString();
    }

    static {
        s_unitDisplays.put(NonSI.FOOT, "'");
        s_unitDisplays.put(NonSI.INCH, "\"");
    }
}

