/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class Formatter {
    private final Locale d_locale;
    private final DecimalFormatSymbols d_symbols;
    private final ArrayList<DecimalFormat> d_decFormats;
    private final NumberFormat d_floatFormat;
    private final NumberFormat d_sciFormat;
    private static final double[] POW10 = new double[15];

    public Formatter(Locale locale) {
        this.d_locale = locale;
        this.d_symbols = DecimalFormatSymbols.getInstance(this.d_locale);
        this.d_decFormats = new ArrayList();
        this.d_floatFormat = new DecimalFormat("0.0", this.d_symbols);
        this.d_floatFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.d_sciFormat = new DecimalFormat("0.0E0", this.d_symbols);
        this.d_sciFormat.setRoundingMode(RoundingMode.HALF_UP);
    }

    protected DecimalFormatSymbols getFormatSymbols() {
        return this.d_symbols;
    }

    private static int getSciExp(double n) {
        int iSciExp;
        if (n == 0.0) {
            return 0;
        }
        double sciExp = n < 0.0 ? Math.log10(-n) : Math.log10(n);
        if (sciExp < (double)(iSciExp = (int)sciExp)) {
            --iSciExp;
        }
        return iSciExp;
    }

    private static int getSciExp2(double n) {
        if (n == 0.0) {
            return 0;
        }
        if (n < 0.0) {
            n = -n;
        }
        if (n < 1000000.0 && n >= 1.0) {
            int count = 0;
            while (n >= 10.0) {
                ++count;
                n /= 10.0;
            }
            return count;
        }
        if (n < 1.0 && n >= 1.0E-6) {
            int count = 0;
            while (n < 1.0) {
                ++count;
                n *= 10.0;
            }
            return -count;
        }
        return (int)Math.floor(Math.log10(n));
    }

    private static double pow10(int n) {
        if (n >= 0 && n < POW10.length) {
            return POW10[n];
        }
        return Math.pow(10.0, n);
    }

    private static int chars(double n) {
        int chars = Math.max((int)Math.log10(Math.abs(n)) + 1, 1);
        if (n < 0.0) {
            return chars + 1;
        }
        return chars;
    }

    public String formatFixedWidth(double n, int w) {
        return Formatter.isFloatPreferred(n, w) ? this.formatFloat(n, w) : this.formatSci(n, w);
    }

    private static boolean isFloatPreferred(double n, int w) {
        int digitsFloat = Formatter.getSigDigitsFloat(n, w);
        int digitsSci = Formatter.getSigDigitsSci(n, w);
        if (n == 0.0) {
            return true;
        }
        if (1.0E-4 < n && n < 100000.0) {
            return digitsSci <= digitsFloat;
        }
        return digitsSci < digitsFloat;
    }

    private static int getSigDigitsFloat(double n, int width) {
        int availableDigits = width - 1;
        if (n < 0.0) {
            --availableDigits;
        }
        int maxExp = availableDigits - 2;
        int minExp = -availableDigits + 1;
        int expMsd = Formatter.getSciExp(n);
        if (expMsd < minExp || maxExp < expMsd) {
            return 0;
        }
        int expLsd = Math.max(minExp, expMsd - (availableDigits - 1));
        int precision = availableDigits - Math.max(0, expMsd + 1);
        if (Formatter.expandsWhenRounded(n, precision) && maxExp < ++expMsd) {
            return 0;
        }
        return expMsd - expLsd;
    }

    private static int getSigDigitsSci(double n, int width) {
        int sciExpPart = Formatter.getSciExp(n);
        int digitsReq = 2 + Formatter.chars(sciExpPart);
        if (n < 0.0) {
            ++digitsReq;
        }
        return width - digitsReq - 1;
    }

    private static boolean expandsWhenRounded(double n, int precision) {
        double shift = Formatter.pow10(precision);
        long rounded = Math.round(n * shift);
        return Formatter.getSciExp(n) < Formatter.getSciExp((double)rounded / shift);
    }

    public String formatFloat(double n, int w) {
        int nchars;
        int precision;
        if (Double.isInfinite(n) || Double.isNaN(n)) {
            return this.pad(Double.toString(n), w);
        }
        if (n == -0.0) {
            n = 0.0;
        }
        if (Formatter.expandsWhenRounded(n, precision = Math.max(0, w - (nchars = Formatter.chars(n)) - 1))) {
            ++nchars;
            --precision;
        }
        if (precision < 1) {
            return this.pad("0" + this.getFormatSymbols().getDecimalSeparator() + '0', w);
        }
        DecimalFormat format = this.getFloatFormat(precision);
        String formatted = format.format(n);
        String padded = this.pad(formatted, w);
        return this.convertTrailingZerosToLeadingSpaces(padded);
    }

    private String pad(String str, int width) {
        try {
            int m;
            if (width <= str.length()) {
                return str.substring(0, width);
            }
            int numZeros = width - str.length();
            char[] buffer = new char[width];
            for (m = 0; m < numZeros; ++m) {
                buffer[m] = 32;
            }
            for (m = numZeros; m < width; ++m) {
                buffer[m] = str.charAt(m - numZeros);
            }
            return new String(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error on: " + String.format("pad(%s, %d)", str, width));
            String fmt = "%" + width + "s";
            return String.format(this.d_locale, fmt, str);
        }
    }

    private DecimalFormat getFloatFormat(int precision) {
        DecimalFormat format;
        if (precision >= this.d_decFormats.size()) {
            for (int m = this.d_decFormats.size(); m <= precision; ++m) {
                this.d_decFormats.add(null);
            }
        }
        if ((format = this.d_decFormats.get(precision)) == null) {
            char[] buffer = new char[2 + precision];
            buffer[0] = 48;
            buffer[1] = 46;
            for (int m = 2; m < precision + 2; ++m) {
                buffer[m] = 48;
            }
            format = new DecimalFormat(new String(buffer), this.getFormatSymbols());
            this.d_decFormats.set(precision, format);
        }
        return format;
    }

    private String convertTrailingZerosToLeadingSpaces(String str) {
        int decimalLocation = str.indexOf(this.getFormatSymbols().getDecimalSeparator());
        if (decimalLocation != -1) {
            int len = str.length();
            StringBuilder result = new StringBuilder(len);
            for (int i = len - 1; decimalLocation + 1 < i && str.charAt(i) == '0'; --i) {
                result.append(" ");
            }
            int tailLen = len - result.length();
            for (int m = 0; m < tailLen; ++m) {
                result.append(str.charAt(m));
            }
            return result.toString();
        }
        return str;
    }

    public String formatSci(double n, int w) {
        int fractionDigits;
        double sciFloatPart;
        if (Double.isInfinite(n) || Double.isNaN(n)) {
            return this.pad(Double.toString(n), w);
        }
        if (n == -0.0) {
            n = 0.0;
        }
        int sciExpPart = Formatter.getSciExp(n);
        int sciExpChars = Formatter.chars(sciExpPart);
        int digitsReq = 2 + sciExpChars;
        if (n < 0.0) {
            ++digitsReq;
        }
        if (Formatter.expandsWhenRounded(sciFloatPart = n / Formatter.pow10(sciExpPart), fractionDigits = w - digitsReq - 1)) {
            sciExpChars = Formatter.chars(++sciExpPart);
            digitsReq = 2 + sciExpChars;
            if (n < 0.0) {
                ++digitsReq;
            }
            sciFloatPart = n / Formatter.pow10(sciExpPart);
            fractionDigits = w - digitsReq - 1;
        }
        if (Double.isInfinite(sciFloatPart) || Double.isNaN(sciFloatPart)) {
            return this.pad(Double.toString(sciFloatPart), w);
        }
        DecimalFormat format = this.getFloatFormat(fractionDigits);
        String strFraction = format.format(sciFloatPart);
        strFraction = this.convertTrailingZerosToLeadingSpaces(strFraction);
        String str = strFraction + "E" + sciExpPart;
        return str;
    }

    public String format(double n, int maxPrecision) {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            return Double.toString(n);
        }
        String formattedVal = "";
        int sciExp = Formatter.getSciExp2(n);
        if (-3 < sciExp && sciExp <= 3) {
            this.d_floatFormat.setMaximumFractionDigits(maxPrecision);
            formattedVal = this.d_floatFormat.format(n);
        } else {
            this.d_sciFormat.setMaximumFractionDigits(maxPrecision);
            formattedVal = this.d_sciFormat.format(n);
        }
        return this.negativeZeroCorrection(formattedVal);
    }

    public String negativeZeroCorrection(String formattedVal) {
        if (formattedVal.equals("-0.0")) {
            return "0.0";
        }
        if (formattedVal.equals("-0,0")) {
            return "0,0";
        }
        return formattedVal;
    }

    public String formatOld(double n, int maxPrecision) {
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            return Double.toString(n);
        }
        double abs = Math.abs(n);
        if (n == 0.0 || abs >= 0.001 && abs < 10000.0) {
            int start = maxPrecision + 1;
            if (n < 0.0) {
                ++start;
            }
            for (int m = start; m < 14; ++m) {
                int sigDigs = Formatter.getSigDigitsFloat(n, m) + 1;
                if (sigDigs < maxPrecision) continue;
                return this.formatFloat(n, m).trim();
            }
        } else {
            return this.tryFormatSciNew(n, maxPrecision);
        }
        return NumberFormat.getInstance(this.d_locale).format(n);
    }

    public String tryFormatSciNew(double n, int maxPrecision) {
        int specCharCount = 0;
        if (n < 0.0) {
            ++specCharCount;
        }
        ++specCharCount;
        ++specCharCount;
        int sciExpPart = Formatter.getSciExp(n);
        int digitsReq = Formatter.chars(sciExpPart);
        return this.formatSci(n, maxPrecision + (specCharCount += digitsReq)).trim();
    }

    public String tryFormatSciOld(double n, int maxPrecision) {
        for (int m = maxPrecision; m < 14; ++m) {
            int sigDigs = Formatter.getSigDigitsSci(n, m) + 1;
            if (sigDigs < maxPrecision) continue;
            return this.formatSci(n, m).trim();
        }
        return null;
    }

    public static void main(String[] args) {
        Formatter formatter = new Formatter(Locale.ENGLISH);
        System.out.println(formatter.format(Double.NaN, 5));
        System.out.println(formatter.format(Double.NEGATIVE_INFINITY, 5));
        System.out.println(formatter.format(Double.POSITIVE_INFINITY, 5));
        System.out.println(formatter.format(-1.7976931348623157E308, 5));
        System.out.println(formatter.format(Double.MAX_VALUE, 5));
        System.out.println(formatter.format(-4.9E-324, 5));
        System.out.println(formatter.format(Double.MIN_VALUE, 5));
        System.out.println(formatter.format(1.0E-4, 5));
        System.out.println(formatter.format(-1.0E-4, 5));
        System.out.println(formatter.format(0.01, 5));
        System.out.println(formatter.format(-0.01, 5));
        System.out.println(formatter.format(0.01, 1));
        System.out.println(formatter.format(-0.01, 1));
        System.out.println();
        formatter = new Formatter(Locale.GERMANY);
        System.out.println(formatter.format(Double.NaN, 5));
        System.out.println(formatter.format(Double.NEGATIVE_INFINITY, 5));
        System.out.println(formatter.format(Double.POSITIVE_INFINITY, 5));
        System.out.println(formatter.format(-1.7976931348623157E308, 5));
        System.out.println(formatter.format(Double.MAX_VALUE, 5));
        System.out.println(formatter.format(-4.9E-324, 5));
        System.out.println(formatter.format(Double.MIN_VALUE, 5));
        System.out.println(formatter.format(1.0E-4, 5));
        System.out.println(formatter.format(-1.0E-4, 5));
        System.out.println(formatter.format(0.01, 5));
        System.out.println(formatter.format(-0.01, 5));
        System.out.println(formatter.format(0.01, 1));
        System.out.println(formatter.format(-0.01, 1));
    }

    static {
        for (int m = 0; m < POW10.length; ++m) {
            Formatter.POW10[m] = Math.pow(10.0, m);
        }
    }
}

