/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;

public class FlatMappedIterator<T, R>
implements Iterator<R> {
    private final Iterator<T> d_base;
    private final Function<? super T, ? extends Iterable<? extends R>> d_mapper;
    private Iterator<? extends R> d_flatIterator;

    public FlatMappedIterator(Iterator<T> base, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.d_base = base;
        this.d_mapper = mapper;
        this.d_flatIterator = null;
    }

    private void initIterator() {
        if (this.d_flatIterator == null) {
            this.d_flatIterator = this.findNextIterator();
        }
    }

    @Override
    public boolean hasNext() {
        this.initIterator();
        return this.d_flatIterator.hasNext();
    }

    @Override
    public R next() {
        this.initIterator();
        R next = this.d_flatIterator.next();
        if (!this.d_flatIterator.hasNext()) {
            this.d_flatIterator = this.findNextIterator();
        }
        return next;
    }

    private Iterator<? extends R> findNextIterator() {
        while (this.d_base.hasNext()) {
            Iterator<R> it = this.d_mapper.apply(this.d_base.next()).iterator();
            if (!it.hasNext()) continue;
            return it;
        }
        return Collections.emptyIterator();
    }
}

