/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import thunderheadeng.util.FlatMappedIterator;

public class FlatMappedCollection<T, R>
extends AbstractCollection<R> {
    private final Collection<T> d_base;
    private final Function<? super T, ? extends Iterable<? extends R>> d_mapper;
    private int d_size = -1;

    public FlatMappedCollection(Collection<T> base, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.d_base = base;
        this.d_mapper = mapper;
    }

    @Override
    public Iterator<R> iterator() {
        return new FlatMappedIterator(this.d_base.iterator(), this.d_mapper);
    }

    @Override
    public synchronized int size() {
        if (this.d_size == -1) {
            this.d_size = 0;
            Iterator<R> it = this.iterator();
            while (it.hasNext()) {
                ++this.d_size;
                it.next();
            }
        }
        return this.d_size;
    }
}

