/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class Filters
extends Predicates {
    public static <T> Predicate<T> rejectAll() {
        return Filters.alwaysFalse();
    }

    public static <T> Predicate<T> rejectAll(Class<T> type) {
        return Filters.alwaysFalse();
    }

    public static <T> Predicate<T> acceptAll() {
        return Filters.alwaysTrue();
    }

    public static <T> Predicate<T> acceptAll(Class<T> type) {
        return Filters.alwaysTrue();
    }

    public static <T> Predicate<T> reject(T obj) {
        return new ExcludeOne(obj);
    }

    public static <T> Predicate<T> reject(T ... objs) {
        if (objs.length == 1) {
            return Filters.reject(objs[0]);
        }
        Collection<T> coll = objs.length < 5 ? Arrays.asList(objs) : Sets.fromArrayHS(objs);
        return Filters.reject(coll);
    }

    public static <T> Predicate<T> reject(Collection<T> objs) {
        if (objs.isEmpty()) {
            return Filters.acceptAll();
        }
        if (objs.size() == 1) {
            return new ExcludeOne(objs.iterator().next());
        }
        return new ExcludeMultiple(objs);
    }

    public static <T> Predicate<T> reject(Collection<?> objs, Class<T> filterType) {
        if (objs.isEmpty()) {
            return Filters.acceptAll();
        }
        if (objs.size() == 1) {
            return new ExcludeOne(objs.iterator().next());
        }
        return new ExcludeMultiple(objs);
    }

    public static <T> Predicate<T> accept(T obj) {
        return new AcceptOnlyOne(obj);
    }

    public static <T> Predicate<T> accept(T ... objs) {
        Collection<T> coll = objs.length < 5 ? Arrays.asList(objs) : Sets.fromArrayHS(objs);
        return Filters.accept(coll);
    }

    public static <T> Predicate<T> accept(Collection<T> objs) {
        if (objs.isEmpty()) {
            return Filters.rejectAll();
        }
        if (objs.size() == 1) {
            return new AcceptOnlyOne(objs.iterator().next());
        }
        return new AcceptOnlyMultiple(objs);
    }

    public static <T> Predicate<T> accept(Collection<?> objs, Class<T> filterType) {
        if (objs.isEmpty()) {
            return Filters.rejectAll();
        }
        if (objs.size() == 1) {
            return new AcceptOnlyOne(objs.iterator().next());
        }
        return new AcceptOnlyMultiple(objs);
    }

    private static int hashAsSet(Collection<?> c) {
        int hashCode = 0;
        for (Object o : c) {
            hashCode += theUtil.hashCode(o);
        }
        return hashCode;
    }

    private static boolean equalAsSets(Collection<?> c1, Collection<?> c2) {
        if (c1 instanceof Set && c2 instanceof Set) {
            return c1.equals(c2);
        }
        return c1.size() == c2.size() && c1.containsAll(c2);
    }

    private static <T> Predicate<T> or(AcceptOnlyMultiple<?> aom, AcceptOnlyOne<?> aoo) {
        if (aom.toInclude.contains(aoo.toInclude)) {
            return aom;
        }
        HashSet objs = new HashSet(aom.toInclude);
        objs.add(aoo.toInclude);
        return Filters.accept(objs);
    }

    private static <T> Predicate<T> or(ExcludeMultiple<?> em, ExcludeOne<?> eo) {
        if (em.toExclude.contains(eo.toExclude)) {
            return eo;
        }
        return Filters.alwaysTrue();
    }

    private static <T> Predicate<T> or(AcceptOnlyMultiple<?> filter1, ExcludeOne<?> filter2) {
        if (!filter1.toInclude.contains(filter2.toExclude)) {
            return filter2;
        }
        return Predicates.alwaysTrue();
    }

    private static <T> Predicate<T> or(AcceptOnlyMultiple<?> filter1, ExcludeMultiple<?> filter2) {
        HashSet toExclude = new HashSet(filter2.toExclude);
        toExclude.removeAll(filter1.toInclude);
        return Filters.reject(toExclude);
    }

    private static <T> Predicate<T> or(AcceptOnlyOne<?> filter1, ExcludeOne<?> filter2) {
        if (!theUtil.equal(filter1.toInclude, filter2.toExclude)) {
            return filter2;
        }
        return Predicates.alwaysTrue();
    }

    private static <T> Predicate<T> or(AcceptOnlyOne<?> filter1, ExcludeMultiple<?> filter2) {
        if (!filter2.toExclude.contains(filter1.toInclude)) {
            return filter2;
        }
        HashSet toExclude = new HashSet(filter2.toExclude);
        toExclude.remove(filter1.toInclude);
        return Filters.reject(toExclude);
    }

    private static <T> Predicate<T> and(ExcludeMultiple<?> em, ExcludeOne<?> eo) {
        if (em.toExclude.contains(em.toExclude)) {
            return em;
        }
        HashSet objs = new HashSet(em.toExclude);
        objs.add(eo.toExclude);
        return Filters.reject(objs);
    }

    private static <T> Predicate<T> and(AcceptOnlyMultiple<?> aom, AcceptOnlyOne<?> aoo) {
        if (aom.toInclude.contains(aoo.toInclude)) {
            return aoo;
        }
        return Predicates.alwaysFalse();
    }

    private static <T> Predicate<T> and(AcceptOnlyMultiple<?> filter1, ExcludeOne<?> filter2) {
        if (!filter1.toInclude.contains(filter2.toExclude)) {
            return filter1;
        }
        HashSet objs = new HashSet(filter1.toInclude);
        objs.remove(filter2.toExclude);
        return Filters.accept(objs);
    }

    private static <T> Predicate<T> and(AcceptOnlyMultiple<?> filter1, ExcludeMultiple<?> filter2) {
        HashSet objs = new HashSet(filter1.toInclude);
        objs.removeAll(filter2.toExclude);
        return Filters.accept(objs);
    }

    private static <T> Predicate<T> and(AcceptOnlyOne<?> filter1, ExcludeOne<?> filter2) {
        if (!theUtil.equal(filter1.toInclude, filter2.toExclude)) {
            return filter1;
        }
        return Filters.rejectAll();
    }

    private static <T> Predicate<T> and(AcceptOnlyOne<?> filter1, ExcludeMultiple<?> filter2) {
        if (!filter2.toExclude.contains(filter1.toInclude)) {
            return filter1;
        }
        return Filters.rejectAll();
    }

    private static class AcceptOnlyMultiple<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Collection<?> toInclude;

        public AcceptOnlyMultiple(Collection<?> toInclude) {
            this.toInclude = toInclude;
        }

        @Override
        public boolean shouldFilter(T o) {
            return !this.toInclude.contains(o);
        }

        @Override
        public boolean test(T o) {
            return this.toInclude.contains(o);
        }

        public boolean equals(Object obj) {
            return obj instanceof AcceptOnlyMultiple && Filters.equalAsSets(this.toInclude, ((AcceptOnlyMultiple)obj).toInclude);
        }

        public int hashCode() {
            return 0x723498FA ^ Filters.hashAsSet(this.toInclude);
        }

        @Override
        public Predicate<T> and(Predicate<? super T> other) {
            if (other instanceof AcceptOnlyMultiple) {
                HashSet objs = new HashSet(this.toInclude);
                objs.retainAll(((AcceptOnlyMultiple)other).toInclude);
                return Filters.accept(objs);
            }
            if (other instanceof AcceptOnlyOne) {
                return Filters.and(this, (AcceptOnlyOne)other);
            }
            if (other instanceof ExcludeOne) {
                return Filters.and(this, (ExcludeOne)other);
            }
            if (other instanceof ExcludeMultiple) {
                return Filters.and(this, (ExcludeMultiple)other);
            }
            return super.and(other);
        }

        @Override
        public Predicate<T> or(Predicate<? super T> other) {
            if (other instanceof AcceptOnlyMultiple) {
                HashSet objs = new HashSet(this.toInclude);
                objs.addAll(((AcceptOnlyMultiple)other).toInclude);
                return Filters.accept(objs);
            }
            if (other instanceof AcceptOnlyOne) {
                return Filters.or(this, (AcceptOnlyOne)other);
            }
            if (other instanceof ExcludeOne) {
                return Filters.or(this, (ExcludeOne)other);
            }
            if (other instanceof ExcludeMultiple) {
                return Filters.or(this, (ExcludeMultiple)other);
            }
            return super.or(other);
        }

        @Override
        public Predicate<T> negate() {
            return new ExcludeMultiple(this.toInclude);
        }
    }

    private static class AcceptOnlyOne<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Object toInclude;

        public AcceptOnlyOne(Object toInclude) {
            this.toInclude = toInclude;
        }

        @Override
        public boolean shouldFilter(T o) {
            return !theUtil.equal(o, this.toInclude);
        }

        @Override
        public boolean test(T o) {
            return theUtil.equal(o, this.toInclude);
        }

        public boolean equals(Object obj) {
            return obj instanceof AcceptOnlyOne && theUtil.equal(this.toInclude, ((AcceptOnlyOne)obj).toInclude);
        }

        public int hashCode() {
            return 0xF23FA3 ^ theUtil.hashCode(this.toInclude);
        }

        @Override
        public Predicate<T> and(Predicate<? super T> other) {
            if (other instanceof AcceptOnlyMultiple) {
                return Filters.and((AcceptOnlyMultiple)other, this);
            }
            if (other instanceof AcceptOnlyOne) {
                AcceptOnlyOne filter2 = (AcceptOnlyOne)other;
                if (theUtil.equal(this.toInclude, filter2.toInclude)) {
                    return this;
                }
                return Predicates.alwaysFalse();
            }
            if (other instanceof ExcludeOne) {
                return Filters.and(this, (ExcludeOne)other);
            }
            if (other instanceof ExcludeMultiple) {
                return Filters.and(this, (ExcludeMultiple)other);
            }
            return super.and(other);
        }

        @Override
        public Predicate<T> or(Predicate<? super T> other) {
            if (other instanceof AcceptOnlyMultiple) {
                return Filters.or((AcceptOnlyMultiple)other, this);
            }
            if (other instanceof AcceptOnlyOne) {
                AcceptOnlyOne filter2 = (AcceptOnlyOne)other;
                if (theUtil.equal(this.toInclude, filter2.toInclude)) {
                    return this;
                }
                return Filters.accept(this.toInclude, filter2.toInclude);
            }
            if (other instanceof ExcludeOne) {
                return Filters.or(this, (ExcludeOne)other);
            }
            if (other instanceof ExcludeMultiple) {
                return Filters.or(this, (ExcludeMultiple)other);
            }
            return super.or(other);
        }

        @Override
        public Predicate<T> negate() {
            return new ExcludeOne(this.toInclude);
        }
    }

    private static class ExcludeMultiple<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Collection<?> toExclude;

        public ExcludeMultiple(Collection<?> toExclude) {
            this.toExclude = toExclude;
        }

        @Override
        public boolean shouldFilter(T o) {
            return this.toExclude.contains(o);
        }

        @Override
        public boolean test(T o) {
            return !this.toExclude.contains(o);
        }

        public boolean equals(Object obj) {
            return obj instanceof ExcludeMultiple && Filters.equalAsSets(this.toExclude, ((ExcludeMultiple)obj).toExclude);
        }

        public int hashCode() {
            return 0x72437832 ^ Filters.hashAsSet(this.toExclude);
        }

        @Override
        public Predicate<T> and(Predicate<? super T> other) {
            if (other instanceof AcceptOnlyMultiple) {
                return Filters.and((AcceptOnlyMultiple)other, this);
            }
            if (other instanceof AcceptOnlyOne) {
                return Filters.and((AcceptOnlyOne)other, this);
            }
            if (other instanceof ExcludeMultiple) {
                ExcludeMultiple filter2 = (ExcludeMultiple)other;
                HashSet objs = new HashSet(this.toExclude);
                objs.addAll(filter2.toExclude);
                return Filters.reject(objs);
            }
            if (other instanceof ExcludeOne) {
                return Filters.and(this, (ExcludeOne)other);
            }
            return super.and(other);
        }

        @Override
        public Predicate<T> or(Predicate<? super T> other) {
            if (other instanceof AcceptOnlyMultiple) {
                return Filters.or((AcceptOnlyMultiple)other, this);
            }
            if (other instanceof AcceptOnlyOne) {
                return Filters.or((AcceptOnlyOne)other, this);
            }
            if (other instanceof ExcludeMultiple) {
                ExcludeMultiple filter2 = (ExcludeMultiple)other;
                HashSet objs = new HashSet(this.toExclude);
                objs.retainAll(filter2.toExclude);
                return Filters.reject(objs);
            }
            if (other instanceof ExcludeOne) {
                return Filters.or(this, (ExcludeOne)other);
            }
            return super.or(other);
        }

        @Override
        public Predicate<T> negate() {
            return new AcceptOnlyMultiple(this.toExclude);
        }
    }

    private static class ExcludeOne<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Object toExclude;

        public ExcludeOne(Object toExclude) {
            this.toExclude = toExclude;
        }

        @Override
        public boolean shouldFilter(T o) {
            return theUtil.equal(this.toExclude, o);
        }

        @Override
        public boolean test(T o) {
            return !theUtil.equal(this.toExclude, o);
        }

        public boolean equals(Object obj) {
            return obj instanceof ExcludeOne && theUtil.equal(this.toExclude, ((ExcludeOne)obj).toExclude);
        }

        public int hashCode() {
            return 0x1672349F ^ theUtil.hashCode(this.toExclude);
        }

        @Override
        public Predicate<T> and(Predicate<? super T> other) {
            if (other instanceof AcceptOnlyMultiple) {
                return Filters.and((AcceptOnlyMultiple)other, this);
            }
            if (other instanceof AcceptOnlyOne) {
                return Filters.and((AcceptOnlyOne)other, this);
            }
            if (other instanceof ExcludeMultiple) {
                return Filters.and((ExcludeMultiple)other, this);
            }
            if (other instanceof ExcludeOne) {
                ExcludeOne filter2 = (ExcludeOne)other;
                if (theUtil.equal(this.toExclude, filter2.toExclude)) {
                    return this;
                }
                return Filters.reject(this.toExclude, filter2.toExclude);
            }
            return super.and(other);
        }

        @Override
        public Predicate<T> or(Predicate<? super T> other) {
            if (other instanceof AcceptOnlyMultiple) {
                return Filters.or((AcceptOnlyMultiple)other, this);
            }
            if (other instanceof AcceptOnlyOne) {
                return Filters.or((AcceptOnlyOne)other, this);
            }
            if (other instanceof ExcludeMultiple) {
                return Filters.or((ExcludeMultiple)other, this);
            }
            if (other instanceof ExcludeOne) {
                ExcludeOne filter2 = (ExcludeOne)other;
                if (theUtil.equal(this.toExclude, filter2.toExclude)) {
                    return this;
                }
                return Filters.alwaysTrue();
            }
            return super.or(other);
        }

        @Override
        public Predicate<T> negate() {
            return new AcceptOnlyOne(this.toExclude);
        }
    }
}

