/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import thunderheadeng.util.Disposable;

public class DisposableCounter
implements Serializable {
    static final long serialVersionUID = 1L;
    private transient int d_numReferences = 1;

    public void acquire(Disposable owner) {
        ++this.d_numReferences;
    }

    public void release(Disposable owner) {
        if (--this.d_numReferences <= 0) {
            owner.dispose();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DisposableCounter clone = (DisposableCounter)super.clone();
        clone.d_numReferences = 1;
        return clone;
    }
}

