/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;
import thunderheadeng.util.DiscreteSignal;

public class DigitalSignal
extends DiscreteSignal
implements Serializable {
    static final long serialVersionUID = 6908817182133350577L;
    private double d_sampleInterval;
    private int d_numSamples;
    private BitSet d_bits;

    protected DigitalSignal() {
    }

    @Override
    public DiscreteSignal newSignal(double sampleInterval, int numSamples) {
        return new DigitalSignal(sampleInterval, numSamples);
    }

    public DigitalSignal(double sampleInterval, int numSamples) {
        this.d_sampleInterval = sampleInterval;
        this.d_bits = new BitSet(numSamples);
        this.d_numSamples = numSamples;
    }

    @Override
    public void setSample(int sample, double value) {
        if (sample < 0 || sample >= this.d_numSamples) {
            return;
        }
        if (value >= 1.0) {
            this.d_bits.set(sample);
        } else {
            this.d_bits.clear(sample);
        }
    }

    public void setSample(int sample, boolean value) {
        if (sample < 0 || sample >= this.d_numSamples) {
            return;
        }
        if (value) {
            this.d_bits.set(sample);
        } else {
            this.d_bits.clear(sample);
        }
    }

    public void setRangeHigh(int a, int b) {
        if (a < 0) {
            a = 0;
        }
        for (int i = a; i < b && i < this.d_numSamples; ++i) {
            this.d_bits.set(i);
        }
    }

    public void setRangeLow(int a, int b) {
        if (a < 0) {
            a = 0;
        }
        for (int i = a; i < b && i < this.d_numSamples; ++i) {
            this.d_bits.clear(i);
        }
    }

    public void setRange(int a, int b, double value) {
        if (value >= 1.0) {
            this.setRangeHigh(a, b);
        } else {
            this.setRangeLow(a, b);
        }
    }

    @Override
    public double evaluateSample(int sample) {
        if (sample >= this.d_numSamples) {
            throw new IndexOutOfBoundsException("Index " + sample + " is above " + sample + ", the range of this DigitalSignal.");
        }
        return this.d_bits.get(sample) ? 1.0 : 0.0;
    }

    @Override
    public DiscreteSignal invert() {
        int max = this.getNumSamples();
        for (int t = 0; t < max; ++t) {
            if (this.d_bits.get(t)) {
                this.d_bits.clear(t);
                continue;
            }
            this.d_bits.set(t);
        }
        return this;
    }

    @Override
    public DiscreteSignal add(DiscreteSignal s) {
        DigitalSignal ds = (DigitalSignal)s;
        if (this.getSampleInterval() != ds.getSampleInterval()) {
            DigitalSignal newSig = (DigitalSignal)ds.clone();
            newSig.resample(this.getSampleInterval());
            this.d_bits.or(newSig.d_bits);
        } else {
            this.d_bits.or(ds.d_bits);
        }
        return this;
    }

    @Override
    public DiscreteSignal multiply(DiscreteSignal s) {
        DigitalSignal ds = (DigitalSignal)s;
        if (this.getSampleInterval() != ds.getSampleInterval()) {
            DigitalSignal newSig = (DigitalSignal)ds.clone();
            newSig.resample(this.getSampleInterval());
            this.d_bits.and(newSig.d_bits);
        } else {
            this.d_bits.and(ds.d_bits);
        }
        return this;
    }

    @Override
    public void resample(double newSampleInterval) {
        if (newSampleInterval == this.d_sampleInterval) {
            return;
        }
        int newNumSamples = (int)Math.ceil((double)this.d_numSamples * this.d_sampleInterval / newSampleInterval);
        BitSet newBits = new BitSet(newNumSamples);
        for (int i = 0; i < newNumSamples; ++i) {
            int oldIndex = (int)Math.floor((double)i * this.d_sampleInterval / newSampleInterval);
            if (this.evaluate(oldIndex) >= 1.0) {
                newBits.set(i);
                continue;
            }
            newBits.clear(i);
        }
        this.d_sampleInterval = newSampleInterval;
        this.d_numSamples = newNumSamples;
        this.d_bits = newBits;
    }

    @Override
    public int getNumSamples() {
        return this.d_numSamples;
    }

    @Override
    public double getSampleInterval() {
        return this.d_sampleInterval;
    }

    public int[] getTransitions() {
        int i;
        double nextToFind = 1.0;
        Vector<Integer> transIndexes = new Vector<Integer>();
        for (i = 0; i < this.d_numSamples; ++i) {
            if (this.evaluateSample(i) != nextToFind) continue;
            transIndexes.add(i);
            nextToFind = nextToFind != 1.0 ? 1 : 0;
        }
        int[] trans = new int[transIndexes.size()];
        for (i = 0; i < trans.length; ++i) {
            trans[i] = (Integer)transIndexes.get(i);
        }
        return trans;
    }

    public void setTransitions(int[] transIndexes) {
        int i;
        int nNextTrans = 0;
        boolean bNextToSet = false;
        for (i = 0; nNextTrans < transIndexes.length && i < this.d_numSamples; ++i) {
            if (i == transIndexes[nNextTrans]) {
                bNextToSet = !bNextToSet;
                ++nNextTrans;
            }
            if (bNextToSet) {
                this.d_bits.set(i);
                continue;
            }
            this.d_bits.clear(i);
        }
        if (bNextToSet) {
            this.setRangeHigh(i, this.d_numSamples);
        } else {
            this.setRangeLow(i, this.d_numSamples);
        }
    }

    public Object clone() {
        DigitalSignal cloned = null;
        try {
            cloned = (DigitalSignal)super.clone();
            cloned.d_bits = (BitSet)this.d_bits.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("CloneNotSupportedException caught: " + e.toString());
        }
        return cloned;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DigitalSignal)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DigitalSignal sig = (DigitalSignal)obj;
        return this.d_numSamples == sig.d_numSamples && this.d_sampleInterval == sig.d_sampleInterval && this.d_bits.equals(sig.d_bits);
    }
}

