/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.AEventRec;
import thunderheadeng.util.CompositeIterator;
import thunderheadeng.util.EmptyEventRec;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Predicates;

public class CompositeEvtRec<ObjT>
extends AEventRec<ObjT> {
    private final List<? extends IEventRecord<? extends ObjT>> d_channels;
    private Set<Object> d_cachedChanges;

    public CompositeEvtRec(Collection<? extends IEventRecord<? extends ObjT>> channels) {
        this.d_channels = channels instanceof List ? (List<Object>)channels : new ArrayList<IEventRecord<? extends ObjT>>(channels);
    }

    @Override
    public IEventRecord<ObjT> filter(Predicate<? super ObjT> filter) {
        if (Predicates.alwaysTrue(filter)) {
            return this;
        }
        if (Predicates.alwaysFalse(filter)) {
            return EmptyEventRec.INSTANCE;
        }
        ArrayList<IEventRecord<? super ObjT>> newChannels = new ArrayList<IEventRecord<? super ObjT>>(this.d_channels.size());
        for (IEventRecord<? super ObjT> iEventRecord : this.d_channels) {
            newChannels.add(iEventRecord.filter(filter));
        }
        return new CompositeEvtRec<ObjT>(newChannels);
    }

    @Override
    public boolean isModified() {
        for (IEventRecord<ObjT> rec : this.d_channels) {
            if (!rec.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ObjT> getAddedObjs() {
        return new CompAddSet();
    }

    @Override
    public Set<ObjT> getRemovedObjs() {
        return new CompRemoveSet();
    }

    @Override
    public Set<Object> getChanges() {
        if (this.d_cachedChanges == null) {
            this.d_cachedChanges = new LinkedHashSet<Object>();
            for (IEventRecord<ObjT> rec : this.d_channels) {
                this.d_cachedChanges.addAll(rec.getChanges());
            }
        }
        return this.d_cachedChanges;
    }

    @Override
    public Set<ObjT> getChangedObjs(Object ... changes) {
        return new CompChangedObjsSet(changes);
    }

    @Override
    public Set<ObjT> getChangedObjs(Predicate<Object> changeFilter) {
        return new CompChangedObjsSet2(changeFilter);
    }

    @Override
    public boolean isChanged(Object obj) {
        for (IEventRecord<ObjT> channel : this.d_channels) {
            if (!channel.isChanged(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChanged(Object obj, Object change) {
        for (IEventRecord<ObjT> channel : this.d_channels) {
            if (!channel.isChanged(obj, change)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsChange(Object change) {
        for (IEventRecord<ObjT> channel : this.d_channels) {
            if (!channel.containsChange(change)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getChanges(Object obj, Collection<Object> changes) {
        for (IEventRecord<ObjT> channel : this.d_channels) {
            if (!channel.isChanged(obj)) continue;
            channel.getChanges(obj, changes);
            return;
        }
    }

    private class CompChangedObjsSet2
    extends CompositeSet<ObjT> {
        private final Predicate<Object> d_filter;

        public CompChangedObjsSet2(Predicate<Object> filter) {
            this.d_filter = filter;
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> channel) {
            return channel.getChangedObjs(this.d_filter);
        }
    }

    private class CompChangedObjsSet
    extends CompositeSet<ObjT> {
        private final Object[] d_changes;

        public CompChangedObjsSet(Object[] changes) {
            this.d_changes = changes;
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> channel) {
            return channel.getChangedObjs(this.d_changes);
        }
    }

    private class CompRemoveSet
    extends CompositeSet<ObjT> {
        private CompRemoveSet() {
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> channel) {
            return channel.getRemovedObjs();
        }
    }

    private class CompAddSet
    extends CompositeSet<ObjT> {
        private CompAddSet() {
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> channel) {
            return channel.getAddedObjs();
        }
    }

    private abstract class CompositeSet<E>
    extends AbstractSet<E> {
        private final Map<IEventRecord<? extends ObjT>, Set<? extends E>> d_cachedSets = new IdentityHashMap();

        protected abstract Set<? extends E> getSet(IEventRecord<? extends ObjT> var1);

        protected Set<? extends E> getCachedSet(IEventRecord<? extends ObjT> channel) {
            Set<Object> set = this.d_cachedSets.get(channel);
            if (set == null) {
                set = this.getSet(channel);
                this.d_cachedSets.put(channel, set);
            }
            return set;
        }

        @Override
        public Iterator<E> iterator() {
            ArrayList<Set<E>> sets = new ArrayList<Set<E>>(CompositeEvtRec.this.d_channels.size());
            for (IEventRecord channel : CompositeEvtRec.this.d_channels) {
                sets.add(this.getCachedSet(channel));
            }
            return new CompositeIterator(sets);
        }

        @Override
        public int size() {
            int size = 0;
            for (IEventRecord channel : CompositeEvtRec.this.d_channels) {
                size += this.getCachedSet(channel).size();
            }
            return size;
        }

        @Override
        public boolean contains(Object o) {
            for (IEventRecord channel : CompositeEvtRec.this.d_channels) {
                if (!this.getCachedSet(channel).contains(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            for (IEventRecord channel : CompositeEvtRec.this.d_channels) {
                if (this.getCachedSet(channel).isEmpty()) continue;
                return false;
            }
            return true;
        }
    }
}

