/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.HashMap;
import java.util.Map;
import thunderheadeng.util.theUtil;

public class ClassLookup<ValT> {
    private final Map<Class, ValT> d_map = new HashMap<Class, ValT>();
    private final boolean d_cacheLookups;

    public ClassLookup() {
        this(true);
    }

    public ClassLookup(boolean cacheLookups) {
        this.d_cacheLookups = cacheLookups;
    }

    public ValT find(Class type) {
        if (this.d_map.containsKey(type)) {
            return this.d_map.get(type);
        }
        ValT val = theUtil.findObjectForClass(this.d_map, type);
        if (this.d_cacheLookups) {
            this.d_map.put(type, val);
        }
        return val;
    }

    public void add(Class type, ValT val) {
        this.d_map.put(type, val);
    }
}

