/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.Iterator;

public class Bag<E>
extends AbstractCollection<E> {
    private Object d_removeMark;
    private int d_removeMarkCount = 0;
    private static final int SZ_INIT = 17;
    private Object[] d_data = new Object[17];
    private double d_loadFactor = 0.49;
    private int d_size = 0;

    public Bag() {
        this.d_removeMark = new Object();
    }

    @Override
    public boolean add(E elem) {
        if (elem == null) {
            throw new NullPointerException();
        }
        if ((double)this.d_size > (double)this.d_data.length * this.d_loadFactor) {
            this.d_data = Bag.rehash(this);
        }
        if (!this.contains(elem)) {
            this.d_data[Bag.probeForInsertIx((Object[])this.d_data, elem)] = elem;
            ++this.d_size;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.d_data = new Object[17];
        this.d_size = 0;
        this.d_removeMarkCount = 0;
    }

    @Override
    public boolean remove(Object elem) {
        return Bag.remove(this, Bag.find(this.d_data, elem));
    }

    private static boolean remove(Bag b, int ix) {
        if (ix != -1) {
            b.d_data[ix] = b.d_removeMark;
            ++b.d_removeMarkCount;
            --b.d_size;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object elem) {
        return Bag.find(this.d_data, elem) != -1;
    }

    private static int probeForInsertIx(Object[] data, Object elem) {
        int ix = elem.hashCode() % data.length;
        int it = 1;
        while (data[ix] != null) {
            ix = (ix + it * it) % data.length;
            ++it;
        }
        return ix;
    }

    private static int find(Object[] data, Object elem) {
        if (elem == null) {
            return -1;
        }
        int ix = elem.hashCode() % data.length;
        int it = 1;
        while (data[ix] != elem) {
            if (data[ix] == null) {
                return -1;
            }
            ix = (ix + it * it) % data.length;
            ++it;
        }
        return ix;
    }

    private static Object[] rehash(Bag b) {
        String strLen = Integer.toString(b.d_data.length * 2 - 1);
        int szNext = new BigInteger(strLen).nextProbablePrime().intValue();
        Object[] newData = new Object[szNext];
        Iterator it = Bag.iterator(b);
        while (it.hasNext()) {
            Object o = it.next();
            newData[Bag.probeForInsertIx((Object[])newData, o)] = o;
        }
        b.d_removeMarkCount = 0;
        return newData;
    }

    @Override
    public Iterator<E> iterator() {
        return Bag.iterator(this);
    }

    private static <E> Iterator<E> iterator(final Bag b) {
        return new Iterator<E>(){
            int ix = this.findNext(0);
            int current = -1;

            private int findNext(int start) {
                for (int i = start; i < b.d_data.length; ++i) {
                    if (b.d_data[i] == null) continue;
                    return i;
                }
                return b.d_data.length;
            }

            @Override
            public boolean hasNext() {
                return this.ix < b.d_data.length;
            }

            @Override
            public E next() {
                this.current = this.ix;
                this.ix = this.findNext(this.current + 1);
                assert (b.d_data[this.current] != null);
                return b.d_data[this.current];
            }

            @Override
            public void remove() {
                Bag.remove(b, this.current);
            }
        };
    }

    @Override
    public int size() {
        return this.d_size;
    }
}

