/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IFilteredIterator;

public abstract class AFilteredCollection<T, BaseT>
extends AbstractCollection<T>
implements IFilteredCollection<T> {
    private final Collection<? extends BaseT> d_coll;
    private int d_size = -1;
    private Boolean d_cachedEmpty = null;
    private Boolean d_cachedExclusive = null;

    @Override
    public abstract IFilteredIterator<T> iterator();

    protected abstract boolean accept(Object var1);

    public AFilteredCollection(Collection<? extends BaseT> coll) {
        this.d_coll = coll;
    }

    public Collection<? extends BaseT> getUnfiltered() {
        return this.d_coll;
    }

    @Override
    public boolean contains(Object o) {
        return this.accept(o) && this.d_coll.contains(o);
    }

    @Override
    public boolean isExclusive() {
        if (this.d_cachedExclusive == null) {
            Iterator it = this.iterator();
            while (it.hasNext() && it.getSkippedCount() <= 0) {
                it.next();
            }
            this.d_cachedExclusive = it.getSkippedCount() == 0;
        }
        return this.d_cachedExclusive;
    }

    @Override
    public boolean isExclusive(int count) {
        if (this.d_cachedExclusive != null) {
            return this.d_cachedExclusive != false && this.d_coll.size() == count;
        }
        return this.d_coll.size() == count && this.isExclusive();
    }

    @Override
    public int size() {
        if (this.d_size == -1) {
            this.d_size = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                ++this.d_size;
                it.next();
            }
        }
        return this.d_size;
    }

    @Override
    public boolean isEmpty() {
        if (this.d_cachedEmpty == null) {
            Iterator it;
            this.d_cachedEmpty = this.d_size == -1 ? Boolean.valueOf(!(it = this.iterator()).hasNext()) : Boolean.valueOf(this.d_size == 0);
        }
        return this.d_cachedEmpty;
    }
}

