/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;

public abstract class AEventRec<ObjT>
implements IEventRecord<ObjT> {
    @Override
    public boolean isModified() {
        return !this.getAddedObjs().isEmpty() || !this.getRemovedObjs().isEmpty() || !this.getChanges().isEmpty();
    }

    @Override
    public boolean areAddsOnly() {
        return this.hasAddedObjs() && !this.hasRemovedObjs() && !this.hasChangedObjs();
    }

    @Override
    public boolean areRemovesOnly() {
        return !this.hasAddedObjs() && this.hasRemovedObjs() && !this.hasChangedObjs();
    }

    @Override
    public boolean areChangesOnly() {
        return !this.hasAddedObjs() && !this.hasRemovedObjs() && this.hasChangedObjs();
    }

    @Override
    public boolean hasAddedObjs() {
        return !this.getAddedObjs().isEmpty();
    }

    @Override
    public boolean hasRemovedObjs() {
        return !this.getRemovedObjs().isEmpty();
    }

    @Override
    public boolean hasChangedObjs() {
        return !this.getChanges().isEmpty();
    }

    @Override
    public boolean hasChangedObjs(Object ... changes) {
        Set<Object> allChanges = this.getChanges();
        for (Object change : changes) {
            if (!allChanges.contains(change)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChangedObjs(Predicate<Object> changeFilter) {
        for (Object change : this.getChanges()) {
            if (!changeFilter.test(change)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areChangesExclusiveTo(Object ... changes) {
        if (changes.length >= 1) {
            int count = 0;
            for (Object change : changes) {
                if (!this.hasChangedObjs(change)) continue;
                ++count;
            }
            return count == this.getChanges().size();
        }
        assert (false);
        return false;
    }

    @Override
    public boolean areChangesExclusiveTo(Predicate<Object> changeFilter) {
        if (changeFilter == Filters.rejectAll()) {
            return false;
        }
        if (changeFilter == Filters.acceptAll()) {
            return true;
        }
        Set<Object> changes = this.getChanges();
        for (Object change : changes) {
            if (changeFilter.test(change)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<ObjT> getChangedNotOfType(Object ... changes) {
        LinkedHashSet<Object> types = new LinkedHashSet<Object>(this.getChanges());
        types.removeAll(Arrays.asList(changes));
        if (types.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return this.getChangedObjs(types.toArray());
    }
}

