/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.tools;

import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import thunderheadeng.scene3d.navtools.CursorTool;

public class MouseHistory {
    private final Deque<Point> d_history = new ArrayDeque<Point>();
    private final List<IListener> d_listeners = new ArrayList<IListener>();
    private boolean d_duplicatePointsAllowed = false;

    public void setDuplicatesAllowed(boolean allowed) {
        this.d_duplicatePointsAllowed = allowed;
    }

    public boolean getDuplicatesAllowed() {
        return this.d_duplicatePointsAllowed;
    }

    public void addListener(IListener listener) {
        this.d_listeners.remove(listener);
        this.d_listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        this.d_listeners.remove(listener);
    }

    public void reset() {
        this.d_history.clear();
    }

    public Point3d getLastCommitted() {
        Point p = this.getLastCommittedPoint();
        return p != null ? p.p : null;
    }

    public Point getLastCommittedPoint() {
        if (!this.d_history.isEmpty()) {
            Point result;
            Point temporary = !this.d_history.peekLast().committed ? this.d_history.removeLast() : null;
            Point point = result = !this.d_history.isEmpty() ? this.d_history.peekLast() : null;
            if (temporary != null) {
                this.d_history.addLast(temporary);
            }
            return result;
        }
        return null;
    }

    public void mouseMoved(CursorTool tool, MouseEvent e, CursorTool.SnapInfo recordPt) {
        if (recordPt == null) {
            return;
        }
        this.addPoint(recordPt, !recordPt.snaps.isEmpty(), false, false);
    }

    public void mousePressed(CursorTool tool, MouseEvent e, CursorTool.SnapInfo recordPt) {
        if (recordPt == null) {
            return;
        }
        if (e.getButton() == 1) {
            this.addPoint(recordPt, !recordPt.snaps.isEmpty(), true, false);
        }
    }

    public void mouseDragged(CursorTool tool, MouseEvent e, CursorTool.SnapInfo recordPt) {
        if (recordPt == null) {
            return;
        }
        if (tool.isDragging(1) && tool.aboveTolerance(0)) {
            this.addPoint(recordPt, !recordPt.snaps.isEmpty(), false, true);
        }
    }

    public void mouseReleased(CursorTool tool, MouseEvent e, CursorTool.SnapInfo recordPt) {
        if (recordPt == null) {
            return;
        }
        if (e.getButton() == 1 && tool.dragAboveTolerance(0)) {
            this.addPoint(recordPt, !recordPt.snaps.isEmpty(), true, true);
        }
    }

    public void finalizePoints() {
        if (!this.d_history.isEmpty() && !this.d_history.peekLast().committed) {
            this.d_history.removeLast();
            if (!this.d_history.isEmpty()) {
                this.d_history.peekLast().committed = true;
            }
        }
    }

    public void addPoint(CursorTool.SnapInfo recordPt, boolean commit) {
        this.addPoint(recordPt, true, commit, false);
    }

    protected void addPoint(CursorTool.SnapInfo p, boolean snapped, boolean commit, boolean dragged) {
        if (p != null && !p.constrained.isEmpty()) {
            if (!this.d_history.isEmpty() && !this.d_history.peekLast().committed) {
                this.d_history.removeLast();
            }
            if (this.d_history.isEmpty() || this.d_duplicatePointsAllowed || !this.d_history.peekLast().p.equals((Tuple3d)p.constrained.getLast())) {
                Point point = new Point(p, snapped, dragged, commit);
                this.d_history.addLast(point);
                for (IListener listener : this.d_listeners) {
                    listener.pointAdded(this, point);
                }
            }
        }
    }

    public int size() {
        return this.d_history.size();
    }

    public int committedSize() {
        return !this.d_history.isEmpty() && !this.d_history.getLast().committed ? this.d_history.size() - 1 : this.d_history.size();
    }

    public Deque<Point> getHistory() {
        return this.d_history;
    }

    public List<Point3d> getAllPoints() {
        ArrayList<Point3d> points = new ArrayList<Point3d>(this.d_history.size());
        for (Point p : this.d_history) {
            points.add(p.p);
        }
        return points;
    }

    public List<Point3d> getCommittedPoints() {
        ArrayList<Point3d> points = new ArrayList<Point3d>(this.d_history.size());
        for (Point p : this.d_history) {
            if (!p.committed) continue;
            points.add(p.p);
        }
        return points;
    }

    public Point3d getTemporaryPoint() {
        return !this.d_history.isEmpty() && !this.d_history.getLast().committed ? this.d_history.getLast().p : null;
    }

    public static interface IListener {
        public void pointAdded(MouseHistory var1, Point var2);
    }

    public static class Point {
        public final Point3d p;
        public final CursorTool.SnapInfo snap;
        public final boolean snapped;
        public final boolean dragged;
        public boolean committed;

        public Point(CursorTool.SnapInfo snap, boolean snapped, boolean dragged, boolean committed) {
            this.p = snap.constrained.getLast();
            this.snap = snap;
            this.snapped = snapped;
            this.committed = committed;
            this.dragged = dragged;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Point && ((Point)obj).p.epsilonEquals((Tuple3d)this.p, 1.0E-9);
        }
    }
}

