/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.util.theUtil;

public class PolarSnap
implements IPickable {
    public final Point3d origin;
    public final Vector3d reference;
    public final Vector3d axis;
    public final double angle;
    public final double[] additionalAngles;
    private final Vector3d[] d_dirs;

    public PolarSnap(Point3d origin, Vector3d axis, Vector3d reference, double angle, double ... additionalAngles) {
        this.origin = origin;
        this.reference = reference;
        this.axis = axis;
        this.angle = angle;
        this.additionalAngles = additionalAngles;
        HashSet<Double> allAngles = new HashSet<Double>();
        for (double addAngle : additionalAngles) {
            allAngles.add(addAngle);
        }
        double addAngle = 0.0;
        while (theUtil.lt(addAngle, Math.PI * 2, 1.0E-9)) {
            allAngles.add(addAngle);
            addAngle += angle;
        }
        double[] angles = theUtil.toDoubleArray(allAngles);
        Arrays.sort(angles);
        Matrix4d xform = new Matrix4d();
        AxisAngle4d aa = new AxisAngle4d();
        this.d_dirs = new Vector3d[angles.length];
        for (int m = 0; m < angles.length; ++m) {
            aa.set(axis, angles[m]);
            xform.set(aa);
            this.d_dirs[m] = Util3D.xform(xform, reference);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        for (Vector3d dir : this.d_dirs) {
            double[] t;
            LineConstraint constraint = new LineConstraint(this.origin, dir);
            if (!filter.acceptPickObject(constraint) || !filter.acceptGeomType(constraint, GeomType.EDGE) || (t = Inter3D.lineLineProximityT(rayBegin, rayDirN, this.origin, dir, 1.0E-9)) == null || !theUtil.ge0(t[1], 1.0E-9)) continue;
            Point3d isect = Util3D.linePoint(this.origin, dir, t[1]);
            isects.addInfinite(constraint, isect, GeomType.EDGE, new LineSeg(this.origin, Util3D.add(this.origin, (Tuple3d)dir)));
        }
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }
}

