/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public class PointConstraint
implements ISnapConstraint {
    public final Point3d p;

    public PointConstraint(Point3d p) {
        this.p = p;
    }

    @Override
    public Point3d snapPoint(Point3d p) {
        return p;
    }

    @Override
    public Pair<Point3d, Point3d> snapRay(Point3d rayBegin, Vector3d rayDir) {
        Point3d nearest = Inter3D.nearestPointOnLine(rayBegin, rayDir, this.p);
        return new Pair<Point3d, Point3d>(nearest, this.p);
    }

    @Override
    public ISnapConstraint transform(Matrix4d xform) {
        return new PointConstraint(Util3D.xform(xform, this.p));
    }
}

