/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.LineConstraint;

public class OrthoSnap
implements IPickable {
    public final Point3d origin;
    public final Vector3d[] axes;

    public OrthoSnap(Point3d origin) {
        this(origin, GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS);
    }

    public OrthoSnap(Point3d origin, Vector3d ... axes) {
        this.origin = origin;
        this.axes = axes;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        for (Vector3d dir : this.axes) {
            double[] t;
            LineConstraint constraint = new LineConstraint(this.origin, dir);
            if (!filter.acceptPickObject(constraint) || !filter.acceptGeomType(constraint, GeomType.EDGE) || (t = Inter3D.lineLineProximityT(rayBegin, rayDirN, this.origin, dir, 1.0E-9)) == null) continue;
            Point3d isect = Util3D.linePoint(this.origin, dir, t[1]);
            isects.addInfinite(constraint, isect, GeomType.EDGE, new LineSeg(this.origin, Util3D.add(this.origin, (Tuple3d)dir)));
        }
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }
}

