/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public class LineConstraint
implements ISnapConstraint {
    public final Point3d p;
    public final Vector3d dir;

    public LineConstraint(Point3d p, Vector3d dir) {
        this.p = p;
        this.dir = dir;
    }

    @Override
    public Pair<Point3d, Point3d> snapRay(Point3d rayBegin, Vector3d rayDir) {
        double[] t = Inter3D.lineLineProximityT(rayBegin, rayDir, this.p, this.dir, 1.0E-9);
        if (t == null || Double.isNaN(t[1]) || Double.isNaN(t[0])) {
            return null;
        }
        if (t[0] < 0.0) {
            t[0] = 0.0;
            t[1] = Inter3D.nearestTOnLine(this.p, this.dir, rayBegin);
        }
        return new Pair<Point3d, Point3d>(Util3D.linePoint(rayBegin, rayDir, t[0]), Util3D.linePoint(this.p, this.dir, t[1]));
    }

    @Override
    public Point3d snapPoint(Point3d p) {
        return Inter3D.nearestPointOnLine(this.p, this.dir, p);
    }

    @Override
    public ISnapConstraint transform(Matrix4d xform) {
        Point3d pa = Util3D.xform(xform, this.p);
        Vector3d da = Util3D.xform(xform, this.dir);
        return new LineConstraint(pa, da);
    }
}

