/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;

public interface IPickable {
    public static final IPropsSrc DEF_PROPS = new UniformProps(IPrimProps.DEF);

    public void pickPoints(IIsectCollector var1, IIsectFilter var2, Point3d var3, Point3d var4, Vector3d var5, ITest<AABox> var6);

    public void pickBox(IBoxCollector var1, IIsectFilter var2, ConvexHull var3);

    @Deprecated
    default public void getAll(IBoxCollector result, IIsectFilter filter) {
    }

    public void getAll(Consumer<Object> var1, IIsectFilter var2);

    public static void pickPoints(Object source, Supplier<DisplayGeom> getPickGeom, IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (!filter.acceptPickObject(source)) {
            return;
        }
        DisplayGeom dg = getPickGeom.get();
        dg.node.pickPoints(IPickable.convertCollector(isects, dg.props), filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    public static void pickBox(Object source, Supplier<DisplayGeom> getPickGeom, IBoxCollector result, IIsectFilter filter, ConvexHull region) {
        if (!filter.acceptPickObject(source)) {
            return;
        }
        DisplayGeom pgeom = getPickGeom.get();
        try {
            pgeom.node.pickBox(source, filter, region, IPickable.convertCollector(result, pgeom.props));
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public static void getAll(Object source, Consumer<Object> result, IIsectFilter filter) {
        if (filter.acceptPickObject(source)) {
            result.accept(source);
        }
    }

    public static thunderheadeng.geometry.objs.IIsectCollector convertCollector(final IIsectCollector pickCollector, final IPropsSrc props) {
        return new thunderheadeng.geometry.objs.IIsectCollector(){

            @Override
            public void addNonFace(Object obj, Point3d p, GeomType type) {
                pickCollector.addNonFace(obj, p, type);
            }

            @Override
            public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal) {
                pickCollector.addFace(obj, p, getPrim, getNormal, props.get(primIx));
            }

            @Override
            public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
                pickCollector.addInfinite(obj, p, type, prim);
            }

            @Override
            public TaskProgress getProgress() {
                return pickCollector.getProgress();
            }
        };
    }

    public static thunderheadeng.geometry.objs.IBoxCollector convertCollector(final IBoxCollector pickCollector, final IPropsSrc props) {
        return new thunderheadeng.geometry.objs.IBoxCollector(){

            @Override
            public void addNonFace(Object obj) throws CancelledException {
                pickCollector.addNonFace(obj);
            }

            @Override
            public void addFace(Object obj, int primIx, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal) throws CancelledException {
                pickCollector.addFace(obj, getPointAndNormal, props.get(primIx));
            }
        };
    }
}

