/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Ray3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickConfig;
import thunderheadeng.scene3d.picking.IPickRoot;
import thunderheadeng.scene3d.picking.IPickSession;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.RayPointProx;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class GeomPicker {
    private static final boolean PROFILE = false;
    private final IPickRoot d_geometry;
    private final View d_view;
    private boolean d_occlusionFilterEnabled;
    private final theTimer d_timer = null;
    private final Runnable profileStart = () -> {};
    private final Runnable profileEnd = () -> {};
    public static final IIsectFilter ACCEPT_ALL = new DefaultFilter();

    public GeomPicker(IPickRoot geometry, View view) {
        this.d_geometry = geometry;
        this.d_view = view;
        this.d_occlusionFilterEnabled = true;
    }

    public void setOcclusionFilteringEnabled(boolean enabled) {
        this.d_occlusionFilterEnabled = enabled;
    }

    public boolean isOcclusionFilteringEnabled() {
        return this.d_occlusionFilterEnabled;
    }

    public IPickRoot getGeomSource() {
        return this.d_geometry;
    }

    @Deprecated
    public IsectInfo pickClosest(Mode searchMode, Point2d viewScr, double screenTol) {
        return this.pickClosest(searchMode, viewScr, screenTol, ACCEPT_ALL);
    }

    @Deprecated
    public IsectInfo pickClosest(Mode searchMode, Point2d viewScr, double screenTol, IIsectFilter filter) {
        try {
            Collection<IsectInfo> isects = this.pick(new TaskProgress(), searchMode, viewScr, screenTol, filter);
            Iterator<IsectInfo> it = isects.iterator();
            if (!it.hasNext()) {
                return null;
            }
            return it.next();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Collection<IsectInfo> pick(TaskProgress progress, Mode searchMode, Point2d viewScr, double screenTol) {
        return this.pick(progress, searchMode, viewScr, screenTol, ACCEPT_ALL);
    }

    private static boolean acceptsOnly(IIsectFilter filter, GeomType type) {
        if (!filter.acceptGeomType(null, type)) {
            return false;
        }
        for (GeomType gtype : GeomType.values()) {
            if (gtype == type || !filter.acceptGeomType(null, gtype)) continue;
            return false;
        }
        return true;
    }

    public Collection<IsectInfo> pick(TaskProgress progress, Mode searchMode, Point2d viewScr, double screenTol, IIsectFilter filter) {
        this.profileStart.run();
        if (screenTol > 0.0 && GeomPicker.acceptsOnly(filter, GeomType.FACE)) {
            screenTol = 0.0;
        }
        Ray3d ray = this.getPickRay(viewScr);
        ArrayList<IsectInfo> allIsects = new ArrayList<IsectInfo>();
        IPickSession session = this.d_geometry.beginPicking();
        for (IPickConfig pickConfig : session.getPickConfigs()) {
            IRayProxDetector proxDet;
            ITest<AABox> test;
            Ray3d clipRay = GeomPicker.trim(ray, pickConfig.getClippingRegion());
            if (clipRay == null) continue;
            if (screenTol > 0.0) {
                Box3d frustum = this.d_view.toFrustum(viewScr, screenTol);
                ConvexHull ch = GeomPicker.intersect(frustum, pickConfig.getClippingRegion());
                test = new CHTest(ch);
                proxDet = new RayTolProxDetector(this.d_view, ray.origin, viewScr, screenTol, ch);
            } else {
                test = new LineSegRTreeTest(clipRay.p1(), clipRay.p2());
                proxDet = new RayProxDetector(ray.origin, clipRay);
            }
            VisibilityFilter cfilter = new VisibilityFilter(filter, session, pickConfig);
            RaySearchResult result = new RaySearchResult(progress, this.d_view, session, searchMode, cfilter, clipRay, test, proxDet, pickConfig);
            session.find(pickConfig, test, result);
            allIsects.addAll(result.getIsects());
        }
        IsectSorter sorter = new IsectSorter(searchMode, session);
        Collections.sort(allIsects, sorter);
        Collection<IsectInfo> isects = !this.d_occlusionFilterEnabled ? allIsects : theUtil.filter(allIsects, Filters.cache(new OcclusionFilter(session, progress, ray)));
        if (isects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        this.profileEnd.run();
        return isects;
    }

    private static Ray3d trim(Ray3d ls, ConvexHull ch) {
        if (ch.acceptsAll()) {
            return ls;
        }
        if (ch.acceptsNone()) {
            return null;
        }
        Vector3d lineDir = ls.dir;
        double[] ts = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        DoubleConsumer addT = t -> {
            if (t < ts[0]) {
                dArray[0] = t;
            }
            if (t > ts[1]) {
                dArray[1] = t;
            }
        };
        BooleanSupplier isDone = () -> ts[0] <= 0.0 && ts[1] >= 1.0;
        if (ch.contains(ls.p1(), 1.0E-9)) {
            addT.accept(0.0);
        }
        if (ch.contains(ls.p2(), 1.0E-9)) {
            addT.accept(ls.length);
        }
        Plane3d[] planes = ch.getPlanes();
        for (int m = 0; m < planes.length && !isDone.getAsBoolean(); ++m) {
            Plane3d plane = planes[m];
            double distt = Inter3D.linePlaneIntersectionT(ls.origin, lineDir, plane, 1.0E-9);
            if (Double.isNaN(distt) || !theUtil.ge0(distt, 1.0E-9) || !theUtil.le(distt, ls.length, 1.0E-9) || !ch.contains(ls.evaluate(distt), 1.0E-9)) continue;
            addT.accept(distt);
        }
        if (ts[0] > ts[1]) {
            return null;
        }
        return new Ray3d(ls.get(ts[0]), ls.dir, ts[1] - ts[0]);
    }

    private static ConvexHull intersect(Box3d box, ConvexHull ch) {
        return box.toConvexHull().intersect(ch, true);
    }

    public Collection<Object> pickBox(Point2d viewScr1, Point2d viewScr2) {
        return this.pickBox(viewScr1, viewScr2, ACCEPT_ALL);
    }

    public Collection<Object> pickBox(Point2d viewScr1, Point2d viewScr2, IIsectFilter filter) {
        Box3d frustum = this.d_view.toFrustum(viewScr1, viewScr2);
        IPickSession session = this.d_geometry.beginPicking();
        IPickConfig[] configs = session.getPickConfigs();
        ArrayList<Object> allObjs = configs.length == 1 ? new ArrayList() : new LinkedIdentityHashSet();
        for (IPickConfig config : configs) {
            VisibilityFilter cfilter = new VisibilityFilter(filter, session, config);
            ConvexHull ch = GeomPicker.intersect(frustum, config.getClippingRegion());
            BoxSearchResult result = new BoxSearchResult(this.d_view, cfilter, ch, session);
            session.find(config, new CHTest(ch), result);
            allObjs.addAll(result.d_objs);
        }
        return allObjs;
    }

    private Ray3d getPickRay(Point2d viewScr) {
        Point3d rayBegin = this.d_view.screenToWorld(new Point3d(viewScr.x, viewScr.y, 0.0));
        Point3d rayEnd = this.d_view.screenToWorld(new Point3d(viewScr.x, viewScr.y, 1.0));
        return new Ray3d(rayBegin, rayEnd);
    }

    public double findOccluderDistSq(Point3d p) {
        IsectInfo occluder = this.findOccluder(new TaskProgress(), p);
        if (occluder == null) {
            return Double.NaN;
        }
        return occluder.isectPoint.distanceSquared(p);
    }

    public IsectInfo findOccluder(TaskProgress progress, Point3d p) {
        return this.findOccluder(progress, p, false);
    }

    public IsectInfo findOccluder(TaskProgress progress, Point3d p, boolean findClosest) {
        Matrix4d wsXform = this.d_view.getTransform(3, 0);
        Matrix4d swXform = this.d_view.getTransform(0, 3);
        Point3d screen = Util3D.xform(wsXform, p, true);
        screen.z = 0.0;
        Point3d nearP = Util3D.xform(swXform, screen, true);
        Ray3d ray = new Ray3d(nearP, p);
        return this.findOccluder(progress, ray, findClosest);
    }

    protected IsectInfo findOccluder(TaskProgress progress, Ray3d ray, boolean findClosest) {
        IPickSession session = this.d_geometry.beginPicking();
        Point3d p = ray.p2();
        OccludedPointIsectFilter occlfilter = new OccludedPointIsectFilter(session, p, findClosest);
        try {
            IPickConfig[] configs;
            for (IPickConfig config : configs = session.getPickConfigs()) {
                Ray3d trimRay = GeomPicker.trim(ray, config.getClippingRegion());
                if (trimRay == null) continue;
                LineSegRTreeTest test = new LineSegRTreeTest(trimRay.p1(), trimRay.p2());
                RayProxDetector proxDet = new RayProxDetector(ray.origin, trimRay);
                VisibilityFilter filter = new VisibilityFilter(occlfilter, session, config);
                RaySearchResult result = new RaySearchResult(progress, this.d_view, session, Mode.SNAP, filter, trimRay, proxDet, config);
                session.find(config, test, result);
            }
        }
        catch (HaltException haltException) {
            // empty catch block
        }
        return occlfilter.occluder;
    }

    @Deprecated
    protected final double findOccluderDistSq(TaskProgress progress, Ray3d originalRay, IFace prim, Ray3d ray) {
        return Double.NaN;
    }

    protected double findOccluderDistSq(final TaskProgress progress, Ray3d originalRay, IFace prim, final IPrimProps faceProps, Ray3d ray, final Function<Point3d, Vector3d> getViewVector) {
        final Point3d p = ray.p2();
        LineSegRTreeTest test = new LineSegRTreeTest(ray.origin, p);
        final Point3d[] primIsect = new Point3d[]{null};
        thunderheadeng.geometry.objs.IIsectCollector result = new thunderheadeng.geometry.objs.IIsectCollector(){

            @Override
            public TaskProgress getProgress() {
                return progress;
            }

            @Override
            public void addNonFace(Object obj, Point3d p2, GeomType type) {
                assert (false);
            }

            @Override
            public void addInfinite(Object obj, Point3d p2, GeomType type, IPrimitive prim) {
                assert (false);
            }

            @Override
            public void addFace(Object obj, Point3d ip, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal) {
                Vector3d viewDir;
                Vector3d normal;
                if (ip.distance(p) <= 1.0E-6) {
                    return;
                }
                if (faceProps.testOptions(2) && (normal = getNormal.get()).dot(viewDir = (Vector3d)getViewVector.apply(ip)) >= 0.0) {
                    return;
                }
                primIsect[0] = p;
                throw new HaltException();
            }
        };
        try {
            prim.pickPoints(result, new DefaultFilter(GeomType.FACE), null, ray.origin, p, ray.dir, test);
        }
        catch (HaltException haltException) {
            // empty catch block
        }
        return primIsect[0] == null ? Double.NaN : primIsect[0].distanceSquared(p);
    }

    private /* synthetic */ void lambda$new$295() {
        double telapsed = this.d_timer.curr();
        System.out.printf("pick time = %.1f ms%n", telapsed * 1000.0);
    }

    private /* synthetic */ void lambda$new$293() {
        this.d_timer.reset();
    }

    private static class IsectSorter<T>
    implements Comparator<IsectInfo> {
        private static final int[] s_snapTypePriorities = new int[GeomType.values().length];
        private static final int[] s_selTypePriorities;
        private final IPickSession d_geometry;
        private final int[] d_searchPriorities;

        public IsectSorter(Mode searchMode, IPickSession geom) {
            this.d_searchPriorities = searchMode == Mode.SNAP ? s_snapTypePriorities : s_selTypePriorities;
            this.d_geometry = geom;
        }

        @Override
        public int compare(IsectInfo o1, IsectInfo o2) {
            int prior2;
            int prior1 = this.d_searchPriorities[o1.searchType.ordinal()];
            if (prior1 == (prior2 = this.d_searchPriorities[o2.searchType.ordinal()])) {
                int proxCompare = o1.prox.compareTo(o2.prox);
                if (proxCompare == 0) {
                    return o1.obj == o2.obj ? 0 : this.d_geometry.compare(o1.obj, o2.obj);
                }
                return proxCompare;
            }
            return prior1 - prior2;
        }

        static {
            IsectSorter.s_snapTypePriorities[GeomType.VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.FACE_VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.EDGE_VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.EDGE.ordinal()] = 1;
            IsectSorter.s_snapTypePriorities[GeomType.FACE_EDGE.ordinal()] = 1;
            IsectSorter.s_snapTypePriorities[GeomType.FACE.ordinal()] = 2;
            s_selTypePriorities = new int[GeomType.values().length];
            IsectSorter.s_selTypePriorities[GeomType.VERTEX.ordinal()] = 0;
            IsectSorter.s_selTypePriorities[GeomType.EDGE.ordinal()] = 1;
            IsectSorter.s_selTypePriorities[GeomType.EDGE_VERTEX.ordinal()] = 2;
            IsectSorter.s_selTypePriorities[GeomType.FACE.ordinal()] = 3;
            IsectSorter.s_selTypePriorities[GeomType.FACE_EDGE.ordinal()] = 4;
            IsectSorter.s_selTypePriorities[GeomType.FACE_VERTEX.ordinal()] = 4;
        }
    }

    private static class RayTolProxDetector
    implements IRayProxDetector {
        private final ConvexHull d_infTolFrustum;
        private final ConvexHull d_tolFrustum;
        private final Point3d d_rayOriginWorld;
        private final Point2d d_rayOriginSc;
        private final double d_tolScrSq;
        private final Matrix4d d_wsXform;

        public RayTolProxDetector(View v, Point3d rayOriginWorld, Point2d viewScrPos, double tolScreen, ConvexHull test) {
            this.d_rayOriginWorld = rayOriginWorld;
            this.d_infTolFrustum = v.toInfiniteFrustum(viewScrPos, tolScreen);
            this.d_tolFrustum = test;
            this.d_rayOriginSc = viewScrPos;
            this.d_tolScrSq = tolScreen * tolScreen;
            this.d_wsXform = v.getTransform(3, 0);
        }

        @Override
        public RayPointProx getProximity(Point3d p, GeomType gtype, boolean infinite) {
            RayPointProx prox = this.testTolerance(p, gtype);
            if (prox == null) {
                return null;
            }
            if (infinite && this.d_infTolFrustum.contains(p, 1.0E-6) || !infinite && this.d_tolFrustum.contains(p, 1.0E-6)) {
                return prox;
            }
            return null;
        }

        private RayPointProx testTolerance(Point3d p, GeomType gtype) {
            double proximitySq;
            if (gtype == GeomType.FACE) {
                proximitySq = 0.0;
            } else {
                Point3d isectScreen = Util3D.xform(this.d_wsXform, p, true);
                double dx = isectScreen.x - this.d_rayOriginSc.x;
                double dy = isectScreen.y - this.d_rayOriginSc.y;
                proximitySq = dx * dx + dy * dy;
            }
            if (proximitySq > this.d_tolScrSq) {
                return null;
            }
            double zDist = this.d_rayOriginWorld.distance(p);
            if (Double.isNaN(zDist) || Double.isNaN(proximitySq)) {
                assert (false);
                return null;
            }
            return new RayPointProx(zDist, Math.sqrt(proximitySq));
        }
    }

    private static class RayProxDetector
    implements IRayProxDetector {
        private final Point3d d_rayOriginWorld;
        private final Ray3d d_ray;

        public RayProxDetector(Point3d rayOriginWorld, Ray3d ray) {
            this.d_rayOriginWorld = rayOriginWorld;
            this.d_ray = ray;
        }

        @Override
        public RayPointProx getProximity(Point3d p, GeomType gtype, boolean infinite) {
            double dist = this.d_ray.distance(p);
            if (theUtil.lt0(dist, 1.0E-9) || theUtil.gt(dist, this.d_ray.length, 1.0E-9) || this.d_ray.get(dist).distance(p) > 1.0E-9) {
                return null;
            }
            if (this.d_rayOriginWorld != this.d_ray.origin) {
                dist = Inter3D.nearestTOnLine(this.d_rayOriginWorld, this.d_ray.dir, p);
            }
            if (Double.isNaN(dist)) {
                assert (false);
                return null;
            }
            return new RayPointProx(dist, 0.0);
        }
    }

    public static class IsectCollector
    implements IIsectCollector {
        private final TaskProgress d_progress;
        private final IPickSession d_pickRoot;
        private final View d_view;
        private final IPickConfig d_config;
        private final IIsectFilter d_searchFilter;
        private final List<IsectInfo> d_points;
        private final IRayProxDetector d_proxDet;
        private final Function<Point3d, Vector3d> d_getViewVector;
        private static final IPrimProps.GenericProps DEF_PROPS = new IPrimProps.GenericProps(Color.BLACK, null, 1.0, -1, 1.0, 0);

        public IsectCollector(TaskProgress progress, View view, IPickSession pickRoot, IIsectFilter filter, IRayProxDetector proximityDetector, IPickConfig config) {
            this.d_view = view;
            this.d_pickRoot = pickRoot;
            this.d_searchFilter = filter;
            this.d_progress = progress;
            this.d_proxDet = proximityDetector;
            this.d_points = new ArrayList<IsectInfo>();
            this.d_config = config;
            this.d_getViewVector = this.d_view.getCamera().getViewVectorFunction();
        }

        @Override
        public TaskProgress getProgress() {
            return this.d_progress;
        }

        public List<IsectInfo> getIsects() {
            return this.d_points;
        }

        @Deprecated
        public final void add(Object obj, Point3d p, GeomType type) {
        }

        @Override
        public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
            this.add(obj, p, type, prim != null ? () -> prim : null, DEF_PROPS, true);
        }

        @Override
        public void addNonFace(Object obj, Point3d p, GeomType type) {
            this.add(obj, p, type, null, DEF_PROPS, false);
        }

        @Override
        public void addFace(Object obj, Point3d p, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal, IPrimProps faceProps) {
            if (faceProps.testOptions(2)) {
                Vector3d fnorm = getNormal.get();
                Vector3d viewDir = this.d_getViewVector.apply(p);
                if (viewDir.dot(fnorm) >= 0.0) {
                    return;
                }
            }
            this.add(obj, p, GeomType.FACE, getPrim, faceProps, false);
        }

        private void add(Object obj, Point3d p, GeomType type, Supplier<? extends IPrimitive> getPrim, IPrimProps props, boolean infinite) {
            this.d_progress.check();
            RayPointProx prox = this.d_proxDet.getProximity(p, type, infinite);
            if (prox != null) {
                IsectInfo si;
                if ((type == GeomType.FACE_EDGE || type == GeomType.FACE_VERTEX) && this.d_pickRoot.isWireframe(this.d_config, obj)) {
                    type = type == GeomType.FACE_EDGE ? GeomType.EDGE : GeomType.EDGE_VERTEX;
                }
                if (this.d_searchFilter.acceptIntersection(si = new IsectInfo(type, obj, p, getPrim, props, prox))) {
                    this.d_points.add(si);
                }
            }
        }
    }

    public static class BoxCollector
    implements IBoxCollector {
        private final BoxSearchResult d_result;
        private final Function<Point3d, Vector3d> d_getViewDir;

        public BoxCollector(View view, BoxSearchResult result) {
            this.d_result = result;
            this.d_getViewDir = view.getCamera().getViewVectorFunction();
        }

        @Override
        public void addNonFace(Object obj) throws CancelledException {
            this.addObj(obj);
        }

        @Override
        public void addFace(Object obj, Supplier<Pair<Point3d, Vector3d>> getPointAndNormal, IPrimProps faceProps) throws CancelledException {
            this.addObj(obj);
        }

        private void addObj(Object obj) throws CancelledException {
            this.d_result.d_objs.add(obj);
            throw new CancelledException();
        }
    }

    private static class RaySearchResult
    implements IResult<IPickable> {
        private final IPickSession d_session;
        private final TaskProgress d_progress;
        private final ITest<AABox> d_tester;
        private final Ray3d d_ray;
        private final IsectCollector d_isectCollector;
        private final Point3d d_p2;

        public RaySearchResult(TaskProgress progress, View view, IPickSession root, Mode searchMode, IIsectFilter searchFilter, Ray3d ray, IRayProxDetector proxDet, IPickConfig config) {
            this(progress, view, root, searchMode, searchFilter, ray, new LineSegRTreeTest(ray.p1(), ray.p2()), proxDet, config);
        }

        public RaySearchResult(TaskProgress progress, View view, IPickSession root, Mode searchMode, IIsectFilter searchFilter, Ray3d ray, ITest<AABox> tester, IRayProxDetector proxDet, IPickConfig config) {
            this.d_session = root;
            this.d_progress = progress;
            this.d_tester = tester;
            this.d_ray = ray;
            this.d_p2 = this.d_ray.p2();
            this.d_isectCollector = new IsectCollector(progress, view, this.d_session, searchFilter, proxDet, config);
        }

        public IsectCollector getResult() {
            return this.d_isectCollector;
        }

        public List<IsectInfo> getIsects() {
            return this.d_isectCollector.getIsects();
        }

        @Override
        public void mark(IPickable pickObj, Containment ctmt) {
            this.d_progress.check();
            this.d_session.pickPoints(pickObj, this.d_isectCollector, this.d_isectCollector.d_searchFilter, this.d_ray.origin, this.d_p2, this.d_ray.dir, this.d_tester);
        }
    }

    private static interface IRayProxDetector {
        public RayPointProx getProximity(Point3d var1, GeomType var2, boolean var3);
    }

    private static class BoxSearchResult
    implements IResult<IPickable> {
        public final List<Object> d_objs;
        private final ConvexHull d_tester;
        private final IIsectFilter d_searchFilter;
        private final IPickSession d_display;
        private final BoxCollector d_result;

        public BoxSearchResult(View view, IIsectFilter searchFilter, ConvexHull tester, IPickSession display) {
            this.d_tester = tester;
            this.d_objs = new ArrayList<Object>();
            this.d_searchFilter = searchFilter;
            this.d_display = display;
            this.d_result = new BoxCollector(view, this);
        }

        @Override
        public void mark(IPickable obj, Containment ctmt) {
            switch (ctmt) {
                case INSIDE: {
                    obj.getAll(this.d_objs::add, this.d_searchFilter);
                    break;
                }
                default: {
                    this.d_display.pickBox(obj, this.d_result, this.d_searchFilter, this.d_tester);
                }
            }
        }
    }

    private static class OccludedPointIsectFilter
    extends DefaultFilter {
        private final IPickSession d_pickRoot;
        private final Point3d d_searchPoint;
        private final boolean d_findClosest;
        public IsectInfo occluder = null;

        public OccludedPointIsectFilter(IPickSession pickRoot, Point3d searchPoint, boolean findClosest) {
            super(GeomType.FACE);
            this.d_pickRoot = pickRoot;
            this.d_searchPoint = searchPoint;
            this.d_findClosest = findClosest;
        }

        @Override
        public boolean acceptPickObject(Object obj) {
            return this.d_pickRoot.isOcclusionSource(obj);
        }

        @Override
        public boolean acceptIntersection(IsectInfo info) {
            double dist = info.isectPoint.distance(this.d_searchPoint);
            if (dist > 1.0E-6) {
                if (this.occluder == null || dist > this.occluder.isectPoint.distance(this.d_searchPoint)) {
                    this.occluder = info;
                }
                if (!this.d_findClosest) {
                    throw new HaltException();
                }
            }
            return false;
        }
    }

    private static class HaltException
    extends RuntimeException {
        private HaltException() {
        }
    }

    private class OcclusionFilter
    implements Predicate<IsectInfo> {
        private final TaskProgress d_progress;
        private final IPickSession d_session;
        private final Ray3d d_originalRay;
        private IsectInfo d_firstFaceIsect = null;
        private Map<Point3d, Boolean> d_occludedCache = new HashMap<Point3d, Boolean>();
        private List<IsectInfo> d_foundOccluders = new ArrayList<IsectInfo>();
        private final Matrix4d d_wsXform;
        private final Matrix4d d_swXform;
        private final Function<Point3d, Vector3d> d_getViewVector;

        public OcclusionFilter(IPickSession session, TaskProgress progress, Ray3d originalRay) {
            this.d_session = session;
            this.d_progress = progress;
            this.d_wsXform = GeomPicker.this.d_view.getTransform(3, 0);
            this.d_swXform = GeomPicker.this.d_view.getTransform(0, 3);
            this.d_originalRay = originalRay;
            this.d_getViewVector = GeomPicker.this.d_view.getCamera().getViewVectorFunction();
        }

        @Override
        public boolean test(IsectInfo o) {
            if (!this.d_progress.isRunning()) {
                return false;
            }
            if (!this.d_session.isOcclusionTarget(o.obj)) {
                return true;
            }
            Boolean occluded = this.d_occludedCache.get(o.isectPoint);
            if (occluded == null) {
                Ray3d ray;
                if (o.prox.getRDist() == 0.0) {
                    ray = new Ray3d(this.d_originalRay.origin, this.d_originalRay.dir, this.d_originalRay.distance(o.isectPoint));
                } else {
                    Point3d screen = Util3D.xform(this.d_wsXform, o.isectPoint, true);
                    screen.z = 0.0;
                    Point3d nearP = Util3D.xform(this.d_swXform, screen, true);
                    ray = new Ray3d(nearP, o.isectPoint);
                }
                try {
                    for (IsectInfo occluder : this.d_foundOccluders) {
                        double distSq = GeomPicker.this.findOccluderDistSq(this.d_progress, this.d_originalRay, (IFace)occluder.getPrim.get(), occluder.props, ray, this.d_getViewVector);
                        if (Double.isNaN(distSq)) continue;
                        occluded = true;
                        break;
                    }
                    if (occluded == null) {
                        IsectInfo occluder = GeomPicker.this.findOccluder(this.d_progress, ray, false);
                        if (occluder != null && occluder.getPrim != null) {
                            this.d_foundOccluders.add(occluder);
                        }
                        occluded = occluder != null;
                    }
                    this.d_occludedCache.put(o.isectPoint, occluded);
                }
                catch (HaltException e) {
                    occluded = true;
                }
            }
            return occluded == false;
        }
    }

    private static class VisibilityFilter
    implements IIsectFilter {
        private final IPickSession d_display;
        private final IIsectFilter d_baseFilter;
        private final IPickConfig d_config;

        public VisibilityFilter(IIsectFilter baseFilter, IPickSession geom, IPickConfig config) {
            this.d_display = geom;
            this.d_baseFilter = baseFilter;
            this.d_config = config;
        }

        @Override
        public boolean acceptIntersection(IsectInfo info) {
            return this.d_baseFilter.acceptIntersection(info);
        }

        @Override
        public boolean acceptGeomType(Object source, GeomType type) {
            if (source != null && type == GeomType.FACE && this.d_display.isWireframe(this.d_config, source)) {
                return false;
            }
            return this.d_baseFilter.acceptGeomType(source, type);
        }

        @Override
        public boolean acceptPickObjType(Class type) {
            return this.d_baseFilter.acceptPickObjType(type);
        }

        @Override
        public boolean acceptPickObject(Object obj) {
            return this.d_baseFilter.acceptPickObject(obj) && this.d_display.isVisible(this.d_config, obj);
        }
    }

    private static class CHTest
    implements ITest<AABox> {
        public final ConvexHull ch;
        public final double tol;

        public CHTest(ConvexHull ch) {
            this(ch, 1.0E-9);
        }

        public CHTest(ConvexHull ch, double tol) {
            this.ch = ch;
            this.tol = tol;
        }

        @Override
        public Containment test(AABox bounds) {
            return this.ch.test(bounds, this.tol);
        }
    }

    public static enum Mode {
        SNAP,
        PICK;

    }
}

