/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.gui.IOffset;
import thunderheadeng.scene3d.gui.ValueEditorUtil;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CompositeFunc;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.ConstraintUtil;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class ManipFunc
extends AToolFunction<CursorTool>
implements ValueEditor.IListener {
    private final IToolController d_controller;
    private final ManipMgr d_manipMgr;
    private final GeomPicker d_picker;
    private final double d_pickTol;
    private final IUnitSrc d_lenUnit;
    private static final Logger LOGGER = Logger.getLogger(ManipFunc.class.getName());
    private ValueEditor d_valueEditor;
    private CursorTool t_tool;

    public ManipFunc(IToolController controller, ManipMgr manipMgr, GeomPicker picker, double pickTol, IUnitSrc lenUnit) {
        this.d_controller = controller;
        this.d_manipMgr = manipMgr;
        this.d_picker = picker;
        this.d_pickTol = pickTol;
        this.d_lenUnit = lenUnit;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public void activate(CursorTool tool) {
        this.t_tool = tool;
        this.getValueEditor(tool).attach();
    }

    @Override
    public void deactivate(CursorTool tool) {
        this.getValueEditor(tool).detach();
        this.t_tool = null;
    }

    protected ValueEditor getValueEditor(CursorTool tool) {
        if (this.d_valueEditor != null) {
            return this.d_valueEditor;
        }
        this.d_valueEditor = new ValueEditor(tool.getAttachedComponent());
        this.d_valueEditor.addListener(this);
        ValueEditorUtil.configure(this.d_valueEditor, this.d_lenUnit, "OFFSET");
        return this.d_valueEditor;
    }

    @Override
    public Cursor getCursor(CursorTool tool) {
        return null;
    }

    @Override
    public boolean showDragGuides(CursorTool tool) {
        return false;
    }

    @Override
    public boolean isDrawable(CursorTool tool) {
        return !(tool.getFunction() instanceof CompositeFunc);
    }

    public Point3d getAngledSnapBasis(CursorTool tool) {
        return this.d_manipMgr.isManipulating() ? this.d_manipMgr.getManipBegin() : null;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool tool) {
        if (this.d_manipMgr.isManipulating()) {
            Pair<SnapMode, IIsectFilter> manipFilter = this.d_manipMgr.getSelectedHandle().getPickFilter();
            if (manipFilter == null) {
                manipFilter = new Pair<SnapMode, Object>(SnapMode.ANY, null);
            }
            return manipFilter;
        }
        return super.getSnapInfo(tool);
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
        if (e.getButton() == 1) {
            IsectInfo snap;
            if (!this.d_manipMgr.isManipulating() && this.d_manipMgr.canManipulate() && (snap = this.findHighlightHandle(tool)) != null && this.d_manipMgr.getSelectedHandle() != null) {
                this.d_manipMgr.begin(snap.isectPoint);
                tool.repaintSurface();
            }
        } else if (e.getButton() == 3) {
            this.endManip(tool, false);
        }
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
        if (e.getButton() == 1 && this.d_manipMgr.isManipulating() && this.d_manipMgr.isModified()) {
            this.endManip(tool, true);
        }
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
        this.modify(tool, e);
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
        this.modify(tool, e);
    }

    protected IsectInfo findHighlightHandle(final CursorTool tool) {
        IsectInfo snap = null;
        if (this.d_manipMgr.canManipulate()) {
            DefaultFilter filter = new DefaultFilter(IHandle.class);
            Collection<IsectInfo> isects = this.d_picker.pick(new TaskProgress(), GeomPicker.Mode.PICK, tool.getP1().referenceSnapSc, this.d_pickTol, filter);
            PlanarConstraint viewConstraint = tool.getView().getCamera() instanceof OrthoCamera ? new PlanarConstraint(tool.getView().getCamera().getViewPlane()) : null;
            ArrayList<IsectInfo> handleIsects = new ArrayList<IsectInfo>();
            for (IsectInfo isect : isects) {
                Point3d p = isect.isectPoint;
                if (!handleIsects.isEmpty() && (!((IsectInfo)handleIsects.get((int)0)).isectPoint.epsilonEquals((Tuple3d)p, 1.0E-9) || ((IsectInfo)handleIsects.get((int)0)).searchType != isect.searchType)) break;
                ISnapConstraint constraint = ((IHandle)isect.obj).getConstraint(isect.isectPoint);
                if (ConstraintUtil.conflict(viewConstraint, constraint)) continue;
                handleIsects.add(isect);
            }
            Collections.sort(handleIsects, new Comparator<IsectInfo>(){

                @Override
                public int compare(IsectInfo o1, IsectInfo o2) {
                    int rank2;
                    IHandle dh1 = (IHandle)o1.obj;
                    ISnapConstraint sc1 = dh1.getConstraint(o1.isectPoint);
                    IHandle dh2 = (IHandle)o2.obj;
                    ISnapConstraint sc2 = dh2.getConstraint(o2.isectPoint);
                    int rank1 = this.rank(sc1);
                    if (rank1 != (rank2 = this.rank(sc2))) {
                        return rank1 - rank2;
                    }
                    if (sc1 instanceof LineConstraint && sc2 instanceof LineConstraint) {
                        LineConstraint lc1 = (LineConstraint)sc1;
                        LineConstraint lc2 = (LineConstraint)sc2;
                        Vector3d viewVec = Util3D.normalize(tool.getView().getCamera().getViewVector());
                        double adot1 = Math.abs(lc1.dir.dot(viewVec));
                        double adot2 = Math.abs(lc2.dir.dot(viewVec));
                        return Double.compare(adot1, adot2);
                    }
                    return 0;
                }

                private int rank(ISnapConstraint sc1) {
                    if (sc1 instanceof LineConstraint) {
                        return 0;
                    }
                    if (sc1 instanceof PlanarConstraint) {
                        return 1;
                    }
                    return 2;
                }
            });
            if (!handleIsects.isEmpty()) {
                snap = (IsectInfo)handleIsects.get(0);
            }
        }
        IHandle dhandle = snap != null ? (IHandle)snap.obj : null;
        this.d_manipMgr.setSelectedHandle(dhandle);
        return snap;
    }

    @Override
    public ISnapConstraint getSnapConstraint(CursorTool tool) {
        if (this.d_manipMgr.isManipulating()) {
            Vector3d viewVec;
            ISnapConstraint constraint = this.d_manipMgr.getManipConstraint();
            if (constraint instanceof PlanarConstraint && tool.getView().getCamera() instanceof OrthoCamera && Util3D.testPerpendicular(viewVec = Util3D.normalize(tool.getView().getCamera().getViewVector()), ((PlanarConstraint)constraint).plane.getNormal(), 1.0E-9)) {
                PlanarConstraint constraint2 = new PlanarConstraint(new Plane3d(viewVec, this.d_manipMgr.getManipBegin()));
                try {
                    constraint = ConstraintUtil.intersect(constraint, (ISnapConstraint)constraint2);
                }
                catch (ConstraintUtil.NoIntersectionException noIntersectionException) {
                    // empty catch block
                }
            }
            if (constraint == null && tool.getView().getCamera() instanceof OrthoCamera && (this.d_manipMgr.getSelectedHandle().getPickFilter() == null || !((SnapMode)((Object)this.d_manipMgr.getSelectedHandle().getPickFilter().v1)).requiresFilter)) {
                viewVec = Util3D.normalize(tool.getView().getCamera().getViewVector());
                constraint = new PlanarConstraint(new Plane3d(viewVec, this.d_manipMgr.getManipBegin()));
            }
            return constraint;
        }
        return null;
    }

    @Override
    public ISnapConstraint getDefaultConstraint(CursorTool tool) {
        if (this.d_manipMgr.isManipulating()) {
            return tool.suggestPlanarContraint(this.d_manipMgr.getManipBegin());
        }
        return null;
    }

    protected void modify(CursorTool tool, MouseEvent e) {
        if (this.d_manipMgr.isManipulating()) {
            try {
                CursorTool.SnapInfo si = tool.getP1();
                if (si.constrained.isEmpty()) {
                    throw new ManipException();
                }
                Point3d newLoc = si.constrained.getLast();
                this.d_manipMgr.modify(newLoc);
                this.updateManip(tool);
            }
            catch (ManipException si) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            tool.repaintSurface();
        } else {
            this.findHighlightHandle(tool);
        }
    }

    @Override
    public void valueEditorChanged(ValueEditor editor, boolean commit) {
        Point3d begin = this.d_manipMgr.getManipBegin();
        Unit lu = this.d_controller.getLengthUnits()[0];
        IOffset offset = ValueEditorUtil.getOffset(editor);
        Point3d newLoc = null;
        if (offset instanceof IOffset.Distance) {
            Point3d curr = this.d_manipMgr.getManipLast();
            if (begin != null && curr != null) {
                Vector3d dir = Util3D.vector(begin, curr);
                if (dir.lengthSquared() > 0.0) {
                    dir.normalize();
                }
                IOffset.Distance dist = (IOffset.Distance)offset;
                dir.scale(dist.dist.getValue(lu));
                newLoc = Util3D.add(begin, (Tuple3d)dir);
            } else {
                LOGGER.warning("Handle manipulation had null values for mouse movement");
            }
        } else if (offset instanceof IOffset.DirOffset) {
            IOffset.DirOffset doff = (IOffset.DirOffset)offset;
            newLoc = doff.relative ? Util3D.add(begin, (Tuple3d)doff.offset.getPoint3dValue(lu)) : doff.offset.getPoint3dValue(lu);
        }
        if (newLoc == null) {
            return;
        }
        if (this.d_manipMgr.getManipConstraint() != null && (newLoc = this.d_manipMgr.getManipConstraint().snapPoint(newLoc)) == null) {
            return;
        }
        if (theUtil.eq0(begin.distance(newLoc), 1.0E-9)) {
            return;
        }
        try {
            this.d_manipMgr.modify(newLoc);
        }
        catch (ManipException doff) {
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        if (commit) {
            this.endManip(this.t_tool, true);
        }
        editor.getAttachedComponent().repaint();
    }

    @Override
    public void cancel(CursorTool tool) {
        this.endManip(tool, false);
    }

    private void endManip(CursorTool tool, boolean commit) {
        if (this.d_manipMgr.isManipulating()) {
            this.d_manipMgr.end(commit);
            this.d_manipMgr.setSelectedHandle(null);
            ValueEditor editor = this.getValueEditor(tool);
            editor.clear();
            editor.getAttachedComponent().repaint();
        }
        if (this.t_tool != null) {
            this.t_tool.reset();
        }
    }

    public ManipMgr getManipMgr() {
        return this.d_manipMgr;
    }

    public boolean isManipulating() {
        return this.d_manipMgr.isManipulating();
    }

    @Override
    public String getStatusMessage(CursorTool tool) {
        if (this.d_manipMgr.isManipulating()) {
            return this.getManipMsg(tool);
        }
        Point3d p = tool.getP1().constrained.isEmpty() ? tool.getP1().referenceSnap : tool.getP1().constrained.getLast();
        return tool.toString(p);
    }

    protected String getManipMsg(CursorTool tool) {
        return this.getValueEditor(tool).getStatusMessage();
    }

    protected void updateManip(CursorTool tool) {
        ValueEditor ve = this.getValueEditor(tool);
        Point3d begin = this.d_manipMgr.getManipBegin();
        Point3d end = this.d_manipMgr.getManipLast();
        Unit lu = tool.getModelView().getLengthUnits()[0];
        ValueEditorUtil.setOffset(ve, new IOffset.Distance(new UnitDouble(begin.distance(end), lu)), false);
        ValueEditorUtil.setOffset(ve, new IOffset.DirOffset(new UnitPoint3D(end, lu), false), false);
        Point3d rel = Util3D.sub(end, (Tuple3d)begin);
        ValueEditorUtil.setOffset(ve, new IOffset.DirOffset(new UnitPoint3D(rel, lu), true), false);
    }
}

