/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.vecmath.Point2d;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public interface IToolFunction<T extends CursorTool> {
    public Cursor getCursor(T var1);

    public void activate(T var1);

    public void deactivate(T var1);

    public void cancel(T var1);

    public boolean isDrawable(T var1);

    public boolean showDragGuides(T var1);

    public boolean enableZoomAboutPoint(T var1);

    public boolean isAltMenuAccessEnabled();

    public Pair<SnapMode, IIsectFilter> getSnapInfo(T var1);

    public ISnapConstraint getSnapConstraint(T var1);

    public ISnapConstraint getDefaultConstraint(T var1);

    public void keyPressed(T var1, KeyEvent var2);

    public void keyReleased(T var1, KeyEvent var2);

    public void mouseEntered(T var1, MouseEvent var2);

    public void mouseExited(T var1, MouseEvent var2);

    public void mousePressed(T var1, MouseEvent var2);

    public void mouseReleased(T var1, MouseEvent var2);

    public void mouseDragged(T var1, MouseEvent var2);

    public void mouseMoved(T var1, MouseEvent var2);

    public boolean animate(T var1, IAnimSession var2);

    default public void mouseWheelMoved(T tool, MouseWheelEvent e) {
        double zoomFactor = (double)e.getWheelRotation() * 100.0 / (double)((CursorTool)tool).getView().getSurface().getWidth();
        zoomFactor = 1.0 / Math.pow(2.0, zoomFactor);
        if (((CursorTool)tool).enableZoomAboutPoint()) {
            Point2d screenLoc = ((CursorTool)tool).getView().windowScreenToViewScreen(e.getPoint());
            ((CursorTool)tool).getView().zoomAboutPoint(zoomFactor, screenLoc);
        } else {
            ((CursorTool)tool).getView().zoom(zoomFactor);
        }
        ((CursorTool)tool).repaintSurface();
    }

    public String getStatusMessage(T var1);
}

