/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.gui.colorscheme.ColorMgr;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.IToolListener;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolAdapter;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.INativelyMirrored;
import thunderheadeng.io.nativexfer.NativelyMirroredHelper;
import thunderheadeng.scene3d.SceneColors;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.GenericActor;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CompositeIsectFilter;
import thunderheadeng.scene3d.picking.ConstraintUtil;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.FilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class CursorTool
extends ToolAdapter
implements Tool,
IRenderable,
INativelyMirrored,
IAnimator {
    public static final int TOLMODE_X_OR_Y = 0;
    public static final int TOLMODE_X_AND_Y = 1;
    public static final double PIXEL_TOL = 2.0;
    public static final double SNAP_PIXEL_TOL = 10.0;
    private static final int CURSOR_SIZE = 4;
    public static final int CANCEL_KEY = 27;
    public static final int FINISH_KEY = 10;
    public static final int DISABLE_SNAP_KEY = 18;
    public static final int MODIFIER_KEY = 17;
    public static final int CONSTRAIN_KEY = 16;
    private static final Cursor INVIS_CURSOR = guiUtil.createTeciCursor("Blank", "blank16.gif", 0, 0);
    private IToolFunction d_toolFunc;
    private Pair<SnapMode, IIsectFilter> d_snapInfo;
    private ISnapConstraint d_setConstraint;
    private Pair<Future<SnapResult>, PointSnapper> d_snapTask;
    private SnapInfo d_p0;
    private SnapInfo d_p1;
    private ISnapConstraint d_lockedConstraint;
    private boolean d_mouseIn;
    private boolean d_active = false;
    private boolean d_cancelOnRightClick = true;
    private Set<Integer> d_pressedKeys = new HashSet<Integer>(4);
    private Set<Integer> d_pressedBtns = new HashSet<Integer>(3);
    private final IToolController d_controller;
    private final List<IToolListener> d_toolListeners = new ArrayList<IToolListener>();
    private View d_view;
    private Cursor d_toolCursor;
    private boolean d_pointerVisible = true;
    private boolean d_guidesVisible = true;
    private static NumberFormat d_numFormat = NumberFormat.getNumberInstance();
    private final AltDisabler d_altDisabler = new AltDisabler();
    private boolean d_consumeEvents;
    private final GenericActor d_snapDisplay3d;
    private final List<GenericActor> d_constraintDisplays;
    private NativelyMirroredHelper d_nativeHelper = new NativelyMirroredHelper(this);
    private final char d_separator;

    protected boolean showDragGuides() {
        return this.d_toolFunc != null ? this.d_toolFunc.showDragGuides(this) : false;
    }

    protected boolean enableZoomAboutPoint() {
        return this.d_toolFunc != null ? this.d_toolFunc.enableZoomAboutPoint(this) : true;
    }

    public CursorTool(IToolController mv) {
        this(mv, null);
    }

    public CursorTool(IToolController mv, IToolFunction toolFunc) {
        this(mv, toolFunc, false);
    }

    public CursorTool(IToolController mv, IToolFunction toolFunc, boolean delayInit) {
        this.d_nativeHelper.createPeer();
        this.d_controller = mv;
        this.d_toolFunc = toolFunc;
        this.d_snapDisplay3d = new GenericActor();
        this.d_constraintDisplays = new ArrayList<GenericActor>();
        this.d_snapInfo = null;
        this.d_p0 = this.d_p1 = new SnapInfo();
        this.d_consumeEvents = false;
        this.d_toolCursor = null;
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        char localeSep = symbols.getDecimalSeparator();
        this.d_separator = (char)(localeSep != ',' ? 44 : 59);
        this.updateMouseProps();
        this.updateStatusMessage(" ");
        if (!delayInit) {
            this.init();
        }
    }

    protected void init() {
        this.nativeConstructed(CursorTool.class);
    }

    @Override
    public boolean update(IAnimSession session) {
        if (this.getFunction() != null) {
            return this.getFunction().animate(this, session);
        }
        return true;
    }

    public void beginAnimation() {
        IAnimSession session = this.d_controller.getAnimSession();
        if (session != null) {
            session.addAnimator(this);
            session.wakeUp();
        }
    }

    public void endAnimation() {
        IAnimSession session = this.d_controller.getAnimSession();
        if (session != null) {
            session.removeAnimator(this);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addToolListener(IToolListener listener) {
        this.d_toolListeners.add(listener);
    }

    @Override
    public void removeToolListener(IToolListener listener) {
        this.d_toolListeners.remove(listener);
    }

    private void notifyFinished(boolean cancelled) {
        ArrayList<IToolListener> toNotify = new ArrayList<IToolListener>(this.d_toolListeners);
        for (IToolListener listener : toNotify) {
            listener.toolEnded(this, cancelled);
        }
    }

    public IToolFunction getFunction() {
        return this.d_toolFunc;
    }

    public void setConsumeEvents(boolean consume) {
        this.d_consumeEvents = consume;
    }

    public void updateMouseProps() {
        Cursor desiredCursor = this.getCursor();
        if (desiredCursor != null || this.d_pointerVisible) {
            this.setToolCursor(desiredCursor);
        } else {
            this.setToolCursor(INVIS_CURSOR);
        }
    }

    protected Cursor getCursor() {
        return this.d_toolFunc != null ? this.d_toolFunc.getCursor(this) : this.d_toolCursor;
    }

    protected boolean repaintDuringMove(MouseEvent evt) {
        return this.isDrawable();
    }

    protected boolean repaintDuringDrag(MouseEvent evt) {
        return this.isDrawable();
    }

    public void setPointerVisible(boolean visible) {
        this.d_pointerVisible = visible;
        this.updateMouseProps();
    }

    public boolean isPointerVisible() {
        return this.d_pointerVisible;
    }

    public void setGuidesVisible(boolean visible) {
        this.d_guidesVisible = visible;
        this.markNativeDirty();
    }

    public boolean areGuidesVisible() {
        return this.d_guidesVisible;
    }

    public void setView(View view) {
        this.d_view = view;
    }

    public View getView() {
        return this.d_view;
    }

    public Component getAttachedComponent() {
        return this.d_controller.getRenderComp();
    }

    public ColorMgr getColors() {
        return this.d_controller.getColors();
    }

    protected void setToolCursor(Cursor toolCursor) {
        this.d_toolCursor = toolCursor;
    }

    protected Cursor getToolCursor() {
        return this.d_toolCursor;
    }

    public void setCancelOnRightClick(boolean cancel) {
        this.d_cancelOnRightClick = cancel;
    }

    public boolean getCancelOnRightClick() {
        return this.d_cancelOnRightClick;
    }

    protected boolean isPointVisible(Point3d p) {
        if (this.getAttachedComponent() instanceof RenderComponent) {
            RenderComponent rc = (RenderComponent)this.getAttachedComponent();
            Point3d screenLoc = this.getView().worldToScreen(p);
            float zExisting = rc.getZValue((int)screenLoc.x, (int)screenLoc.y);
            return Math.abs(screenLoc.z - (double)zExisting) < 1.0E-4 || screenLoc.z < (double)zExisting;
        }
        return true;
    }

    protected void getPickRay(Point3d worldPickPoint, Point3d p, Vector3d dir) {
        Camera cam = this.getView().getCamera();
        p.set((Tuple3d)this.getView().worldToScreen(worldPickPoint));
        p.z = 0.0;
        p.set((Tuple3d)this.getView().screenToWorld(p));
        dir.set((Tuple3d)cam.getViewVector(worldPickPoint));
        dir.normalize();
    }

    public Ray getPickRay(Point3d worldPickPoint) {
        Ray ray = new Ray();
        this.getPickRay(worldPickPoint, ray.begin, ray.dir);
        return ray;
    }

    public Ray getPickRay() {
        return this.getPickRay(this.getP1().referenceSnap);
    }

    public String toString(double val) {
        Unit[] lengthUnits = this.d_controller.getLengthUnits();
        double valu = UnitDouble.convert(val, lengthUnits[0], lengthUnits[1]);
        return d_numFormat.format(valu) + " " + lengthUnits[1];
    }

    public String toString(Point3d p) {
        return this.pointToString(p, "(", this.d_separator + " ", ")");
    }

    public String pointToString(Point3d p, String openBracket, String seperator, String closeBracket) {
        Unit[] lengthUnits = this.d_controller.getLengthUnits();
        Unit lengthUnit = lengthUnits[1];
        double x = UnitDouble.convert(p.x, lengthUnits[0], lengthUnit);
        double y = UnitDouble.convert(p.y, lengthUnits[0], lengthUnit);
        double z = UnitDouble.convert(p.z, lengthUnits[0], lengthUnit);
        return openBracket + this.format(x) + seperator + this.format(y) + seperator + this.format(z) + closeBracket + " " + lengthUnit;
    }

    public String format(double val) {
        return d_numFormat.format(val);
    }

    public Set<Integer> getPressedButtons() {
        return this.d_pressedBtns;
    }

    protected static boolean testBit(int mask, int bit) {
        return (mask & bit) == bit;
    }

    protected void updatePressedModifiers(InputEvent e) {
        int[][] keys;
        int[][] mouseButtons;
        int mask = e.getModifiersEx();
        for (int[] button : mouseButtons = new int[][]{{1024, 1}, {2048, 2}, {4096, 3}}) {
            if (CursorTool.testBit(mask, button[0])) {
                this.d_pressedBtns.add(button[1]);
                continue;
            }
            this.d_pressedBtns.remove(button[1]);
        }
        for (int[] key : keys = new int[][]{{512, 18}, {64, 16}, {128, 17}, {256, 157}}) {
            if (CursorTool.testBit(mask, key[0])) {
                this.d_pressedKeys.add(key[1]);
                continue;
            }
            this.d_pressedKeys.remove(key[1]);
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        this.cancelSnapTask();
        this.pauseRepaint();
        this.updatePressedModifiers(e);
        this.setSnap(this.d_p1, true);
        if (this.d_toolFunc != null) {
            this.d_toolFunc.mousePressed(this, e);
        }
        this.resumeRepaint();
    }

    public boolean isActive() {
        return this.d_active;
    }

    protected Point getComponentMousePos(MouseEvent e) {
        Point mloc;
        if (!this.getAttachedComponent().isShowing()) {
            return null;
        }
        Point compCoords = this.getAttachedComponent().getLocationOnScreen();
        Dimension compSize = this.getAttachedComponent().getSize();
        if (e != null) {
            mloc = e.getPoint();
        } else {
            mloc = MouseInfo.getPointerInfo().getLocation();
            mloc = new Point(mloc.x - compCoords.x, mloc.y - compCoords.y);
        }
        if (mloc.x >= 0 && mloc.y >= 0 && mloc.x < compSize.width && mloc.y < compSize.height) {
            return mloc;
        }
        return null;
    }

    public IDeviceManager getDevices() {
        return this.d_controller.getDevices();
    }

    @Override
    public void activate() {
        this.pauseRepaint();
        this.showToolCursor();
        this.checkMouseIn();
        this.d_active = true;
        if (this.d_toolFunc != null) {
            this.d_toolFunc.activate(this);
        }
        this.d_altDisabler.activate();
        this.resumeRepaint();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CursorTool.this.getAttachedComponent().requestFocusInWindow();
            }
        });
    }

    protected boolean checkMouseIn() {
        Point mousePos = this.getComponentMousePos(null);
        if (mousePos != null) {
            MouseEvent evt = new MouseEvent(this.getAttachedComponent(), 0, 0L, 0, mousePos.x, mousePos.y, 0, false);
            this.mouseEntered(evt);
            this.mouseMoved(evt);
            return true;
        }
        return false;
    }

    @Override
    public void deactivate() {
        this.pauseRepaint();
        this.d_altDisabler.deactivate();
        this.restoreSystemCursor();
        Point mousePos = this.getAttachedComponent().getMousePosition();
        if (mousePos != null) {
            MouseEvent evt = new MouseEvent(this.getAttachedComponent(), 0, 0L, 0, mousePos.x, mousePos.y, 0, false);
            this.mouseExited(evt);
        }
        this.d_active = false;
        if (this.d_toolFunc != null) {
            this.d_toolFunc.deactivate(this);
        }
        this.reset();
        this.resumeRepaint();
    }

    @Override
    public void cancel() {
        if (this.d_toolFunc != null) {
            this.d_toolFunc.cancel(this);
        }
        this.notifyFinished(true);
    }

    public void finish() {
        this.notifyFinished(false);
    }

    public void pauseRepaint() {
        this.d_view.getSurface().pauseRender();
    }

    public void resumeRepaint() {
        this.d_view.getSurface().resumeRender();
    }

    public void resumeRepaint(boolean repaint) {
        this.d_view.getSurface().resumeRender(repaint);
    }

    @Override
    public void repaintSurface() {
        if (this.d_view != null) {
            this.getView().getSurface().render();
        }
    }

    public void reset() {
        this.cancelSnapTask();
        this.d_p0 = this.d_p1 = new SnapInfo(this.d_p1.timestamp, this.d_p1.referenceSnapSc, this.d_p1.referenceSnap, (Collection<IsectInfo>)Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        this.updateDisplay3d(this.d_p1);
        this.d_lockedConstraint = null;
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        this.cancelSnapTask();
        this.pauseRepaint();
        this.updateStatusMessage();
        this.updatePressedModifiers(e);
        if (this.isDrawable()) {
            this.repaintSurface();
        }
        if (this.d_toolFunc != null) {
            this.d_toolFunc.mouseReleased(this, e);
        }
        if (e.getButton() == 3 && this.getCancelOnRightClick() && !this.isDragging()) {
            this.cancel();
        }
        this.markNativeDirty();
        this.resumeRepaint();
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public final void mouseDragged(final MouseEvent e) {
        this.d_mouseIn = true;
        this.updateMovement(e, new Runnable(){

            @Override
            public void run() {
                if (CursorTool.this.d_toolFunc != null) {
                    CursorTool.this.d_toolFunc.mouseDragged(CursorTool.this, e);
                }
            }
        });
    }

    protected void updateLockedConstraint() {
        if (this.d_pressedKeys.contains(16)) {
            if (this.d_lockedConstraint == null) {
                this.d_lockedConstraint = this.getFirstConstraint(this.d_p1);
            }
        } else {
            this.d_lockedConstraint = null;
        }
    }

    protected boolean wasDragged(int tolMode) {
        return this.aboveTolerance(tolMode);
    }

    @Override
    public final void mouseMoved(final MouseEvent e) {
        this.d_mouseIn = true;
        this.updateMovement(e, new Runnable(){

            @Override
            public void run() {
                if (CursorTool.this.d_toolFunc != null) {
                    CursorTool.this.d_toolFunc.mouseMoved(CursorTool.this, e);
                }
            }
        });
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent e) {
        this.updatePressedModifiers(e);
        if (this.d_toolFunc != null) {
            this.d_toolFunc.mouseWheelMoved(this, e);
        }
    }

    protected void cancelSnapTask() {
        if (this.d_snapTask != null) {
            ((PointSnapper)this.d_snapTask.v2).cancel();
            this.d_snapTask = null;
        }
    }

    private void updateMovement(MouseEvent e, Runnable moveFunc) {
        this.pauseRepaint();
        this.updateLockedConstraint();
        this.cancelSnapTask();
        Point2d viewPoint = this.getView().windowScreenToViewScreen(e.getPoint());
        PointSnapper task = new PointSnapper(this, viewPoint);
        try {
            SnapResult result = task.call();
            this.setSnap(this.snapConstraint(viewPoint, result), false);
            moveFunc.run();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        catch (OutOfMemoryError ex) {
            ex.printStackTrace();
        }
        this.resumeRepaint();
    }

    private Runnable getCompleteTask(final Point2d viewPoint, final Future<SnapResult> snapTask, final Runnable moveTask) {
        Runnable completeFunc = new Runnable(){

            @Override
            public void run() {
                SnapResult result;
                try {
                    result = (SnapResult)snapTask.get();
                }
                catch (ExecutionException e) {
                    if (!(e.getCause() instanceof CancellationException)) {
                        e.printStackTrace();
                    }
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return;
                }
                Runnable eventFunc = new Runnable(){

                    @Override
                    public void run() {
                        if (CursorTool.this.d_snapTask != null && snapTask == ((CursorTool)CursorTool.this).d_snapTask.v1) {
                            CursorTool.this.d_snapTask = null;
                            CursorTool.this.pauseRepaint();
                            CursorTool.this.setSnap(CursorTool.this.snapConstraint(viewPoint, result), false);
                            moveTask.run();
                            CursorTool.this.resumeRepaint();
                        }
                    }
                };
                EventQueue.invokeLater(eventFunc);
            }
        };
        return completeFunc;
    }

    private void setSnap(SnapInfo snap, boolean p0) {
        if (p0) {
            this.d_p0 = snap;
        }
        this.d_p1 = snap;
        this.updateDisplay3d(this.d_p1);
        this.markNativeDirty();
        if (this.isDrawable()) {
            this.repaintSurface();
        }
        this.updateStatusMessage();
    }

    public void updateStatusMessage() {
        if (this.d_controller.getStatusMessage() != null) {
            this.d_controller.getStatusMessage().setMessage(this.getStatusMessage());
        }
    }

    protected void updateStatusMessage(String message) {
        if (this.d_controller.getStatusMessage() != null) {
            this.d_controller.getStatusMessage().setMessage(message);
        }
    }

    protected String getStatusMessage() {
        String msg = this.d_toolFunc != null ? this.d_toolFunc.getStatusMessage(this) : null;
        return msg == null ? "" : msg;
    }

    @Override
    public final void mouseEntered(final MouseEvent e) {
        this.d_mouseIn = true;
        this.updateMovement(e, new Runnable(){

            @Override
            public void run() {
                if (CursorTool.this.d_toolFunc != null) {
                    CursorTool.this.d_toolFunc.mouseEntered(CursorTool.this, e);
                }
            }
        });
        this.showToolCursor();
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.cancelSnapTask();
        boolean wasDrawable = this.isDrawable();
        this.pauseRepaint();
        this.d_mouseIn = false;
        this.updatePressedModifiers(e);
        if (this.d_toolFunc != null) {
            this.d_toolFunc.mouseExited(this, e);
        }
        this.updateStatusMessage(" ");
        this.showToolCursor();
        this.markNativeDirty();
        if (wasDrawable) {
            this.repaintSurface();
        }
        this.resumeRepaint();
    }

    public boolean dragAboveTolerance(int mode) {
        return this.d_p1.timestamp - this.d_p0.timestamp > 200L && this.aboveTolerance(mode);
    }

    public boolean aboveTolerance(int mode) {
        return CursorTool.aboveTolerance(mode, this.getP0().referenceSnapSc, this.getP1().referenceSnapSc);
    }

    public static boolean aboveTolerance(int mode, Point2d p1s, Point2d p2s) {
        double delX = Math.abs(p1s.x - p2s.x);
        double delY = Math.abs(p1s.y - p2s.y);
        if (mode == 1) {
            return delX >= 2.0 && delY >= 2.0;
        }
        if (mode == 0) {
            return delX >= 2.0 || delY >= 2.0;
        }
        return true;
    }

    public IToolController getModelView() {
        return this.d_controller;
    }

    public double getTolWorld() {
        return this.d_view.screenToWorld(10.0);
    }

    public boolean isDragging(int button) {
        return this.d_pressedBtns.contains(button);
    }

    public boolean isDragging() {
        return !this.d_pressedBtns.isEmpty();
    }

    public boolean isKeyPressed(int key) {
        return this.d_pressedKeys.contains(key);
    }

    public Set<Integer> getPressedKeys() {
        return this.d_pressedKeys;
    }

    protected boolean consumeKeyEvent(KeyEvent e) {
        return this.d_consumeEvents;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.pauseRepaint();
        if (this.consumeKeyEvent(e)) {
            e.consume();
        }
        switch (e.getKeyCode()) {
            case 27: {
                this.cancel();
            }
        }
        this.updatePressedModifiers(e);
        this.d_pressedKeys.add(e.getKeyCode());
        this.updateStatusMessage();
        if (this.d_toolFunc != null) {
            this.d_toolFunc.keyPressed(this, e);
        }
        this.resumeRepaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.consumeKeyEvent(e)) {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.pauseRepaint();
        if (this.consumeKeyEvent(e)) {
            e.consume();
        }
        this.updatePressedModifiers(e);
        this.d_pressedKeys.remove(e.getKeyCode());
        this.updateStatusMessage();
        if (this.d_toolFunc != null) {
            this.d_toolFunc.keyReleased(this, e);
        }
        this.resumeRepaint();
    }

    public boolean isMouseIn() {
        return this.d_mouseIn;
    }

    public void showToolCursor() {
        this.getAttachedComponent().setCursor(this.d_toolCursor);
    }

    protected void restoreSystemCursor() {
        this.getAttachedComponent().setCursor(null);
    }

    protected boolean isDrawable() {
        return !(!this.isDragging() && !this.d_mouseIn || this.d_toolFunc != null && !this.d_toolFunc.isDrawable(this));
    }

    private void write(INativeStream writer, Point2d p) {
        writer.writeDoubles(p.x, p.y);
    }

    private void write(INativeStream writer, Point3d p) {
        writer.writeDoubles(p.x, p.y, p.z);
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        writer.writeBoolean(this.isDrawable());
        SnapInfo p0 = this.getP0();
        this.write(writer, p0.referenceSnapSc);
        if (this.d_snapTask != null) {
            this.write(writer, ((PointSnapper)this.d_snapTask.v2).d_viewScr);
            writer.writeBoolean(false);
        } else {
            SnapInfo p1 = this.getP1();
            this.write(writer, p1.referenceSnapSc);
            writer.writeBoolean(p1.isSnapped());
        }
        float[] guidesColor = this.getColors().getColor(SceneColors.TOOL_GUIDES_COLOR).getComponents(new float[4]);
        writer.writeFloats(guidesColor);
        float[] toolColor = this.getColors().getColor(SceneColors.TOOL_COLOR).getComponents(new float[4]);
        writer.writeFloats(toolColor);
        float[] snapColor = this.getColors().getColor(SceneColors.SNAP_POINT_COLOR).getComponents(new float[4]);
        writer.writeFloats(snapColor);
        writer.writeBooleans(this.areGuidesVisible(), this.showDragGuides(), this.isDragging());
    }

    @Override
    public Class resolveNativeClass() {
        return CursorTool.class;
    }

    @Override
    public void markNativeClean() {
        this.d_nativeHelper.markNativeClean();
    }

    @Override
    public void markNativeDirty() {
        this.d_nativeHelper.markNativeDirty();
    }

    @Override
    public void nativeConstructed(Class clazz) {
        this.d_nativeHelper.nativeConstructed(clazz);
    }

    @Override
    public Integer getKey() {
        return this.d_nativeHelper.getKey();
    }

    public Point2d toScreen(Point3d p) {
        Point3d sc = this.getView() != null ? this.getView().worldToScreen(p) : new Point3d();
        return new Point2d(sc.x, sc.y);
    }

    public SnapInfo getP0() {
        return this.d_p0;
    }

    public SnapInfo getP1() {
        return this.d_p1;
    }

    @Deprecated
    protected final void snapP0(MouseEvent e) {
    }

    @Deprecated
    protected final void snapP1(MouseEvent e) {
    }

    protected void isect(Point3d origin, Vector3d dir, Plane3d plane, List<Double> isects) {
        double t = Inter3D.linePlaneIntersectionT(origin, dir, plane, 1.0E-9);
        if (Double.isNaN(t)) {
            return;
        }
        isects.add(t);
    }

    protected Point3d[] clipInfLine(Box3d frustum, Point3d origin, Vector3d dir) {
        int nearFace = 0;
        int farFace = 1;
        int[] sideFaces = new int[]{2, 3, 4, 5};
        ArrayList<Double> isects = new ArrayList<Double>();
        for (int face : sideFaces) {
            Plane3d plane = frustum.getPlanes()[face];
            this.isect(origin, dir, plane, isects);
        }
        if (isects.size() % 2 == 1) {
            this.isect(origin, dir, frustum.getPlanes()[nearFace], isects);
            if (isects.size() % 2 == 1) {
                this.isect(origin, dir, frustum.getPlanes()[farFace], isects);
                if (isects.size() % 2 == 1) {
                    return null;
                }
            }
        }
        ConvexHull ch = new ConvexHull(frustum.getPlanes()[sideFaces[0]], frustum.getPlanes()[sideFaces[1]], frustum.getPlanes()[sideFaces[2]], frustum.getPlanes()[sideFaces[3]]);
        Collections.sort(isects);
        for (int m = 0; m < isects.size() - 1; ++m) {
            Point3d p2;
            Point3d p1;
            Point3d mid;
            double t2;
            double t1 = (Double)isects.get(m);
            if (theUtil.eq(t1, t2 = ((Double)isects.get(m + 1)).doubleValue(), 1.0E-9) || !ch.contains(mid = Util3D.getMidPoint(p1 = Util3D.linePoint(origin, dir, t1), p2 = Util3D.linePoint(origin, dir, t2)), 1.0E-9)) continue;
            return new Point3d[]{p1, p2};
        }
        return null;
    }

    protected ISnapConstraint getFirstConstraint(SnapInfo snap) {
        Iterator<IsectInfo> filteredIt = snap.snaps.iterator();
        if (!filteredIt.hasNext()) {
            return null;
        }
        IsectInfo first = filteredIt.next();
        if (first.obj instanceof ISnapConstraint) {
            return (ISnapConstraint)first.obj;
        }
        Point2d refPt = this.toScreen(first.isectPoint);
        Predicate<IsectInfo> filter = null;
        Collection<IsectInfo> isects = snap.snaps;
        if (isects instanceof FilteredCollection) {
            FilteredCollection fc = (FilteredCollection)isects;
            filter = fc.getFilter();
            isects = fc.getUnfiltered();
        }
        for (IsectInfo unfilteredII : isects) {
            Point2d p2d;
            if (!(unfilteredII.obj instanceof ISnapConstraint) || !(p2d = this.toScreen(unfilteredII.isectPoint)).epsilonEquals((Tuple2d)refPt, 1.0E-9) || filter != null && !filter.test(unfilteredII)) continue;
            return (ISnapConstraint)unfilteredII.obj;
        }
        return null;
    }

    protected void updateDisplay3d(SnapInfo snap) {
        ISnapConstraint[] constraints;
        Color color = this.getColors().getColor(SceneColors.TOOL_GUIDES_COLOR);
        ArrayList<GenericActor> oldConstraintDisps = new ArrayList<GenericActor>(this.d_constraintDisplays);
        this.d_constraintDisplays.clear();
        Box3d frustum = null;
        for (ISnapConstraint constraint : constraints = new ISnapConstraint[]{this.d_lockedConstraint, this.getFirstConstraint(snap)}) {
            if (!(constraint instanceof LineConstraint)) continue;
            if (frustum == null) {
                int width = this.getView().getSurface().getWidth();
                int height = this.getView().getSurface().getHeight();
                frustum = this.getView().toFrustum(new Point2d(0.0, 0.0), new Point2d((double)width, (double)height));
            }
            LineConstraint lc = (LineConstraint)constraint;
            Point3d[] ls = this.clipInfLine(frustum, lc.p, lc.dir);
            if (ls == null) continue;
            GenericActor constraintDisplay = new GenericActor();
            constraintDisplay.setLineStipplePattern(1, (short)-3856);
            double lwidth = constraint == this.d_lockedConstraint ? 2.0 : 1.0;
            constraintDisplay.setLineWidth(lwidth);
            constraintDisplay.setEdgeColor(color);
            constraintDisplay.resetData();
            constraintDisplay.addLine(ls[0], ls[1]);
            constraintDisplay.finalizeData();
            this.d_constraintDisplays.add(constraintDisplay);
        }
        boolean oldEmpty = this.d_snapDisplay3d.isEmpty();
        this.d_snapDisplay3d.setLineStipplePattern(1, (short)-256);
        this.d_snapDisplay3d.setLineWidth(2.0);
        this.d_snapDisplay3d.setEdgeColor(color);
        this.d_snapDisplay3d.setPointSize(5.0);
        this.d_snapDisplay3d.setVertexColor(color);
        this.d_snapDisplay3d.resetData();
        if (snap.isSnapped()) {
            Point3d prevPt = snap.referenceSnap;
            for (Point3d p : snap.constrained) {
                if (p.epsilonEquals((Tuple3d)prevPt, 1.0E-9)) continue;
                this.d_snapDisplay3d.addLine(prevPt, p);
                this.d_snapDisplay3d.addPoint(p);
                prevPt = p;
            }
        }
        this.d_snapDisplay3d.finalizeData();
        ModelScene scene3d = this.d_controller.getToolScenes()[0];
        if (scene3d != null) {
            scene3d.removeObjects(oldConstraintDisps);
            scene3d.addObjects(this.d_constraintDisplays);
            if (!this.d_snapDisplay3d.isEmpty()) {
                scene3d.addObjects(this.d_snapDisplay3d);
            } else {
                scene3d.removeObjects(this.d_snapDisplay3d);
            }
            if (!oldConstraintDisps.isEmpty() || !this.d_constraintDisplays.isEmpty() || oldEmpty != this.d_snapDisplay3d.isEmpty()) {
                this.repaintSurface();
            }
        }
    }

    private SnapInfo snapConstraint(Point2d viewPoint, SnapResult sr) {
        Collection<IsectInfo> snapIsects = sr.snappedInfos;
        List searchIsects = sr.searchedInfos;
        List si = !searchIsects.isEmpty() ? searchIsects : snapIsects;
        Iterator<IsectInfo> it = si.iterator();
        Point3d constrainPt = it.hasNext() ? it.next().isectPoint : null;
        Point3d snapPt = constrainPt == null ? this.getView().screenToWorld(new Point3d(viewPoint.x, viewPoint.y, 0.0)) : constrainPt;
        ArrayList<Point3d> constrained = new ArrayList<Point3d>();
        try {
            List<ISnapConstraint> constraints = Arrays.asList(this.d_lockedConstraint, this.getSnapConstraint());
            for (ISnapConstraint constraint : constraints) {
                Pair<Point3d, Point3d> result;
                Ray ray;
                if (constraint == null) continue;
                if (constrainPt == null) {
                    ray = this.getPickRay(snapPt);
                    result = this.constrain(constraint, ray);
                    snapPt = (Point3d)result.v1;
                    searchIsects = Collections.EMPTY_LIST;
                    constrainPt = (Point3d)result.v2;
                } else if (this.getView().getCamera() instanceof OrthoCamera) {
                    ray = this.getPickRay(constrainPt);
                    result = this.constrain(constraint, ray);
                    constrainPt = (Point3d)result.v2;
                } else {
                    constrainPt = this.constrain(constraint, constrainPt);
                }
                constrained.add(constrainPt);
            }
        }
        catch (ConstraintException exc) {
            return new SnapInfo(System.currentTimeMillis(), this.toScreen(snapPt), snapPt, searchIsects, new Point3d[0]);
        }
        if (constrainPt == null) {
            try {
                ISnapConstraint defConstraint = this.getDefaultConstraint();
                Pair<Point3d, Point3d> result = this.constrain(defConstraint, this.getPickRay(snapPt));
                snapPt = (Point3d)result.v1;
                searchIsects = Collections.EMPTY_LIST;
                constrainPt = (Point3d)result.v2;
            }
            catch (ConstraintException exc) {
                constrainPt = snapPt;
            }
        }
        if (constrained.isEmpty()) {
            constrained.add(constrainPt);
        }
        return new SnapInfo(System.currentTimeMillis(), this.toScreen(snapPt), snapPt, searchIsects, constrained);
    }

    protected Pair<Point3d, Point3d> constrain(ISnapConstraint constraint, Ray pickRay) throws ConstraintException {
        if (constraint == null) {
            return new Pair<Point3d, Point3d>(pickRay.begin, pickRay.begin);
        }
        Pair<Point3d, Point3d> result = constraint.snapRay(pickRay.begin, pickRay.dir);
        if (result == null) {
            throw new ConstraintException();
        }
        return result;
    }

    protected Point3d constrain(ISnapConstraint constraint, Point3d snapLoc) throws ConstraintException {
        if (constraint == null) {
            return snapLoc;
        }
        Point3d result = constraint.snapPoint(snapLoc);
        if (result == null) {
            throw new ConstraintException();
        }
        return result;
    }

    public GeomPicker getSnapper() {
        return this.getModelView().getSnapper();
    }

    private IIsectFilter getConstraintSnapFilter() {
        ISnapConstraint setConstraint = this.getSnapConstraint();
        final ArrayList<ISnapConstraint> constraints = new ArrayList<ISnapConstraint>(2);
        if (setConstraint != null) {
            constraints.add(setConstraint);
        }
        if (this.d_lockedConstraint != null) {
            constraints.add(this.d_lockedConstraint);
        }
        if (!constraints.isEmpty()) {
            return new DefaultFilter(){

                @Override
                public boolean acceptPickObject(Object obj) {
                    if (obj instanceof ISnapConstraint) {
                        for (ISnapConstraint constraint : constraints) {
                            if (!ConstraintUtil.conflict(constraint, (ISnapConstraint)obj)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            };
        }
        return null;
    }

    protected boolean isSnapEnabled() {
        return !this.d_pressedKeys.contains(18);
    }

    protected Pair<SnapMode, IIsectFilter> getSnapInfo() {
        if (!this.isSnapEnabled() || this.getSnapper() == null) {
            return new Pair<SnapMode, Object>(SnapMode.NONE, null);
        }
        if (this.d_snapInfo != null) {
            return this.d_snapInfo;
        }
        if (this.d_toolFunc != null) {
            return this.d_toolFunc.getSnapInfo(this);
        }
        return new Pair<SnapMode, Object>(SnapMode.NONE, null);
    }

    public void setSnapInfo(SnapMode mode, IIsectFilter filter) {
        this.d_snapInfo = new Pair<SnapMode, IIsectFilter>(mode, filter);
    }

    public void setSnapConstraint(ISnapConstraint constraint) {
        this.d_setConstraint = constraint;
    }

    public ISnapConstraint getSnapConstraint() {
        if (this.d_setConstraint != null) {
            return this.d_setConstraint;
        }
        if (this.d_toolFunc != null) {
            return this.d_toolFunc.getSnapConstraint(this);
        }
        return null;
    }

    public ISnapConstraint getDefaultConstraint() {
        ISnapConstraint constraint;
        if (this.d_toolFunc != null && (constraint = this.d_toolFunc.getDefaultConstraint(this)) != null) {
            return constraint;
        }
        Vector3d pnorm = null;
        if (this.getView().getCamera() instanceof OrthoCamera) {
            pnorm = new Vector3d(this.getView().getCamera().getViewVector());
            pnorm.normalize();
            pnorm.negate();
        } else {
            pnorm = new Vector3d(0.0, 0.0, 1.0);
        }
        return new PlanarConstraint(new Plane3d(pnorm, new Point3d(0.0, 0.0, 0.0)));
    }

    public PlanarConstraint suggestPlanarContraint(Point3d p) {
        Vector3d dir;
        if (this.getView().getCamera() instanceof OrthoCamera) {
            dir = Util3D.normalize(this.getView().getCamera().getViewVector());
            dir.negate();
        } else {
            dir = Util3D.normalize(this.getView().getCamera().getViewVector(p));
            dir.negate();
            dir = GeomUtil.getClosestAxis(dir);
        }
        return new PlanarConstraint(new Plane3d(dir, p));
    }

    protected boolean isAltMenuAccessEnabled() {
        if (this.d_toolFunc != null) {
            return this.d_toolFunc.isAltMenuAccessEnabled();
        }
        return true;
    }

    public static class SnapInfo {
        public final long timestamp;
        public final Point3d referenceSnap;
        public final Point2d referenceSnapSc;
        public final Collection<IsectInfo> snaps;
        public final Deque<Point3d> constrained;

        public SnapInfo() {
            this(Long.MAX_VALUE, new Point2d(), new Point3d(), (Collection<IsectInfo>)Collections.EMPTY_LIST, new Point3d());
        }

        public SnapInfo(long timestamp, Point2d referenceSnapSc, Point3d referenceSnap, Collection<IsectInfo> referenceSnaps, Point3d ... constrainedLocs) {
            this(timestamp, referenceSnapSc, referenceSnap, referenceSnaps, Arrays.asList(constrainedLocs));
        }

        public SnapInfo(long timestamp, Point2d referenceSnapSc, Point3d referenceSnap, Collection<IsectInfo> referenceSnaps, Collection<Point3d> constrainedLocs) {
            this.timestamp = timestamp;
            this.constrained = new ArrayDeque<Point3d>(constrainedLocs);
            if (!this.constrained.isEmpty() && this.constrained.getLast().epsilonEquals((Tuple3d)referenceSnap, 1.0E-9)) {
                this.constrained.clear();
                this.constrained.push(referenceSnap);
            }
            this.referenceSnapSc = referenceSnapSc;
            this.referenceSnap = referenceSnap;
            this.snaps = referenceSnaps;
        }

        public boolean isSnapped() {
            return !this.constrained.isEmpty() && (this.constrained.getLast() != this.referenceSnap || !this.snaps.isEmpty());
        }
    }

    private class AltDisabler
    implements FocusListener {
        private final KeyEventDispatcher altDisabler = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 18 && !CursorTool.this.isAltMenuAccessEnabled()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(CursorTool.this.getAttachedComponent(), e);
                    return true;
                }
                return false;
            }
        };

        private AltDisabler() {
        }

        public void activate() {
            CursorTool.this.getAttachedComponent().addFocusListener(this);
            if (CursorTool.this.getAttachedComponent().isFocusOwner()) {
                this.attach();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.attach();
        }

        protected void attach() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.altDisabler);
        }

        public void deactivate() {
            CursorTool.this.getAttachedComponent().removeFocusListener(this);
            this.detach();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.detach();
        }

        public void detach() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.altDisabler);
        }
    }

    private static class PointSnapper
    implements Callable<SnapResult> {
        private final GeomPicker d_snapper;
        private final View d_view;
        private final Point2d d_viewScr;
        private final IIsectFilter d_constraintFilter;
        private final Pair<SnapMode, IIsectFilter> d_snapInfo;
        private final TaskProgress d_progress;

        public PointSnapper(CursorTool tool, Point2d viewScr) {
            this.d_viewScr = viewScr;
            this.d_snapper = tool.getSnapper();
            this.d_view = tool.getView();
            this.d_constraintFilter = tool.getConstraintSnapFilter();
            this.d_snapInfo = tool.getSnapInfo();
            this.d_progress = new TaskProgress();
        }

        public void cancel() {
            this.d_progress.cancel();
        }

        @Override
        public SnapResult call() throws Exception {
            SnapResult sr = new SnapResult();
            IIsectFilter anyFilter = this.d_constraintFilter != null ? this.d_constraintFilter : GeomPicker.ACCEPT_ALL;
            IIsectFilter snapFilter = this.d_constraintFilter != null && this.d_snapInfo.v2 != null ? new CompositeIsectFilter(this.d_constraintFilter, (IIsectFilter)this.d_snapInfo.v2) : (IIsectFilter)this.d_snapInfo.v2;
            switch ((SnapMode)((Object)this.d_snapInfo.v1)) {
                case ANY: {
                    sr.searchedInfos = this.d_snapper.pick(this.d_progress, GeomPicker.Mode.SNAP, this.d_viewScr, 10.0, anyFilter);
                    sr.snappedInfos = sr.searchedInfos;
                    break;
                }
                case FILTERED_ONE_PASS: {
                    assert (this.d_snapInfo.v2 != null);
                    sr.searchedInfos = this.d_snapper.pick(this.d_progress, GeomPicker.Mode.SNAP, this.d_viewScr, 10.0, snapFilter);
                    break;
                }
                case FILTERED_TWO_PASS: {
                    sr.snappedInfos = this.d_snapper.pick(this.d_progress, GeomPicker.Mode.SNAP, this.d_viewScr, 10.0, anyFilter);
                    if (sr.snappedInfos.isEmpty()) break;
                    assert (this.d_snapInfo.v2 != null);
                    IsectInfo s1 = sr.snappedInfos.iterator().next();
                    Point3d viewScr3d = this.d_view.worldToScreen(s1.isectPoint);
                    Point2d newViewScr = new Point2d(viewScr3d.x, viewScr3d.y);
                    sr.searchedInfos = this.d_snapper.pick(this.d_progress, GeomPicker.Mode.SNAP, newViewScr, 0.5, snapFilter);
                }
            }
            return sr;
        }
    }

    protected static class SnapResult {
        public Collection<IsectInfo> snappedInfos = Collections.EMPTY_LIST;
        public Collection<IsectInfo> searchedInfos = Collections.EMPTY_LIST;

        protected SnapResult() {
        }
    }

    protected static class ConstraintException
    extends Exception {
        protected ConstraintException() {
        }
    }

    public static class Ray {
        public final Point3d begin;
        public final Vector3d dir;

        public Ray() {
            this.begin = new Point3d();
            this.dir = new Vector3d();
        }

        public Ray(Point3d begin, Vector3d dir) {
            this.begin = begin;
            this.dir = dir;
        }
    }
}

