/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.IConcreteRenderSurface;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.RenderBuffer;
import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.scene3d.nativebuffered.VirtualRenderSurface;

public class nb3dUtil {
    public static void registerTypes() {
        NativeManager.registerWriter(Color.class, nb3dUtil::writeFloats);
        NativeManager.registerReader(Color.class, nb3dUtil::readColor);
        NativeManager.registerWriter(Matrix4d.class, nb3dUtil::write);
        NativeManager.registerReader(Matrix4d.class, nb3dUtil::readMatrix);
        NativeManager.registerWriter(Tuple2d.class, nb3dUtil::write);
        NativeManager.registerReader(Point2d.class, nb3dUtil::readP2d);
        NativeManager.registerReader(Vector2d.class, nb3dUtil::readV2d);
        NativeManager.registerWriter(Tuple3d.class, nb3dUtil::write);
        NativeManager.registerReader(Point3d.class, nb3dUtil::readP3d);
        NativeManager.registerReader(Vector3d.class, nb3dUtil::readV3d);
        NativeManager.registerWriter(Tuple4d.class, nb3dUtil::write);
        NativeManager.registerReader(Point4d.class, nb3dUtil::readP4d);
        NativeManager.registerReader(Vector4d.class, nb3dUtil::readV4d);
        NativeManager.registerWriter(Viewport.class, nb3dUtil::write);
        NativeManager.registerReader(Viewport.class, nb3dUtil::readViewport);
        NativeManager.registerWriter(Dimension.class, nb3dUtil::write);
        NativeManager.registerReader(Dimension.class, nb3dUtil::readDimension);
        NativeManager.registerWriter(AABox.class, nb3dUtil::write);
        NativeManager.registerReader(AABox.class, nb3dUtil::readAABox);
    }

    public static void write(INativeStream writer, Dimension d) {
        writer.writeInt(d.width);
        writer.writeInt(d.height);
    }

    public static Dimension readDimension(INativeStream reader) {
        return new Dimension(reader.readInt(), reader.readInt());
    }

    public static void write(INativeStream writer, AABox b) {
        writer.writeDouble(b.getMinX());
        writer.writeDouble(b.getMinY());
        writer.writeDouble(b.getMinZ());
        writer.writeDouble(b.getMaxX());
        writer.writeDouble(b.getMaxY());
        writer.writeDouble(b.getMaxZ());
    }

    public static AABox readAABox(INativeStream reader) {
        return new AABox(reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble());
    }

    public static void write(INativeStream writer, Viewport vp) {
        writer.writeInt(vp.x());
        writer.writeInt(vp.y());
        writer.writeInt(vp.w());
        writer.writeInt(vp.h());
    }

    public static Viewport readViewport(INativeStream reader) {
        return new Viewport(reader.readInt(), reader.readInt(), reader.readInt(), reader.readInt());
    }

    public static void write(INativeStream writer, Matrix4d mat) {
        writer.writeDoubles(mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33);
    }

    public static Matrix4d readMatrix(INativeStream reader) {
        return new Matrix4d(reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble());
    }

    public static Color readColor(INativeStream reader) {
        return new Color(reader.readFloat(), reader.readFloat(), reader.readFloat(), reader.readFloat());
    }

    public static void writeFloats(INativeStream writer, Color color) {
        nb3dUtil.writeFloats(writer, color, new float[4]);
    }

    public static void writeFloats(INativeStream writer, Color color, float[] tempArr) {
        color.getComponents(tempArr);
        writer.writeFloats(tempArr);
    }

    public static void write(INativeStream writer, Tuple2d p) {
        writer.writeDouble(p.x);
        writer.writeDouble(p.y);
    }

    public static Point2d readP2d(INativeStream reader) {
        return new Point2d(reader.readDouble(), reader.readDouble());
    }

    public static Vector2d readV2d(INativeStream reader) {
        return new Vector2d(reader.readDouble(), reader.readDouble());
    }

    public static void write(INativeStream writer, Tuple3d p) {
        writer.writeDouble(p.x);
        writer.writeDouble(p.y);
        writer.writeDouble(p.z);
    }

    public static Point3d readP3d(INativeStream reader) {
        return new Point3d(reader.readDouble(), reader.readDouble(), reader.readDouble());
    }

    public static Vector3d readV3d(INativeStream reader) {
        return new Vector3d(reader.readDouble(), reader.readDouble(), reader.readDouble());
    }

    public static void write(INativeStream writer, Tuple4d p) {
        writer.writeDouble(p.x);
        writer.writeDouble(p.y);
        writer.writeDouble(p.z);
        writer.writeDouble(p.w);
    }

    public static Point4d readP4d(INativeStream reader) {
        return new Point4d(reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble());
    }

    public static Vector4d readV4d(INativeStream reader) {
        return new Vector4d(reader.readDouble(), reader.readDouble(), reader.readDouble(), reader.readDouble());
    }

    public static boolean takeScreenshot(String filename, int width, int height, Color fillColor, IConcreteRenderSurface renderSurface, List<? extends RenderPanel> layouts, List<Rectangle> layoutBounds) throws IOException {
        if (layouts.size() != layoutBounds.size()) {
            return false;
        }
        int extix = filename.lastIndexOf(46);
        if (extix == -1) {
            return false;
        }
        String ext = filename.substring(extix + 1);
        Rectangle bounds = new Rectangle();
        for (int m = 0; m < layouts.size(); ++m) {
            Rectangle rect = layoutBounds.get(m);
            bounds.add(rect);
        }
        int pitch = width * 3;
        int numBytes = pitch * height;
        ByteBuffer buffer = ByteBuffer.allocateDirect(numBytes).order(ByteOrder.nativeOrder());
        if (fillColor != null) {
            for (int m = 0; m < numBytes; m += 3) {
                buffer.put((byte)fillColor.getRed());
                buffer.put((byte)fillColor.getGreen());
                buffer.put((byte)fillColor.getBlue());
            }
            buffer.position(0);
        }
        RenderBuffer rb = new RenderBuffer(renderSurface);
        for (int m = 0; m < layouts.size(); ++m) {
            RenderPanel layout = layouts.get(m);
            Rectangle lbounds = layoutBounds.get(m);
            double newWidth = lbounds.getWidth() / bounds.getWidth() * (double)width;
            double newHeight = lbounds.getHeight() / bounds.getHeight() * (double)height;
            double x = lbounds.getMinX() / bounds.getWidth() * (double)width;
            double y = (bounds.getHeight() - lbounds.getMaxY()) / bounds.getHeight() * (double)height;
            rb.setRootPanel(layout);
            rb.setSize((int)newWidth, (int)newHeight);
            buffer.position((int)y * pitch + (int)x * 3);
            rb.setBuffer(buffer.slice(), pitch);
            rb.render();
        }
        buffer.position(0);
        BufferedImage bi = new BufferedImage(width, height, 5);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int r = buffer.get() & 0xFF;
                int g = buffer.get() & 0xFF;
                int b = buffer.get() & 0xFF;
                int data = 0xFF000000 | r << 16 | g << 8 | b;
                bi.setRGB(col, height - row - 1, data);
            }
        }
        ImageIO.write((RenderedImage)bi, ext, new File(filename));
        return true;
    }

    public static IConcreteRenderSurface findRenderSurface(Collection<? extends IRenderSurface> surfaces) {
        for (IRenderSurface iRenderSurface : surfaces) {
            IConcreteRenderSurface cs;
            if (iRenderSurface instanceof IConcreteRenderSurface) {
                return (IConcreteRenderSurface)iRenderSurface;
            }
            if (!(iRenderSurface instanceof VirtualRenderSurface) || (cs = ((VirtualRenderSurface)iRenderSurface).getBackingSurface()) == null) continue;
            return cs;
        }
        return null;
    }
}

