/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.function.Function;
import javax.vecmath.Matrix4d;
import thunderheadeng.gui.Application;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;

public class TextRenderer
extends Object3D
implements IRenderable {
    public static final int MODE_2D = 0;
    public static final int MODE_3D = 1;
    public static final int RENDERTYPE_PIXMAP = 0;
    public static final int RENDERTYPE_TEXTURE = 1;
    public static final int RENDERTYPE_BITMAP = 2;
    private static final String DEFAULT_FACE_NAME = "Code2003Miao.ttf";

    public static String getDefaultFont() {
        File file = new File(Application.getApp().getResourceFile(DEFAULT_FACE_NAME));
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        URL fonturl = TextRenderer.class.getResource("lib/Code2003Miao.ttf");
        if (fonturl == null) {
            return "lib/Code2003Miao.ttf";
        }
        String rawPath = fonturl.getFile();
        File defaultFont = null;
        try {
            defaultFont = new File(URLDecoder.decode(rawPath, "UTF-8"));
            return defaultFont.getPath();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "lib/Code2003Miao.ttf";
        }
    }

    public TextRenderer() {
        this.setFace(TextRenderer.getDefaultFont());
        this.setFontColor(Color.BLACK);
        this.setFontSize(12.0f);
        this.setPadding(new int[]{0, 0, 0, 0});
        this.setLeaderEnabled(false);
        this.setMode(0);
        this.setRenderType(1);
    }

    protected TextRenderer(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return TextRenderer.class;
    }

    private void exec(Methods method, Object ... args) {
        Native.manager.execMethod(TextRenderer.class, (INativeObject)this, method, args);
    }

    private <T> T exec(Methods method, Class<T> retType, Object ... args) {
        return Native.manager.execGet(TextRenderer.class, (INativeObject)this, method, retType, args);
    }

    private <T> T exec(Methods method, Function<NativeManager, T> get, Object ... args) {
        return Native.manager.exec(TextRenderer.class, (INativeObject)this, (Enum)method, get, args);
    }

    public void setGraphicsContext(IRenderSurface surface) {
        this.exec(Methods.setRenderSurface, surface);
    }

    public void setMode(int mode) {
        this.exec(Methods.setMode, mode);
    }

    public int getMode(int mode) {
        return this.exec(Methods.getMode, ABufferedNativeStream::readInt, new Object[0]);
    }

    public void setRenderType(int type) {
        this.exec(Methods.setRenderType, type);
    }

    public int getRenderType() {
        return this.exec(Methods.getRenderType, ABufferedNativeStream::readInt, new Object[0]);
    }

    public void setTransform(Matrix4d xform) {
        Object[] objectArray;
        if (xform == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = false;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = true;
            objectArray = objectArray3;
            objectArray3[1] = xform;
        }
        Object[] args = objectArray;
        this.exec(Methods.setTransform, args);
    }

    public void setLeaderEnabled(boolean enabled) {
        this.exec(Methods.setLeaderEnabled, enabled);
    }

    public boolean isLeaderEnabled() {
        return this.exec(Methods.isLeaderEnabled, ABufferedNativeStream::readBoolean, new Object[0]);
    }

    public void setFace(String face) {
        this.exec(Methods.setFace, face);
    }

    public void setFontColor(Color c) {
        this.exec(Methods.setFontColor, c);
    }

    public void setFontSize(float size) {
        this.exec(Methods.setFontSize, Float.valueOf(size));
    }

    public void setCamera(Camera c) {
        this.exec(Methods.setCamera, c);
    }

    public void setPadding(int[] padding) {
        this.exec(Methods.setPadding, new Object[]{padding});
    }

    static {
        nb3dUtil.registerTypes();
    }

    private static enum Methods {
        setRenderSurface,
        setCamera,
        setFace,
        setFontColor,
        setFontSize,
        setLeaderEnabled,
        isLeaderEnabled,
        setMode,
        getMode,
        setPadding,
        setRenderType,
        getRenderType,
        setTransform;

    }
}

