/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Dimension;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.IConcreteRenderSurface;
import thunderheadeng.scene3d.nativebuffered.RenderBuffer;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;

public class RenderFile
extends RenderBuffer {
    public RenderFile(IConcreteRenderSurface backingSurface) {
        super(backingSurface);
    }

    protected RenderFile(Integer key, long cptr) {
        super(key, cptr);
    }

    public void setFilename(String filename) {
        Native.manager.execMethod(RenderFile.class, (INativeObject)this, Methods.setFilename, filename == null ? "" : filename);
    }

    public String getFilename() {
        String fn = Native.manager.exec(RenderFile.class, (INativeObject)this, (Enum)Methods.getFilename, ABufferedNativeStream::readString, new Object[0]);
        return fn.isEmpty() ? null : fn;
    }

    @Override
    public Class resolveNativeClass() {
        return RenderFile.class;
    }

    @Override
    public void render(Viewport clippingVP) {
        Native.manager.execMethod(RenderFile.class, (INativeObject)this, Methods.render, clippingVP);
        Native.manager.flush();
    }

    public void writeFile(String filename, Viewport clippingVP) {
        if (clippingVP == null) {
            Dimension size = this.getSize();
            clippingVP = new Viewport(0, 0, size.width, size.height);
        }
        Native.manager.execMethod(RenderFile.class, (INativeObject)this, Methods.writeFile, filename, clippingVP);
        Native.manager.flush();
    }

    public void writeFile(String filename) {
        Dimension size = this.getSize();
        this.writeFile(filename, new Viewport(0, 0, size.width, size.height));
    }

    static {
        nb3dUtil.registerTypes();
    }

    private static enum Methods {
        writeFile,
        render,
        setFilename,
        getFilename;

    }
}

