/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.Serializable;
import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.util.theUtil;

public class PerspectiveCamera
extends Camera {
    private static final double s_maxFOVRad = 2.9845130209103035;
    private static final double s_minFarClip = 10000.0;
    private static final double s_maxNearClip = 0.1;
    private double d_resetFovRad;

    private PerspectiveCamera() {
    }

    public PerspectiveCamera(Point3d pos, Point3d ref, Vector3d up, double near, double far, double fovDeg) {
        super(pos, ref, up, near, far);
        this.d_resetFovRad = Math.toRadians(fovDeg);
        this.setFOV(this.d_resetFovRad);
    }

    protected PerspectiveCamera(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return PerspectiveCamera.class;
    }

    @Override
    public Camera createCopyCam() {
        PerspectiveCamera cam = new PerspectiveCamera();
        cam.setCopyCam(this);
        return cam;
    }

    public void setFOV(double fov) {
        this.d_resetFovRad = fov;
        Native.manager.execMethod(PerspectiveCamera.class, (INativeObject)this, Methods.setFOV, fov);
    }

    public double getFOV() {
        return Native.manager.exec(PerspectiveCamera.class, (INativeObject)this, (Enum)Methods.getFOV, ABufferedNativeStream::readDouble, new Object[0]);
    }

    protected double getMinZoom() {
        return 0.25;
    }

    @Override
    protected Point3d constrainPointToView(Point3d refPoint, Point3d desiredLocation) {
        Point3d refLocV = this.worldToView(refPoint);
        Point3d desiredLocV = this.worldToView(desiredLocation);
        desiredLocV.z = refLocV.z;
        return this.viewToWorld(desiredLocV);
    }

    @Override
    protected double calcScreenZValue(double distFromCamera) {
        double distFromNear = distFromCamera - this.getNearClip();
        double invfmn = 1.0 / (this.getFarClip() - this.getNearClip());
        double a = -(this.getFarClip() + this.getNearClip()) * invfmn;
        double b = -2.0 * this.getNearClip() * this.getFarClip() * invfmn;
        double view = -a - b / -distFromNear;
        return view * 0.5 + 0.5;
    }

    @Override
    public AABox ensureValidForReset(AABox bb, double maxVal) {
        return bb.ensureValidSize(maxVal, 1.0E-6);
    }

    @Override
    public double getSubjectSize() {
        return this.getFOV() * this.getDistance();
    }

    @Override
    protected void reset(Vector3d viewDir, Vector3d upDir, AABox bb, int screenWidth, int screenHeight, boolean resetForRotation) {
        super.reset(viewDir, upDir, bb, screenWidth, screenHeight, resetForRotation);
        assert (Math.abs(viewDir.angle(upDir) - 1.5707963267948966) <= 1.0E-4);
        this.setFOV(this.d_resetFovRad);
        double size = bb.getMin().distance(bb.getMax());
        double halfSize = size * 0.5;
        Point3d center = new Point3d();
        center.add((Tuple3d)bb.getMin(), (Tuple3d)bb.getMax());
        center.scale(0.5);
        double dist = halfSize / Math.sin(this.getFOV() * 0.5);
        Vector3d eyeOffset = new Vector3d(viewDir);
        eyeOffset.normalize();
        eyeOffset.scale(dist);
        Point3d eye = new Point3d();
        eye.sub((Tuple3d)center, (Tuple3d)eyeOffset);
        this.setPosition(eye);
        this.setReference(center);
        this.setUpVector(upDir);
        this.fitClipping(bb);
        this.markDirty();
    }

    @Override
    public Vector3d getViewVector(Point3d reference) {
        Vector3d view = new Vector3d();
        view.sub((Tuple3d)reference, (Tuple3d)this.getPosition());
        return view;
    }

    @Override
    public Function<Point3d, Vector3d> getViewVectorFunction() {
        Point3d pos = this.getPosition();
        return p -> Util3D.vector(pos, p);
    }

    @Override
    public CameraRecord capture() {
        return new CameraRecord(this.getPosition(), this.getReference(), this.getUpVector(), this.getZoom(), this.getZoomLoc(), this.getNearClip(), this.getFarClip(), new FrustumRecord(this.getFOV()));
    }

    @Override
    public void apply(CameraRecord cc) {
        super.apply(cc);
        if (cc.frustum instanceof FrustumRecord) {
            this.setFOV(((FrustumRecord)cc.frustum).fov);
        }
    }

    public static class FrustumRecord
    implements CameraRecord.IFrustumRecord,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final double fov;

        public FrustumRecord(double fov) {
            this.fov = fov;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof FrustumRecord && ((FrustumRecord)obj).fov == this.fov;
        }

        @Override
        public boolean tolEquals(CameraRecord.IFrustumRecord record, double tol) {
            return record == this || record instanceof FrustumRecord && theUtil.eq(this.fov, ((FrustumRecord)record).fov, tol);
        }

        @Override
        public CameraRecord.IFrustumRecord slerp(CameraRecord.IFrustumRecord record, double t) {
            if (!(record instanceof FrustumRecord)) {
                return this;
            }
            FrustumRecord ofr = (FrustumRecord)record;
            return new FrustumRecord(theUtil.lerp(this.fov, ofr.fov, t));
        }
    }

    private static enum Methods {
        setFOV,
        getFOV;

    }
}

