/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.Serializable;
import java.util.function.Function;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.util.theUtil;

public class OrthoCamera
extends Camera {
    private OrthoCamera() {
    }

    public OrthoCamera(Point3d pos, Point3d ref, Vector3d up, double near, double far, double worldHeight) {
        super(pos, ref, up, near, far);
        this.setWorldHeight(worldHeight);
    }

    protected OrthoCamera(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return OrthoCamera.class;
    }

    @Override
    public Camera createCopyCam() {
        OrthoCamera cam = new OrthoCamera();
        cam.setCopyCam(this);
        return cam;
    }

    public void setWorldHeight(double worldHeight) {
        Native.manager.execMethod(OrthoCamera.class, (INativeObject)this, Methods.setHeight, worldHeight);
    }

    public double getWorldHeight() {
        return Native.manager.exec(OrthoCamera.class, (INativeObject)this, (Enum)Methods.getHeight, ABufferedNativeStream::readDouble, new Object[0]);
    }

    @Override
    protected Point3d constrainPointToView(Point3d refPoint, Point3d desiredLocation) {
        Point3d camLoc = this.getPosition();
        Vector3d viewDir = this.getViewVector();
        viewDir.normalize();
        Vector3d camToRef = new Vector3d();
        camToRef.sub((Tuple3d)refPoint, (Tuple3d)camLoc);
        double refDistFromCamPlane = viewDir.dot(camToRef);
        Vector3d camToDesired = new Vector3d();
        camToDesired.sub((Tuple3d)desiredLocation, (Tuple3d)camLoc);
        double desiredDistFromCamPlane = viewDir.dot(camToDesired);
        double moveDist = refDistFromCamPlane - desiredDistFromCamPlane;
        Point3d constrainedLoc = new Point3d((Tuple3d)viewDir);
        constrainedLoc.scale(moveDist);
        constrainedLoc.add((Tuple3d)desiredLocation);
        return constrainedLoc;
    }

    @Override
    protected double calcScreenZValue(double distFromCamera) {
        double invfmn = 1.0 / (this.getFarClip() - this.getNearClip());
        double a = -2.0 * invfmn;
        double b = -(this.getFarClip() - this.getNearClip()) * invfmn;
        double view = a * distFromCamera + b;
        return view * 0.5 + 0.5;
    }

    @Override
    public double getSubjectSize() {
        return this.getWorldHeight();
    }

    @Override
    protected void reset(Vector3d viewDir, Vector3d upDir, AABox bb, int screenWidth, int screenHeight, boolean resetForRotation) {
        double orthoScale;
        super.reset(viewDir, upDir, bb, screenWidth, screenHeight, resetForRotation);
        Point3d bbMin = bb.getMin();
        Point3d bbMax = bb.getMax();
        Point3d bbCenter = Util3D.getMidPoint(bbMin, bbMax);
        Vector3d viewVec = Util3D.normalize(viewDir);
        Vector3d diag = Util3D.vector(bbMin, bbMax);
        if (screenWidth == 0 || screenHeight == 0 || resetForRotation) {
            orthoScale = diag.length() * 1.05;
        } else {
            Point3d[] bbVerts;
            Plane3d viewPlane = new Plane3d(viewVec, bbCenter);
            Matrix4d wlXform = Util.getWorldToLocalXform(viewPlane);
            for (Point3d bbVert : bbVerts = bb.getVerts(false)) {
                wlXform.transform(bbVert);
            }
            AABox localBounds = new AABox(bbVerts);
            Vector3d localDiag = Util3D.vector(localBounds.getMin(), localBounds.getMax());
            double boundsAspect = localDiag.y / localDiag.x;
            double screenAspect = (double)screenHeight / (double)screenWidth;
            orthoScale = boundsAspect >= screenAspect ? localDiag.y : localDiag.x * screenAspect;
            orthoScale *= 1.1;
        }
        double scale = diag.length() * 0.5 * 1.1;
        Point3d camLoc = new Point3d();
        camLoc.scale(scale, (Tuple3d)viewVec);
        camLoc.sub((Tuple3d)bbCenter, (Tuple3d)camLoc);
        this.setWorldHeight(orthoScale);
        this.setPosition(camLoc);
        this.setUpVector(upDir);
        this.setReference(bbCenter);
        this.fitClipping(bb);
        this.markDirty();
    }

    @Override
    public Vector3d getViewVector(Point3d reference) {
        return this.getViewVector();
    }

    @Override
    public Function<Point3d, Vector3d> getViewVectorFunction() {
        Vector3d vvec = this.getViewVector();
        return p -> vvec;
    }

    @Override
    public CameraRecord capture() {
        return new CameraRecord(this.getPosition(), this.getReference(), this.getUpVector(), this.getZoom(), this.getZoomLoc(), this.getNearClip(), this.getFarClip(), new FrustumRecord(this.getWorldHeight()));
    }

    @Override
    public void apply(CameraRecord cc) {
        super.apply(cc);
        if (cc.frustum instanceof FrustumRecord) {
            this.setWorldHeight(((FrustumRecord)cc.frustum).worldHeight);
        }
    }

    public static class FrustumRecord
    implements CameraRecord.IFrustumRecord,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final double worldHeight;

        public FrustumRecord(double worldHeight) {
            this.worldHeight = worldHeight;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof FrustumRecord && ((FrustumRecord)obj).worldHeight == this.worldHeight;
        }

        @Override
        public boolean tolEquals(CameraRecord.IFrustumRecord record, double tol) {
            return record == this || record instanceof FrustumRecord && theUtil.eq(this.worldHeight, ((FrustumRecord)record).worldHeight, tol);
        }

        @Override
        public CameraRecord.IFrustumRecord slerp(CameraRecord.IFrustumRecord record, double t) {
            if (!(record instanceof FrustumRecord)) {
                return this;
            }
            FrustumRecord ofr = (FrustumRecord)record;
            return new FrustumRecord(theUtil.lerp(this.worldHeight, ofr.worldHeight, t));
        }
    }

    private static enum Methods {
        setHeight,
        getHeight;

    }
}

