/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import thunderheadeng.image.IImage;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.streamsrc.DecryptStreamSrc;
import thunderheadeng.io.streamsrc.IFileSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.util.Pair;

public class NativeImage
extends ANativeObject {
    static final long serialVersionUID = 1L;
    private final IImage d_baseImage;
    private static final int method_setFilename = 1;

    protected NativeImage(final IImage baseImage) {
        this.d_baseImage = baseImage;
        Native.manager.flush();
        Native.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                NativeImage.this.setData(baseImage);
            }
        });
        Native.manager.execMethod(NativeImage.class, (INativeObject)this, 1, baseImage.getFilename());
    }

    protected NativeImage(Integer key, long cptr) {
        super(key, cptr);
        this.d_baseImage = null;
    }

    @Override
    public Class resolveNativeClass() {
        return NativeImage.class;
    }

    public IImage getBaseImage() {
        return this.d_baseImage;
    }

    protected void setData(IImage image) {
        IStreamSrc src = image.getSource();
        boolean supportEncrypted = false;
        if (src instanceof DecryptStreamSrc) {
            supportEncrypted = true;
            src = ((DecryptStreamSrc)src).getBaseSource();
        }
        if (src instanceof IFileSrc && ((IFileSrc)src).getFileSystem() instanceof FileSystem) {
            IFileSrc fs = (IFileSrc)src;
            this.associateFilename(this.getKey(), fs.getFilename(), supportEncrypted);
        } else {
            Pair<ByteBuffer, Boolean> result = null;
            try {
                result = IOUtil.loadData(this.d_baseImage.getSource(), 0, true, ByteOrder.nativeOrder());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (result != null) {
                this.associateBuffer(this.getKey(), (ByteBuffer)result.v1, supportEncrypted, (Boolean)result.v2);
            }
        }
    }

    private native void associateBuffer(int var1, ByteBuffer var2, boolean var3, boolean var4);

    private native void associateFilename(int var1, String var2, boolean var3);
}

