/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.vecmath.Matrix4d;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.ISceneObject;
import thunderheadeng.scene3d.nativebuffered.Scene;
import thunderheadeng.scene3d.nativebuffered.SceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Keyable;
import thunderheadeng.util.theUtil;

public class ModelScene
extends Scene {
    private static final int MAX_ARR_SIZE = 10000;

    public ModelScene() {
        this.setDrawProps(new SceneRenderOptions());
    }

    protected ModelScene(Integer key, long cptr) {
        super(key, cptr);
    }

    private void exec(Methods method, Object ... args) {
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, method, args);
    }

    public void setTransform(Matrix4d xform) {
        Object[] objectArray;
        if (xform == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = false;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = true;
            objectArray3[1] = xform;
            objectArray = objectArray3;
            objectArray3[2] = ModelScene.invert(xform);
        }
        Object[] args = objectArray;
        this.exec(Methods.setTransform, args);
    }

    private static Matrix4d invert(Matrix4d xform) {
        Matrix4d inverse = new Matrix4d(xform);
        inverse.invert();
        return inverse;
    }

    public Matrix4d getTransform() {
        return Native.manager.exec(ModelScene.class, (INativeObject)this, (Enum)Methods.getTransform, (NativeManager m) -> {
            if (!m.readBoolean()) {
                return null;
            }
            return nb3dUtil.readMatrix(m);
        }, new Object[0]);
    }

    @Override
    public Class resolveNativeClass() {
        return ModelScene.class;
    }

    public void setDrawProps(SceneRenderOptions pdp) {
        this.exec(Methods.setRenderProps, pdp);
    }

    public SceneRenderOptions getDrawProps() {
        return Native.manager.execGet(ModelScene.class, (INativeObject)this, Methods.getRenderProps, SceneRenderOptions.class, new Object[0]);
    }

    public void forceImmediate(boolean force) {
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.forceImmediate, force);
        Native.manager.flush();
    }

    public void addObjects(IDisplayable ... objs) {
        this.addObjects(Arrays.asList(objs));
    }

    public void addObjects(Collection<? extends IDisplayable> objs) {
        this.addRenderableObjects(theUtil.filter(objs, IRenderable.class));
        this.addSceneObjects(theUtil.filter(objs, ISceneObject.class));
    }

    public void removeObjects(IDisplayable ... objs) {
        this.removeObjects(Arrays.asList(objs));
    }

    public void removeObjects(Collection<? extends IDisplayable> objs) {
        this.removeRenderableObjects(theUtil.filter(objs, IRenderable.class));
        this.removeSceneObjects(theUtil.filter(objs, ISceneObject.class));
    }

    public void addRenderableObjects(IRenderable ... objs) {
        this.addRenderableObjects(Arrays.asList(objs));
    }

    public void addRenderableObjects(Collection<? extends IRenderable> objs) {
        this.execArrayMethod(Methods.addRenderableObjects, objs);
    }

    public void removeRenderableObjects(IRenderable ... objs) {
        this.removeRenderableObjects(Arrays.asList(objs));
    }

    public void removeRenderableObjects(Collection<? extends IRenderable> objs) {
        this.execArrayMethod(Methods.removeRenderableObjects, objs);
    }

    public void addSceneObjects(ISceneObject ... objs) {
        this.addSceneObjects(Arrays.asList(objs));
    }

    public void addSceneObjects(Collection<? extends ISceneObject> objs) {
        this.execArrayMethod(Methods.addSceneObjects, objs);
    }

    public void removeSceneObjects(ISceneObject ... objs) {
        this.removeSceneObjects(Arrays.asList(objs));
    }

    public void removeSceneObjects(Collection<? extends ISceneObject> objs) {
        this.execArrayMethod(Methods.removeSceneObjects, objs);
    }

    public void removeAllObjects() {
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.removeAllObjects, new Object[0]);
    }

    private final void execArrayMethod(Methods method, Collection<? extends Keyable> objs) {
        int numArrs = objs.size() / 10000;
        if (objs.size() % 10000 != 0) {
            ++numArrs;
        }
        Iterator<? extends Keyable> it = objs.iterator();
        int remaining = objs.size();
        Object[] arr = new Object[Math.min(10000, remaining)];
        for (int m = 0; m < numArrs; ++m) {
            int count = Math.min(remaining, 10000);
            if (m == numArrs - 1 && m > 0) {
                arr = new Object[count];
            }
            for (int n = 0; n < count; ++n) {
                arr[n] = it.next();
            }
            remaining -= count;
            Native.manager.execMethod(ModelScene.class, (INativeObject)this, method, count, arr);
        }
    }

    private final Object[] getKeyableArray(Collection<?> objs) {
        IFilteredCollection<Keyable> nativeObjs = theUtil.filter(objs, Keyable.class);
        Object[] nativeObjsA = nativeObjs.toArray((Keyable[])new Keyable[nativeObjs.size()]);
        return nativeObjsA;
    }

    private static Object[] extractCHParams(ConvexHull ch) {
        Object[] params = new Object[1 + ch.getPlanes().length * 4];
        params[0] = ch.getPlanes().length;
        for (int m = 0; m < ch.getPlanes().length; ++m) {
            Plane3d plane = ch.getPlanes()[m];
            int offset = (m << 2) + 1;
            params[offset + 0] = plane.x;
            params[offset + 1] = plane.y;
            params[offset + 2] = plane.z;
            params[offset + 3] = plane.w;
        }
        return params;
    }

    public void addCullBox(ConvexHull hull) {
        Object[] vals = ModelScene.extractCHParams(hull);
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.addCullBox, vals);
    }

    public void removeCullBox(ConvexHull hull) {
        Object[] vals = ModelScene.extractCHParams(hull);
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.removeCullBox, vals);
    }

    public void removeAllCullBoxes() {
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.removeAllCullBoxes, new Object[0]);
    }

    static {
        nb3dUtil.registerTypes();
    }

    private static enum Methods {
        addRenderableObjects,
        removeRenderableObjects,
        addSceneObjects,
        removeSceneObjects,
        removeAllObjects,
        forceImmediate,
        addCullBox,
        removeCullBox,
        removeAllCullBoxes,
        setRenderProps,
        getRenderProps,
        setTransform,
        getTransform;

    }
}

