/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.ARenderComponent;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;

public class GradientBG
extends ARenderComponent {
    public static final int GBORIENT_HORIZONTAL = 0;
    public static final int GBORIENT_VERTICAL = 1;
    public static final int GBLOC_SIDE = 0;
    public static final int GBLOC_MIDDLE = 1;
    private float d_variation;

    public GradientBG(float variation) {
        this(1, 1, variation);
    }

    public GradientBG(int orientation, int stripeLoc, float variation) {
        this(Color.WHITE, Color.WHITE, orientation, stripeLoc);
        this.d_variation = variation;
    }

    public GradientBG(Color c1, Color c2, int orientation, int stripeLoc) {
        this.d_variation = 0.0f;
        this.setColors(c1, c2);
        this.setParams(orientation, stripeLoc);
    }

    protected GradientBG(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return GradientBG.class;
    }

    private static float getBGComp(float color, float variation) {
        return Math.abs(color - variation);
    }

    public static Color getColor2(Color color1, float variation) {
        float[] c = new float[4];
        color1.getComponents(c);
        return new Color(GradientBG.getBGComp(c[0], variation), GradientBG.getBGComp(c[1], variation), GradientBG.getBGComp(c[2], variation), c[3]);
    }

    public void setColor(Color c) {
        this.setColors(c, GradientBG.getColor2(c, this.d_variation));
    }

    public void setColors(Color c1, Color c2) {
        Native.manager.execMethod(GradientBG.class, (INativeObject)this, Methods.setColors, c1, c2);
    }

    public void setParams(int orientation, int stripeLoc) {
        Native.manager.execMethod(GradientBG.class, (INativeObject)this, Methods.setParams, orientation, stripeLoc);
    }

    static {
        nb3dUtil.registerTypes();
    }

    private static enum Methods {
        setColors,
        setParams;

    }
}

