/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.IOException;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.INativelyMirrored;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.GeomWriter;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.ISceneObject;
import thunderheadeng.scene3d.nativebuffered.NativeGeomWriterOutput;

public class GeomDisplay
extends ISceneObject
implements INativelyMirrored {
    private static final int method_setSelected = 0;
    private boolean d_selected = false;
    private INativeDisplayProps d_dispProps;
    private IDisplayableGeomSrc d_source;

    public GeomDisplay(INativeDisplayProps dispProps, IDisplayableGeomSrc source) {
        this.d_dispProps = dispProps;
        this.d_source = source;
        this.nativeConstructed(GeomDisplay.class);
    }

    @Override
    public Class resolveNativeClass() {
        return GeomDisplay.class;
    }

    @Override
    public void markNativeClean() {
    }

    public IDisplayable[] getDisplayObjs() {
        return new IDisplayable[]{this};
    }

    public INativeDisplayProps getDisplayProps() {
        return this.d_dispProps;
    }

    public void setSelected(boolean selected) {
        if (this.d_selected == selected) {
            return;
        }
        this.d_selected = selected;
        Native.manager.execMethod(GeomDisplay.class, (INativeObject)this, 0, selected);
    }

    public boolean isSelected() {
        return this.d_selected;
    }

    public IDisplayableGeomSrc getSource() {
        return this.d_source;
    }

    public void setSource(IDisplayableGeomSrc source) {
        this.d_source = source;
        this.update();
    }

    public void update() {
        this.markNativeDirty();
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        DisplayGeom dg = this.d_source.getDisplayGeom(this.d_dispProps);
        try {
            NativeGeomWriterOutput nwriter = new NativeGeomWriterOutput(writer){

                @Override
                public void writeObject(Object obj) throws IOException {
                    if (obj instanceof IMaterial) {
                        obj = GeomDisplay.this.d_dispProps.getNativeMat((IMaterial)obj);
                    }
                    super.writeObject(obj);
                }
            };
            GeomWriter.write(nwriter, dg.node, dg.props, this.d_dispProps.getCurveError(), this.d_dispProps.getFaceError());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

