/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class CameraRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Point3d loc;
    public final Point3d ref;
    public final Vector3d up;
    public final double zoom;
    public final Point2d zoomLoc;
    public final double near;
    public final double far;
    public final IFrustumRecord frustum;

    public CameraRecord(Point3d loc, Point3d ref, Vector3d up, double zoom, Point2d zoomLoc, double near, double far, IFrustumRecord frustum) {
        this.loc = new Point3d(loc);
        this.ref = new Point3d(ref);
        this.up = new Vector3d(up);
        this.zoom = zoom;
        this.zoomLoc = new Point2d(zoomLoc);
        this.near = near;
        this.far = far;
        this.frustum = frustum;
    }

    public CameraRecord slerp(CameraRecord ct, double t) {
        Point3d newLoc;
        Point3d newRef;
        if (this.ref.epsilonEquals((Tuple3d)ct.ref, 1.0E-9)) {
            Vector3d vec1 = Util3D.vector(this.loc, this.ref);
            Vector3d vec2 = Util3D.vector(ct.loc, ct.ref);
            double dist1 = vec1.length();
            double dist2 = vec2.length();
            newRef = ct.ref;
            Vector3d vect = Util3D.slerp(vec1, vec2, t);
            vect.normalize();
            vect.scale(theUtil.lerp(dist1, dist2, t));
            newLoc = Util3D.sub(newRef, (Tuple3d)vect);
        } else {
            newLoc = Util3D.lerp(this.loc, ct.loc, t);
            newRef = Util3D.lerp(this.ref, ct.ref, t);
        }
        Vector3d newUp = Util3D.slerp(this.up, ct.up, t);
        Vector3d newView = Util3D.vectorN(newLoc, newRef);
        Vector3d right = Util3D.cross(newView, newUp);
        newUp = Util3D.cross(right, newView);
        newUp.normalize();
        return new CameraRecord(newLoc, newRef, newUp, theUtil.lerp(this.zoom, ct.zoom, t), Util2D.lerp(this.zoomLoc, ct.zoomLoc, t), theUtil.lerp(this.near, ct.near, t), theUtil.lerp(this.far, ct.far, t), this.frustum.slerp(ct.frustum, t));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CameraRecord)) {
            return false;
        }
        CameraRecord cc = (CameraRecord)obj;
        return this.zoom == cc.zoom && this.near == cc.near && this.far == cc.far && this.frustum.equals(cc.frustum) && this.zoomLoc.equals((Tuple2d)cc.zoomLoc) && this.loc.equals((Tuple3d)cc.loc) && this.ref.equals((Tuple3d)cc.ref) && this.up.equals((Tuple3d)cc.up);
    }

    public boolean tolEquals(CameraRecord cc, double tol) {
        return theUtil.eq(this.zoom, cc.zoom, tol) && theUtil.eq(this.near, cc.near, tol) && theUtil.eq(this.far, cc.far, tol) && this.frustum.tolEquals(cc.frustum, tol) && this.zoomLoc.epsilonEquals((Tuple2d)cc.zoomLoc, tol) && this.loc.epsilonEquals((Tuple3d)cc.loc, tol) && this.ref.epsilonEquals((Tuple3d)cc.ref, tol) && this.up.epsilonEquals((Tuple3d)cc.up, tol);
    }

    public static interface IFrustumRecord {
        public boolean equals(Object var1);

        public boolean tolEquals(IFrustumRecord var1, double var2);

        public IFrustumRecord slerp(IFrustumRecord var1, double var2);
    }
}

