/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.util.Observer;
import java.util.function.Function;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;
import thunderheadeng.util.ObservableMediator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public abstract class Camera
extends ANativeObject {
    public static final int LOCALAXIS_FORWARD = 0;
    public static final int LOCALAXIS_RIGHT = 1;
    public static final int LOCALAXIS_UP = 2;
    private final ObservableMediator d_observable = new ObservableMediator();
    public static final int MAT_TRANSFORM = 0;
    public static final int MAT_INV_TRANSFORM = 1;
    public static final int MAT_VIEW = 2;
    public static final int MAT_INV_VIEW = 3;
    public static final int MAT_PROJECTION = 4;
    public static final int MAT_INV_PROJECTION = 5;
    public static final int MAT_WORLD_TO_SCREEN = 6;
    public static final int MAT_SCREEN_TO_WORLD = 7;
    public static final int CS_SCREEN = 0;
    public static final int CS_PROJECTION = 1;
    public static final int CS_EYE = 2;
    public static final int CS_WORLD = 3;
    public static final int CS_MODEL = 4;

    protected abstract double calcScreenZValue(double var1);

    protected abstract Point3d constrainPointToView(Point3d var1, Point3d var2);

    public abstract double getSubjectSize();

    public abstract Vector3d getViewVector(Point3d var1);

    public abstract Function<Point3d, Vector3d> getViewVectorFunction();

    private static Position readPosition(INativeStream m) {
        return new Position(nb3dUtil.readP3d(m), nb3dUtil.readP3d(m), nb3dUtil.readV3d(m));
    }

    protected Camera() {
    }

    public Camera(Point3d pos, Point3d ref, Vector3d up, double near, double far) {
        this.setPosition(pos);
        this.setReference(ref);
        this.setUpVector(up);
        this.setClip(near, far);
    }

    protected Camera(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return Camera.class;
    }

    private void exec(Methods method, Object ... args) {
        Native.manager.execMethod(Camera.class, (INativeObject)this, method, args);
    }

    private <T> T exec(Methods method, Class<T> retType, Object ... args) {
        return Native.manager.execGet(Camera.class, (INativeObject)this, method, retType, args);
    }

    private <T> T exec(Methods method, Function<NativeManager, T> get, Object ... args) {
        return Native.manager.exec(Camera.class, (INativeObject)this, (Enum)method, get, args);
    }

    public void setCustomTransform(Matrix4d xform) {
        Object[] objectArray;
        if (xform == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = false;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = true;
            objectArray3[1] = xform;
            objectArray = objectArray3;
            objectArray3[2] = Camera.invert(xform);
        }
        Object[] args = objectArray;
        this.exec(Methods.setCustomTransform, args);
    }

    private static Matrix4d invert(Matrix4d xform) {
        Matrix4d i = new Matrix4d(xform);
        i.invert();
        return i;
    }

    public Matrix4d getCustomTransform() {
        return this.exec(Methods.getCustomTransform, (NativeManager m) -> m.readBoolean() ? nb3dUtil.readMatrix(m) : null, new Object[0]);
    }

    public Matrix4d getInverseCustomTransform() {
        Matrix4d xform = this.getCustomTransform();
        return xform == null ? null : Camera.invert(xform);
    }

    protected AABox toView(AABox bb) {
        Matrix4d xform = this.getCustomTransform();
        if (xform == null) {
            return bb;
        }
        bb = new AABox(bb);
        bb.transformEq(xform);
        return bb;
    }

    protected Vector3d toView(Vector3d v) {
        Matrix4d xform = this.getCustomTransform();
        return xform != null ? Util3D.xform(xform, v) : v;
    }

    protected Point3d toView(Point3d p) {
        Matrix4d xform = this.getCustomTransform();
        return xform != null ? Util3D.xform(xform, p) : p;
    }

    public void setCopyCam(Camera cam) {
        this.exec(Methods.setCopyCam, cam);
    }

    public abstract Camera createCopyCam();

    public void addObserver(Observer ob) {
        this.d_observable.addObserver(ob);
    }

    public void removeObserver(Observer ob) {
        this.d_observable.deleteObserver(ob);
    }

    public void resetRotation() {
        Position p = this.getPositionInfo();
        Point3d originalPos = new Point3d(p.pos);
        p.up.set(0.0, 0.0, 1.0);
        p.ref.set(0.0, 1.0, 0.0);
        p.pos.set(0.0, 0.0, 0.0);
        p.ref.add((Tuple3d)originalPos);
        p.pos.add((Tuple3d)originalPos);
        this.setPositionInfo(p);
    }

    public Position getPositionInfo() {
        return this.exec(Methods.getPositionInfo, Camera::readPosition, new Object[0]);
    }

    public void setPositionInfo(Position pos) {
        this.exec(Methods.setPositionInfo, pos);
        this.markDirty();
    }

    public AABox ensureValidForReset(AABox bb, double maxVal) {
        return bb.ensureValidSize(maxVal, maxVal);
    }

    public void reset(AABox bb, int screenWidth, int screenHeight) {
        this.reset(new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), bb, screenWidth, screenHeight);
    }

    public void reset(Vector3d viewDir, Vector3d upDir, AABox bb, int screenWidth, int screenHeight) {
        this.reset(viewDir, upDir, bb, screenWidth, screenHeight, false);
    }

    public void reset(Vector3d viewDir, Vector3d upDir, AABox bb) {
        this.reset(viewDir, upDir, bb, 0, 0, true);
    }

    protected void reset(Vector3d viewDir, Vector3d upDir, AABox bb, int screenWidth, int screenHeight, boolean resetForRotation) {
        this.setZoom(new Point2d(0.0, 0.0), 1.0);
    }

    public void fillView(AABox bb) {
        this.fillView(bb, 0, 0, true);
    }

    public void fillView(AABox bb, int screenWidth, int screenHeight) {
        this.fillView(bb, screenWidth, screenHeight, false);
    }

    protected void fillView(AABox bb, int screenWidth, int screenHeight, boolean fillForRotation) {
        this.reset(Util3D.normalize(this.getViewVector()), Util3D.normalize(this.getUpVector()), bb, screenWidth, screenHeight, fillForRotation);
    }

    public void orbit(double deg, double ax, double ay, double az) {
        Vector3d localX = new Vector3d();
        Vector3d localY = new Vector3d();
        Vector3d localZ = new Vector3d();
        Position p = this.getPositionInfo();
        localZ.sub((Tuple3d)p.pos, (Tuple3d)p.ref);
        localY.set((Tuple3d)p.up);
        localX.cross(localY, localZ);
        localX.normalize();
        localY.normalize();
        localZ.normalize();
        localX.scale(ax);
        localY.scale(ay);
        localZ.scale(az);
        Vector3d newAxis = new Vector3d(localX);
        newAxis.add((Tuple3d)localY);
        newAxis.add((Tuple3d)localZ);
        double angle = deg * Math.PI / 180.0;
        AxisAngle4d axisAngle = new AxisAngle4d(newAxis, angle);
        Matrix3d rot = new Matrix3d();
        rot.set(axisAngle);
        Vector3d pos = new Vector3d();
        pos.sub((Tuple3d)p.pos, (Tuple3d)p.ref);
        rot.transform((Tuple3d)pos);
        p.pos.add((Tuple3d)p.ref, (Tuple3d)pos);
        rot.transform((Tuple3d)p.up);
        this.setPositionInfo(p);
    }

    public void orbit(double deg, Vector3d axis) {
        this.orbit(deg, axis.x, axis.y, axis.z);
    }

    public void rotate(double deg, Vector3d rotVec) {
        double angle = deg * Math.PI / 180.0;
        AxisAngle4d axisAngle = new AxisAngle4d(rotVec, angle);
        Matrix3d rot = new Matrix3d();
        rot.set(axisAngle);
        Position p = this.getPositionInfo();
        Vector3d view = new Vector3d();
        view.sub((Tuple3d)p.ref, (Tuple3d)p.pos);
        rot.transform((Tuple3d)view);
        p.ref.add((Tuple3d)p.pos, (Tuple3d)view);
        rot.transform((Tuple3d)p.up);
        this.setPositionInfo(p);
    }

    public void rotate(double deg, double ax, double ay, double az) {
        this.rotate(deg, new Vector3d(ax, ay, az));
    }

    public void translateWorld(Vector3d offset, boolean offsetRef) {
        Position p = this.getPositionInfo();
        p.pos.add((Tuple3d)offset);
        if (offsetRef) {
            p.ref.add((Tuple3d)offset);
        }
        this.setPositionInfo(p);
    }

    public void translateWorld(double ox, double oy, double oz, boolean offsetRef) {
        this.translateWorld(new Vector3d(ox, oy, oz), offsetRef);
    }

    public void translateEye(Point3d loc, Vector3d offset) {
        Vector3d localX = new Vector3d();
        Vector3d localY = new Vector3d();
        Vector3d localZ = new Vector3d();
        Position p = this.getPositionInfo();
        localZ.sub((Tuple3d)p.pos, (Tuple3d)p.ref);
        localY.set((Tuple3d)p.up);
        localX.cross(localY, localZ);
        localX.normalize();
        localY.normalize();
        localZ.normalize();
        localX.scale(offset.x);
        localY.scale(offset.y);
        localZ.scale(offset.z);
        Vector3d newOffset = new Vector3d(0.0, 0.0, 0.0);
        newOffset.add((Tuple3d)localX);
        newOffset.add((Tuple3d)localY);
        newOffset.add((Tuple3d)localZ);
        loc.add((Tuple3d)newOffset);
    }

    public void translateEye(Vector3d offset, boolean offsetRef) {
        Vector3d localX = new Vector3d();
        Vector3d localY = new Vector3d();
        Vector3d localZ = new Vector3d();
        Position p = this.getPositionInfo();
        localZ.sub((Tuple3d)p.pos, (Tuple3d)p.ref);
        localY.set((Tuple3d)p.up);
        localX.cross(localY, localZ);
        localX.normalize();
        localY.normalize();
        localZ.normalize();
        localX.scale(offset.x);
        localY.scale(offset.y);
        localZ.scale(offset.z);
        Vector3d newOffset = new Vector3d(0.0, 0.0, 0.0);
        newOffset.add((Tuple3d)localX);
        newOffset.add((Tuple3d)localY);
        newOffset.add((Tuple3d)localZ);
        p.pos.add((Tuple3d)newOffset);
        if (offsetRef) {
            p.ref.add((Tuple3d)newOffset);
        }
        this.setPositionInfo(p);
    }

    public void translateEye(double x, double y, double z, boolean offsetRef) {
        Vector3d tmp = new Vector3d(x, y, z);
        this.translateEye(tmp, offsetRef);
    }

    public void zoomAboutPoint(double factor, Point2d locCamera) {
        this.exec(Methods.zoomAboutPoint, factor, locCamera);
        this.markDirty();
    }

    public void zoom(double factor, Point2d zoomCenterCam) {
        this.exec(Methods.zoom, factor, zoomCenterCam);
        this.markDirty();
    }

    public void setZoom(Point2d locCamera, double amount) {
        this.exec(Methods.setZoom, amount, locCamera);
        this.markDirty();
    }

    protected Pair<Double, Point2d> getFullZoom() {
        return this.exec(Methods.getZoom, (NativeManager m) -> {
            double z = Native.manager.readDouble();
            Point2d loc = nb3dUtil.readP2d(m);
            return new Pair<Double, Point2d>(z, loc);
        }, new Object[0]);
    }

    public double getZoom() {
        return (Double)this.getFullZoom().v1;
    }

    public Point2d getZoomLoc() {
        return (Point2d)this.getFullZoom().v2;
    }

    public void setPosition(Point3d pos) {
        this.exec(Methods.setPosition, pos);
        this.markDirty();
    }

    public void setPosition(double x, double y, double z) {
        this.exec(Methods.setPosition, x, y, z);
        this.markDirty();
    }

    public Point3d getPosition() {
        return this.getPositionInfo().pos;
    }

    public void setReference(Point3d ref) {
        this.exec(Methods.setReference, ref);
        this.markDirty();
    }

    public void setReference(double x, double y, double z) {
        this.exec(Methods.setReference, x, y, z);
        this.markDirty();
    }

    public Point3d getReference() {
        return this.getPositionInfo().ref;
    }

    public void setUpVector(Vector3d up) {
        this.exec(Methods.setUp, up);
        this.markDirty();
    }

    public void setUpVector(double x, double y, double z) {
        this.exec(Methods.setUp, x, y, z);
        this.markDirty();
    }

    public Vector3d getUpVector() {
        return this.getPositionInfo().up;
    }

    public void setClip(double near, double far) {
        this.exec(Methods.setClip, near, far);
    }

    public double[] getClip() {
        return this.exec(Methods.getClip, (NativeManager m) -> m.readDoubles(2), new Object[0]);
    }

    public double getNearClip() {
        return this.getClip()[0];
    }

    public double getFarClip() {
        return this.getClip()[1];
    }

    public void fitClipping(AABox box) {
        this.fitClipping(box, 0.005);
    }

    public void fitClipping(AABox box, double tol) {
        this.exec(Methods.fitClipping, box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ(), tol);
    }

    public Vector3d getViewVector() {
        Position p = this.getPositionInfo();
        Vector3d view = new Vector3d();
        view.sub((Tuple3d)p.ref, (Tuple3d)p.pos);
        return view;
    }

    public Vector3d getRightVector() {
        Vector3d up = this.getUpVector();
        Vector3d forward = this.getViewVector();
        Vector3d right = new Vector3d();
        right.cross(forward, up);
        return right;
    }

    public double getDistance() {
        return this.getViewVector().length();
    }

    public Plane3d getViewPlane() {
        Vector3d view = this.getViewVector();
        view.normalize();
        Point3d position = this.getPosition();
        double d = -position.x * view.x - position.y * view.y - position.z * view.z;
        return new Plane3d(view.x, view.y, view.z, d);
    }

    public Plane3d getRefPlane() {
        Vector3d view = this.getViewVector();
        view.normalize();
        Point3d ref = this.getReference();
        return new Plane3d(view, ref);
    }

    public Vector3d vecToPointAlongLocalAxis(Point3d point, int localAxis) {
        Vector3d axis = new Vector3d();
        switch (localAxis) {
            case 0: {
                axis.normalize(this.getViewVector());
                break;
            }
            case 2: {
                axis.normalize(this.getUpVector());
                break;
            }
            case 1: {
                axis.normalize(this.getRightVector());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Vector3d pointToCam = new Vector3d();
        pointToCam.sub((Tuple3d)point, (Tuple3d)this.getPosition());
        double length = pointToCam.dot(axis);
        axis.scale(length);
        return axis;
    }

    public Matrix3d getLocalTransformLHR() {
        Vector3d up = this.getUpVector();
        up.normalize();
        Vector3d right = this.getRightVector();
        right.normalize();
        Vector3d forward = this.getViewVector();
        forward.normalize();
        return new Matrix3d(right.x, right.y, right.z, up.x, up.y, up.z, forward.x, forward.y, forward.z);
    }

    public Matrix3d getLocalTransformRHR() {
        Matrix3d mat = this.getLocalTransformLHR();
        mat.m20 = -mat.m20;
        mat.m21 = -mat.m21;
        mat.m22 = -mat.m22;
        return mat;
    }

    protected void markDirty() {
        this.d_observable.setChanged();
        this.d_observable.notifyObservers();
    }

    protected Point3d worldToLocal(Point3d world) {
        Matrix3d mat = this.getLocalTransformRHR();
        Point3d local = new Point3d(world);
        mat.transform((Tuple3d)local);
        return local;
    }

    protected Point3d worldToView(Point3d world) {
        Point4d result = this.worldToView(new Point4d(world.x, world.y, world.z, 1.0));
        return theUtil.p4dTo3d(result);
    }

    protected Point4d worldToView(Point4d world) {
        return this.exec(Methods.worldToView, nb3dUtil::readP4d, world.x, world.y, world.z, world.w);
    }

    protected Point3d viewToWorld(Point3d view) {
        Point4d result = this.viewToWorld(new Point4d(view.x, view.y, view.z, 1.0));
        return theUtil.p4dTo3d(result);
    }

    protected Point4d viewToWorld(Point4d view) {
        return this.exec(Methods.viewToWorld, nb3dUtil::readP4d, view);
    }

    protected Point3d worldToScreen(Point3d world) {
        return this.worldToScreen(new Point4d(world.x, world.y, world.z, 1.0));
    }

    protected Point3d worldToScreen(Point4d world) {
        return this.exec(Methods.worldToScreen, nb3dUtil::readP3d, world);
    }

    protected Point3d screenToWorld(Point3d screen) {
        return this.exec(Methods.screenToWorld, nb3dUtil::readP3d, screen);
    }

    protected double screenToWorld(double lengthScreen, Point3d refWorld) {
        Point3d displayPos = this.worldToScreen(refWorld);
        return this.screenToWorld(lengthScreen, displayPos.z);
    }

    protected double screenToWorld(double lengthDisplay, double distFromCamera) {
        Point3d refWorld = this.screenToWorld(new Point3d(lengthDisplay, 0.0, distFromCamera));
        Point3d originWorld = this.screenToWorld(new Point3d(0.0, 0.0, distFromCamera));
        return refWorld.distance(originWorld);
    }

    protected Point3d viewToScreen(Point4d view) {
        return this.exec(Methods.viewToScreen, nb3dUtil::readP3d, view);
    }

    protected Point3d viewToScreen(Point3d view) {
        return this.viewToScreen(new Point4d(view.x, view.y, view.z, 1.0));
    }

    protected Point3d screenToView(Point3d screen) {
        return this.exec(Methods.screenToView, nb3dUtil::readP3d, screen);
    }

    protected double screenToView(double lengthScreen) {
        Point3d refView = this.screenToView(new Point3d(lengthScreen, 0.0, 0.0));
        Point3d originView = this.screenToView(new Point3d(0.0, 0.0, 0.0));
        return refView.distance(originView);
    }

    protected Point3d worldToCamera(Point3d world) {
        Point4d result = this.worldToCamera(new Point4d(world.x, world.y, world.z, 1.0));
        return theUtil.p4dTo3d(result);
    }

    protected Point4d worldToCamera(Point4d world) {
        return this.exec(Methods.screenToView, nb3dUtil::readP4d, world);
    }

    protected Point3d screenToCamera(Point3d screen) {
        return this.exec(Methods.screenToCamera, nb3dUtil::readP3d, screen);
    }

    public Matrix4d getTransform(int from, int to) {
        return this.exec(Methods.getMatrix, nb3dUtil::readMatrix, from, to);
    }

    public abstract CameraRecord capture();

    public void apply(CameraRecord cc) {
        this.setPosition(cc.loc);
        this.setReference(cc.ref);
        this.setUpVector(cc.up);
        this.setZoom(cc.zoomLoc, cc.zoom);
        this.setClip(cc.near, cc.far);
    }

    static {
        nb3dUtil.registerTypes();
        NativeManager.registerWriter(Position.class, (m, v) -> {
            nb3dUtil.write((INativeStream)m, (Tuple3d)v.pos);
            nb3dUtil.write((INativeStream)m, (Tuple3d)v.ref);
            nb3dUtil.write((INativeStream)m, (Tuple3d)v.up);
        });
        NativeManager.registerReader(Position.class, Camera::readPosition);
    }

    public static class Position {
        public final Point3d pos;
        public final Point3d ref;
        public final Vector3d up;

        public Position(Point3d loc, Point3d ref, Vector3d up) {
            this.pos = loc;
            this.ref = ref;
            this.up = up;
        }
    }

    private static enum Methods {
        setPositionInfo,
        getPositionInfo,
        setPosition,
        setReference,
        setUp,
        setCustomTransform,
        getCustomTransform,
        worldToView,
        viewToWorld,
        worldToScreen,
        screenToWorld,
        viewToScreen,
        screenToView,
        worldToCamera,
        screenToCamera,
        reset,
        getMatrix,
        setCopyCam,
        setClip,
        getClip,
        zoom,
        zoomAboutPoint,
        setZoom,
        getZoom,
        fitClipping;

    }
}

