/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.ILayoutManager;
import thunderheadeng.scene3d.nativebuffered.IRenderComponent;

public class BoxLayout
extends ANativeObject
implements ILayoutManager {
    public static final int FLAG_EXPAND_HORIZONTAL = 1;
    public static final int FLAG_EXPAND_VERTICAL = 2;
    public static final int FLAG_EXPAND = 3;
    public static final int FLAG_ALIGN_LEFT = 4;
    public static final int FLAG_ALIGN_RIGHT = 8;
    public static final int FLAG_ALIGN_TOP = 16;
    public static final int FLAG_ALIGN_BOTTOM = 32;

    public BoxLayout() {
        this(Orient.HORIZONTAL);
    }

    public BoxLayout(Orient orient) {
        this.setOrient(orient);
    }

    protected BoxLayout(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return BoxLayout.class;
    }

    public void add(IRenderComponent comp) {
        this.add(comp, 0);
    }

    public void add(IRenderComponent comp, int proportion) {
        this.add(comp, proportion, 0);
    }

    public void add(IRenderComponent comp, int proportion, int flags) {
        Native.manager.execMethod(BoxLayout.class, (INativeObject)this, Methods.add, comp, proportion, flags);
    }

    public void addSpacer(int size) {
        Native.manager.execMethod(BoxLayout.class, (INativeObject)this, Methods.addSpacer, size);
    }

    public void remove(IRenderComponent comp) {
        Native.manager.execMethod(BoxLayout.class, (INativeObject)this, Methods.remove, comp);
    }

    public void clear() {
        Native.manager.execMethod(BoxLayout.class, (INativeObject)this, Methods.clear, new Object[0]);
    }

    private void setOrient(Orient orient) {
        Native.manager.execMethod(BoxLayout.class, (INativeObject)this, Methods.setOrient, orient.ordinal());
    }

    private static enum Methods {
        add,
        addSpacer,
        remove,
        clear,
        setOrient;

    }

    public static enum Orient {
        VERTICAL,
        HORIZONTAL;

    }
}

